/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.AppendTransactionEvent;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogForceEvents;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionIdStore;

class BatchingTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final LogFile logFile;
    private final AppendIndexProvider appendIndexProvider;
    private final TransactionMetadataCache metadataCache;
    private final LogRotation logRotation;
    private final Panic databasePanic;
    private TransactionLogWriter transactionLogWriter;
    private int previousChecksum;

    BatchingTransactionAppender(LogFiles logFiles, TransactionIdStore transactionIdStore, Panic databasePanic, AppendIndexProvider appendIndexProvider, TransactionMetadataCache metadataCache) {
        this.logFile = logFiles.getLogFile();
        this.appendIndexProvider = appendIndexProvider;
        this.metadataCache = metadataCache;
        this.logRotation = this.logFile.getLogRotation();
        this.databasePanic = databasePanic;
        this.previousChecksum = transactionIdStore.getLastCommittedTransaction().checksum();
    }

    public void start() {
        this.transactionLogWriter = this.logFile.getTransactionLogWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(StorageEngineTransaction batch, LogAppendEvent logAppendEvent) throws IOException {
        long lastAppendIndex = 1L;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.databasePanic.assertNoPanic(IOException.class);
            try (AppendTransactionEvent appendEvent = logAppendEvent.beginAppendTransaction(1);){
                for (StorageEngineTransaction commands = batch; commands != null; commands = commands.next()) {
                    long appendIndex = this.appendIndexProvider.nextAppendIndex();
                    this.appendToLog(commands, appendIndex, logAppendEvent);
                    lastAppendIndex = appendIndex;
                }
            }
        }
        if (this.logFile.forceAfterAppend((LogForceEvents)logAppendEvent) && BatchingTransactionAppender.checkIfRotationCheckIsRequired(batch)) {
            logAppendEvent.setLogRotated(this.logRotation.rotateLogIfNeeded((LogRotateEvents)logAppendEvent));
        }
        BatchingTransactionAppender.publishAsCommitted(batch);
        return lastAppendIndex;
    }

    private static boolean checkIfRotationCheckIsRequired(StorageEngineTransaction batch) {
        return batch != null && batch.commandBatch().kernelVersion().isLessThan(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED);
    }

    private static void publishAsCommitted(StorageEngineTransaction batch) {
        while (batch != null) {
            batch.commit();
            batch = batch.next();
        }
    }

    private void appendToLog(StorageEngineTransaction commands, long appendIndex, LogAppendEvent logAppendEvent) throws IOException {
        try {
            this.transactionLogWriter.resetAppendedBytesCounter();
            this.previousChecksum = this.transactionLogWriter.append(commands.commandBatch(), commands.transactionId(), commands.chunkId(), appendIndex, this.previousChecksum, commands.previousBatchAppendIndex(), logAppendEvent);
            LogPosition logPositionBeforeCommit = this.transactionLogWriter.beforeAppendPosition();
            this.metadataCache.cacheTransactionMetadata(appendIndex, logPositionBeforeCommit);
            LogPosition logPositionAfterCommit = this.transactionLogWriter.getCurrentPosition();
            logAppendEvent.appendedBytes(this.transactionLogWriter.getAppendedBytes());
            commands.batchAppended(appendIndex, logPositionBeforeCommit, logPositionAfterCommit, this.previousChecksum);
        }
        catch (Throwable panic) {
            this.databasePanic.panic(panic);
            throw panic;
        }
    }
}

