/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.util.Preconditions;

public class SystemGraphComponents {
    private final Map<SystemGraphComponent.Name, SystemGraphComponent> componentMap;

    private SystemGraphComponents(Map<SystemGraphComponent.Name, SystemGraphComponent> componentMap) {
        this.componentMap = componentMap;
    }

    public void forEachThrowing(ThrowingConsumer<SystemGraphComponent, Exception> process) throws Exception {
        for (SystemGraphComponent component : this.componentMap.values()) {
            process.accept((Object)component);
        }
    }

    public void forEach(Consumer<SystemGraphComponent> process) {
        this.componentMap.values().forEach(process);
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return this.componentMap.values().stream().map(c -> c.detect(tx)).reduce(SystemGraphComponent.Status::with).orElse(SystemGraphComponent.Status.CURRENT);
    }

    public SystemGraphComponent.Status detect(GraphDatabaseService system) {
        return this.componentMap.values().stream().map(c -> c.detect(system)).reduce(SystemGraphComponent.Status::with).orElse(SystemGraphComponent.Status.CURRENT);
    }

    public void initializeSystemGraph(GraphDatabaseService system) {
        boolean newlyCreated;
        Preconditions.checkState((boolean)system.databaseName().equals("system"), (String)("Cannot initialize system graph on database '" + system.databaseName() + "'"));
        try (Transaction tx = system.beginTx();
             ResourceIterator nodes = tx.findNodes(SystemGraphComponent.VERSION_LABEL);){
            newlyCreated = !nodes.hasNext();
        }
        Throwable failure = null;
        for (SystemGraphComponent component : this.componentMap.values()) {
            try {
                component.initializeSystemGraph(system, newlyCreated);
            }
            catch (Exception e) {
                failure = (Exception)Exceptions.chain((Throwable)failure, (Throwable)e);
            }
        }
        if (failure != null) {
            throw new IllegalStateException("Failed to initialize system graph component: " + failure.getMessage(), failure);
        }
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        Throwable failure = null;
        for (SystemGraphComponent component : this.componentsToUpgrade(system)) {
            try {
                component.upgradeToCurrent(system);
            }
            catch (Exception e) {
                failure = (Exception)Exceptions.chain((Throwable)failure, (Throwable)e);
            }
        }
        if (failure != null) {
            throw new IllegalStateException("Failed to upgrade system graph:" + failure.getMessage(), failure);
        }
    }

    private List<SystemGraphComponent> componentsToUpgrade(GraphDatabaseService system) throws Exception {
        ArrayList<SystemGraphComponent> componentsToUpgrade = new ArrayList<SystemGraphComponent>();
        SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.componentMap.values().stream().filter(c -> {
            SystemGraphComponent.Status status = c.detect((Transaction)tx);
            return status == SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE || status == SystemGraphComponent.Status.REQUIRES_UPGRADE || status == SystemGraphComponent.Status.UNINITIALIZED;
        }).forEach(componentsToUpgrade::add)));
        return componentsToUpgrade;
    }

    public static final class UpgradeCheckResult {
        public static final UpgradeCheckResult UPGRADE_NOT_NECESSARY = new UpgradeCheckResult(false, null);
        public static final UpgradeCheckResult UPGRADE_NECESSARY = new UpgradeCheckResult(true, null);
        private final boolean upgradeNecessary;
        private final String whyUpgradeNotAllowed;

        public static UpgradeCheckResult upgradeNotAllowed(String message) {
            Objects.requireNonNull(message);
            return new UpgradeCheckResult(false, message);
        }

        private UpgradeCheckResult(boolean upgradeNecessary, String whyUpgradeNotAllowed) {
            this.upgradeNecessary = upgradeNecessary;
            this.whyUpgradeNotAllowed = whyUpgradeNotAllowed;
        }

        public boolean upgradeAllowed() {
            return this.whyUpgradeNotAllowed == null;
        }

        public boolean upgradeNecessary() {
            return this.upgradeNecessary;
        }

        public String whyUpgradeNotAllowed() {
            return this.whyUpgradeNotAllowed;
        }

        public String toString() {
            return "UpgradeCheckResult{" + (String)(this.upgradeAllowed() ? (this.upgradeNecessary ? "Upgrade necessary" : "Upgrade not necessary") : "Upgrade not allowed: " + this.whyUpgradeNotAllowed) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpgradeCheckResult that = (UpgradeCheckResult)o;
            return this.upgradeNecessary == that.upgradeNecessary && Objects.equals(this.whyUpgradeNotAllowed, that.whyUpgradeNotAllowed);
        }

        public int hashCode() {
            return Objects.hash(this.upgradeNecessary, this.whyUpgradeNotAllowed);
        }
    }

    @FunctionalInterface
    public static interface UpgradeChecker {
        public static final UpgradeChecker UPGRADE_ALWAYS_ALLOWED = () -> UpgradeCheckResult.UPGRADE_NECESSARY;

        public UpgradeCheckResult upgradeCheck();
    }

    public static class DefaultBuilder
    extends Builder {
        @Override
        public void register(SystemGraphComponent component) {
            if (this.componentMap.containsKey(component.componentName())) {
                throw new IllegalStateException("Duplicate component registration: " + component.componentName().name());
            }
            this.componentMap.put(component.componentName(), component);
        }
    }

    public static abstract class Builder {
        protected final Map<SystemGraphComponent.Name, SystemGraphComponent> componentMap = new LinkedHashMap<SystemGraphComponent.Name, SystemGraphComponent>();

        public abstract void register(SystemGraphComponent var1);

        public SystemGraphComponents build() {
            return new SystemGraphComponents(this.componentMap);
        }
    }
}

