/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadUtils;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RangeLogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfoFactory;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.DetachedLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.util.VisibleForTesting;

public class CheckpointLogFile
extends LifecycleAdapter
implements CheckpointFile {
    private final DetachedCheckpointAppender checkpointAppender;
    private final DetachedLogTailScanner logTailScanner;
    private final TransactionLogFilesHelper fileHelper;
    private final TransactionLogChannelAllocator channelAllocator;
    private final LogFiles logFiles;
    private final TransactionLogFilesContext context;
    private final InternalLog log;
    private final long rotationsSize;
    private final LogTailScannerMonitor monitor;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private LogVersionRepository logVersionRepository;
    private volatile boolean started;

    public CheckpointLogFile(LogFiles logFiles, TransactionLogFilesContext context) {
        this.context = context;
        this.logFiles = logFiles;
        this.rotationsSize = context.getCheckpointRotationThreshold();
        this.fileHelper = TransactionLogFilesHelper.forCheckpoints((FileSystemAbstraction)context.getFileSystem(), (Path)logFiles.logFilesDirectory());
        this.channelAllocator = new CheckpointLogChannelAllocator(context, this.fileHelper);
        this.monitor = (LogTailScannerMonitor)context.getMonitors().newMonitor(LogTailScannerMonitor.class, new String[0]);
        this.logTailScanner = new DetachedLogTailScanner(logFiles, context, this, this.monitor);
        this.log = context.getLogProvider().getLog(this.getClass());
        LogRotationMonitor rotationMonitor = (LogRotationMonitor)context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0]);
        LogRotation checkpointRotation = FileLogRotation.checkpointLogRotation(this, logFiles.getLogFile(), context.getClock(), (Panic)context.getDatabaseHealth(), rotationMonitor);
        this.binarySupportedKernelVersions = context.getBinarySupportedKernelVersions();
        this.checkpointAppender = new DetachedCheckpointAppender(logFiles, this.channelAllocator, context, this, checkpointRotation, this.logTailScanner, this.binarySupportedKernelVersions);
    }

    public void start() throws Exception {
        this.checkpointAppender.start();
        this.logVersionRepository = this.context.getLogVersionRepositoryProvider().logVersionRepository(this.logFiles);
        this.started = true;
    }

    public void shutdown() throws Exception {
        this.checkpointAppender.shutdown();
        this.started = false;
    }

    @Override
    public Optional<CheckpointInfo> findLatestCheckpoint() throws IOException {
        return this.findLatestCheckpoint(this.log);
    }

    @Override
    public Optional<CheckpointInfo> findLatestCheckpoint(InternalLog log) throws IOException {
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        long highestVersion = versionVisitor.getHighestVersion();
        if (highestVersion < 0L) {
            return Optional.empty();
        }
        byte lastObservedKernelVersion = 0;
        LogPosition lastCheckpointLocation = null;
        long lowestVersion = versionVisitor.getLowestVersion();
        VersionAwareLogEntryReader checkpointReader = new VersionAwareLogEntryReader(CommandReaderFactory.NO_COMMANDS, true, this.binarySupportedKernelVersions);
        for (long currentVersion = highestVersion; currentVersion >= lowestVersion; --currentVersion) {
            CheckpointEntryInfo checkpointEntry = null;
            Path currentCheckpointFile = this.getDetachedCheckpointFileForVersion(currentVersion);
            FileSystemAbstraction fileSystem = this.context.getFileSystem();
            LogHeader header = LogHeaderReader.readLogHeader(fileSystem, currentCheckpointFile, false, this.context.getMemoryTracker());
            if (header != null) {
                try (PhysicalLogVersionedStoreChannel channel = this.channelAllocator.openLogChannel(currentVersion);
                     ReadableLogChannel reader = ReadAheadUtils.newChannel((LogVersionedStoreChannel)channel, this.logHeader(channel), this.context.getMemoryTracker());
                     LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)checkpointReader, (ReadableLogPositionAwareChannel)reader);){
                    log.info("Scanning log file with version %d for checkpoint entries", new Object[]{currentVersion});
                    try {
                        Object checkpoint;
                        lastCheckpointLocation = reader.getCurrentLogPosition();
                        while (logEntryCursor.next()) {
                            checkpoint = (AbstractVersionAwareLogEntry)logEntryCursor.get();
                            lastObservedKernelVersion = checkpoint.kernelVersion().version();
                            checkpointEntry = new CheckpointEntryInfo((LogEntry)checkpoint, lastCheckpointLocation, reader.getCurrentLogPosition());
                            lastCheckpointLocation = checkpointEntry.channelPositionAfterCheckpoint;
                        }
                        if (checkpointEntry == null) continue;
                        checkpoint = Optional.of(this.createCheckpointInfo(checkpointEntry, reader));
                        return checkpoint;
                    }
                    catch (Error | ClosedByInterruptException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        if (t instanceof UnsupportedLogVersionException) {
                            UnsupportedLogVersionException e = (UnsupportedLogVersionException)t;
                            lastObservedKernelVersion = e.getKernelVersion();
                        }
                        this.monitor.corruptedCheckpointFile(currentVersion, t);
                        if (checkpointEntry == null) continue;
                        Optional<CheckpointInfo> optional = Optional.of(this.createCheckpointInfo(checkpointEntry, reader));
                        return optional;
                    }
                }
            }
            if (this.context.isReadOnly()) continue;
            log.info("Checkpoint log file `%s` does not have any readable header available.", new Object[]{currentCheckpointFile});
            if (this.started) {
                throw new IllegalStateException("When checkpoint file was already started we should never be in the state to remove partially created files. But file: " + currentCheckpointFile + " claims to have no header.");
            }
            this.verifyLastFile(fileSystem, currentVersion, currentCheckpointFile);
            this.verifyNoMoreDataAvailableInFile(fileSystem, currentCheckpointFile);
            log.info("Checkpoint log file `%s` is present but does not contain any data. Cleaning up.", new Object[]{currentCheckpointFile});
            fileSystem.deleteFile(currentCheckpointFile);
        }
        if (lastObservedKernelVersion != 0) {
            return Optional.of(new CheckpointInfo(LogPosition.UNSPECIFIED, LogPosition.UNSPECIFIED, null, lastCheckpointLocation, lastCheckpointLocation, LogPosition.UNSPECIFIED, null, lastObservedKernelVersion, null, 1L, "Corrupt checkpoint file"));
        }
        return Optional.empty();
    }

    private void verifyNoMoreDataAvailableInFile(FileSystemAbstraction fileSystem, Path currentCheckpointFile) throws IOException {
        try (StoreChannel channel = fileSystem.read(currentCheckpointFile);
             HeapScopedBuffer scopedBuffer = new HeapScopedBuffer((int)Math.min(fileSystem.getFileSize(currentCheckpointFile), ByteUnit.kibiBytes((long)10L)), ByteOrder.LITTLE_ENDIAN, this.context.getMemoryTracker());){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            channel.readAll(buffer);
            buffer.flip();
            if (buffer.capacity() > LogFormat.BIGGEST_HEADER) {
                buffer.position(LogFormat.BIGGEST_HEADER);
                while (buffer.hasRemaining()) {
                    if (buffer.get() == 0) continue;
                    throw new IllegalStateException("Checkpoint file: `" + currentCheckpointFile + "` has unreadable header but looks like it also contains some checkpoint data. Restore from the backup is required.");
                }
            }
        }
    }

    private void verifyLastFile(FileSystemAbstraction fileSystem, long currentVersion, Path currentCheckpointFile) {
        if (fileSystem.fileExists(this.getDetachedCheckpointFileForVersion(currentVersion + 1L))) {
            throw new IllegalStateException("Not the last checkpoint file in a sequence contains corrupted header. File with corrupted header : " + currentCheckpointFile);
        }
    }

    private CheckpointInfo createCheckpointInfo(CheckpointEntryInfo checkpointEntry, ReadableLogChannel reader) throws IOException {
        return CheckpointInfoFactory.ofLogEntry(checkpointEntry.checkpoint, checkpointEntry.checkpointEntryPosition, checkpointEntry.channelPositionAfterCheckpoint, reader.getCurrentLogPosition(), this.context, this.logFiles.getLogFile());
    }

    @Override
    public List<CheckpointInfo> reachableCheckpoints() throws IOException {
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        if (versionVisitor.getHighestVersion() < 0L) {
            return Collections.emptyList();
        }
        long currentVersion = versionVisitor.getLowestVersion();
        VersionAwareLogEntryReader checkpointReader = new VersionAwareLogEntryReader(CommandReaderFactory.NO_COMMANDS, true, this.binarySupportedKernelVersions);
        ArrayList<CheckpointInfo> checkpoints = new ArrayList<CheckpointInfo>();
        LogVersionBridge readerBridge = ReaderLogVersionBridge.forFile(this);
        try (PhysicalLogVersionedStoreChannel channel = this.channelAllocator.openLogChannel(currentVersion);
             ReadableLogChannel reader = ReadAheadUtils.newChannel((LogVersionedStoreChannel)channel, readerBridge, this.logHeader(channel), this.context.getMemoryTracker());
             LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)checkpointReader, (ReadableLogPositionAwareChannel)reader);){
            this.log.info("Start scanning log files from version %d for checkpoint entries", new Object[]{currentVersion});
            this.readCheckpoints(reader, logEntryCursor, checkpoints);
        }
        return checkpoints;
    }

    private void readCheckpoints(ReadableLogChannel reader, LogEntryCursor logEntryCursor, List<CheckpointInfo> checkpoints) throws IOException {
        LogPosition lastCheckpointLocation;
        LogPosition lastLocation = lastCheckpointLocation = reader.getCurrentLogPosition();
        while (logEntryCursor.next()) {
            lastCheckpointLocation = lastLocation;
            LogEntry checkpoint = logEntryCursor.get();
            lastLocation = reader.getCurrentLogPosition();
            checkpoints.add(CheckpointInfoFactory.ofLogEntry(checkpoint, lastCheckpointLocation, lastLocation, lastLocation, this.context, this.logFiles.getLogFile()));
        }
    }

    private LogHeader logHeader(PhysicalLogVersionedStoreChannel channel) throws IOException {
        return this.channelAllocator.readLogHeaderForVersion(channel.getLogVersion());
    }

    @Override
    public List<CheckpointInfo> getReachableDetachedCheckpoints() throws IOException {
        return this.reachableCheckpoints();
    }

    @Override
    public CheckpointAppender getCheckpointAppender() {
        return this.checkpointAppender;
    }

    @Override
    public LogTailMetadata getTailMetadata() {
        return this.logTailScanner.getTailMetadata();
    }

    @Override
    public Path getCurrentFile() throws IOException {
        return this.fileHelper.getLogFileForVersion(this.getCurrentDetachedLogVersion());
    }

    @Override
    public Path getDetachedCheckpointFileForVersion(long logVersion) {
        return this.fileHelper.getLogFileForVersion(logVersion);
    }

    @Override
    public Path[] getDetachedCheckpointFiles() throws IOException {
        return this.fileHelper.getMatchedFiles();
    }

    @Override
    public long getCurrentDetachedLogVersion() throws IOException {
        if (this.logVersionRepository != null) {
            return this.logVersionRepository.getCheckpointLogVersion();
        }
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        return versionVisitor.getHighestVersion();
    }

    @Override
    public long getDetachedCheckpointLogFileVersion(Path checkpointLogFile) {
        return TransactionLogFilesHelper.getLogVersion((Path)checkpointLogFile);
    }

    @Override
    public boolean rotationNeeded() {
        long position = this.checkpointAppender.getCurrentPosition();
        return position >= this.rotationsSize;
    }

    @Override
    public synchronized Path rotate() throws IOException {
        return this.checkpointAppender.rotate();
    }

    @Override
    public Path rotate(KernelVersion kernelVersion, long lastAppendIndex, int checksum) throws IOException {
        throw new UnsupportedOperationException("Checkpoint log does not support this type of rotation");
    }

    @Override
    public Path rotate(KernelVersion kernelVersion) throws IOException {
        return this.checkpointAppender.rotate(kernelVersion);
    }

    @Override
    public long rotationSize() {
        return this.rotationsSize;
    }

    @Override
    public long getLowestLogVersion() {
        return this.visitLogFiles(new RangeLogVersionVisitor()).getLowestVersion();
    }

    @Override
    public PhysicalLogVersionedStoreChannel openForVersion(long checkpointLogVersion) throws IOException {
        return this.channelAllocator.openLogChannel(checkpointLogVersion);
    }

    @Override
    public long getHighestLogVersion() {
        return this.visitLogFiles(new RangeLogVersionVisitor()).getHighestVersion();
    }

    @VisibleForTesting
    public DetachedLogTailScanner getLogTailScanner() {
        return this.logTailScanner;
    }

    private <V extends LogVersionVisitor> V visitLogFiles(V visitor) {
        try {
            for (Path file : this.fileHelper.getMatchedFiles()) {
                visitor.visit(file, TransactionLogFilesHelper.getLogVersion((Path)file));
            }
            return visitor;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private record CheckpointEntryInfo(LogEntry checkpoint, LogPosition checkpointEntryPosition, LogPosition channelPositionAfterCheckpoint) {
    }
}

