/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualPathValue;

public class PathWrappingPathValue
extends PathValue {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PathWrappingPathValue.class);
    private final Path path;

    PathWrappingPathValue(Path path) {
        this.path = path;
    }

    public final long startNodeId() {
        return this.path.startNode().getId();
    }

    public final long endNodeId() {
        return this.path.endNode().getId();
    }

    public NodeValue startNode() {
        return (NodeValue)ValueUtils.wrapNodeEntity(this.path.startNode());
    }

    public NodeValue endNode() {
        return (NodeValue)ValueUtils.wrapNodeEntity(this.path.endNode());
    }

    public NodeValue[] nodes() {
        int length = this.path.length() + 1;
        NodeValue[] values = new NodeValue[length];
        int i = 0;
        for (Node node : this.path.nodes()) {
            values[i++] = (NodeValue)ValueUtils.wrapNodeEntity(node);
        }
        return values;
    }

    public RelationshipValue[] relationships() {
        int length = this.path.length();
        RelationshipValue[] values = new RelationshipValue[length];
        int i = 0;
        for (Relationship relationship : this.path.relationships()) {
            values[i++] = (RelationshipValue)ValueUtils.wrapRelationshipEntity(relationship);
        }
        return values;
    }

    public int size() {
        return this.path.length();
    }

    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other instanceof PathWrappingPathValue) {
            PathWrappingPathValue otherPath = (PathWrappingPathValue)other;
            return this.unsafeCompareTo(otherPath);
        }
        if (other instanceof VirtualPathValue) {
            VirtualPathValue otherPath = (VirtualPathValue)other;
            return this.unsafeCompareTo(otherPath);
        }
        return super.unsafeCompareTo(other, comparator);
    }

    private int unsafeCompareTo(PathWrappingPathValue otherPath) {
        int x = Long.compare(this.startNodeId(), otherPath.startNodeId());
        if (x == 0) {
            int thisSize = this.size();
            int otherSize = otherPath.size();
            int commonLength = Math.min(thisSize, otherSize);
            Iterator relIterator = this.path.relationships().iterator();
            Iterator otherRelIterator = otherPath.path.relationships().iterator();
            for (int i = 0; x == 0 && i < commonLength; ++i) {
                long relationshipId = ((Relationship)relIterator.next()).getId();
                long otherRelationshipId = ((Relationship)otherRelIterator.next()).getId();
                x = Long.compare(relationshipId, otherRelationshipId);
            }
            if (x == 0) {
                x = Integer.compare(thisSize, otherSize);
            }
        }
        return x;
    }

    private int unsafeCompareTo(VirtualPathValue otherPath) {
        int x = Long.compare(this.startNodeId(), otherPath.startNodeId());
        if (x == 0) {
            int thisSize = this.size();
            int otherSize = otherPath.size();
            int commonLength = Math.min(thisSize, otherSize);
            Iterator relIterator = this.path.relationships().iterator();
            for (int i = 0; x == 0 && i < commonLength; ++i) {
                long relationshipId = ((Relationship)relIterator.next()).getId();
                long otherRelationshipId = otherPath.relationshipId(i);
                x = Long.compare(relationshipId, otherRelationshipId);
            }
            if (x == 0) {
                x = Integer.compare(thisSize, otherSize);
            }
        }
        return x;
    }

    public boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualPathValue)) {
            return false;
        }
        VirtualPathValue that = (VirtualPathValue)other;
        if (this.size() == that.size() && this.startNodeId() == that.startNodeId()) {
            if (other instanceof PathWrappingPathValue) {
                PathWrappingPathValue thatPathWrappingPathValue = (PathWrappingPathValue)other;
                return this.relationshipIdsEquals(thatPathWrappingPathValue);
            }
            return this.relationshipIdsEquals(that);
        }
        return false;
    }

    protected int computeHashToMemoize() {
        int result = this.path.startNode().hashCode();
        for (Relationship relationship : this.path.relationships()) {
            result += 31 * (result + relationship.hashCode());
        }
        return result;
    }

    private boolean relationshipIdsEquals(PathWrappingPathValue other) {
        Iterator relIterator = this.path.relationships().iterator();
        Iterator otherRelIterator = other.path.relationships().iterator();
        while (relIterator.hasNext()) {
            Relationship rel = (Relationship)relIterator.next();
            Relationship otherRel = (Relationship)otherRelIterator.next();
            if (rel.getId() == otherRel.getId()) continue;
            return false;
        }
        return true;
    }

    private boolean relationshipIdsEquals(VirtualPathValue other) {
        int i = 0;
        for (Relationship relationship : this.path.relationships()) {
            if (relationship.getId() != other.relationshipId(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final long relationshipId(int index) {
        Iterable relationships = this.path.relationships();
        if (relationships instanceof List) {
            return ((Relationship)((List)relationships).get(index)).getId();
        }
        int i = 0;
        for (Relationship relationship : relationships) {
            if (i == index) {
                return relationship.getId();
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public Path path() {
        return this.path;
    }

    public long estimatedHeapUsage() {
        int length = this.path.length();
        return SHALLOW_SIZE + (long)length * RelationshipEntityWrappingValue.SHALLOW_SIZE + (long)(length + 1) * NodeEntityWrappingNodeValue.SHALLOW_SIZE;
    }
}

