/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.apache.commons.lang3.ArrayUtils;

public class LogIndexEncoding {
    private LogIndexEncoding() {
    }

    public static byte[] encodeLogIndex(long logIndex) {
        if (logIndex == -1L) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)logIndex;
            logIndex >>>= 8;
        }
        b[0] = (byte)logIndex;
        return b;
    }

    public static long decodeLogIndex(byte[] bytes) {
        if (bytes.length == 0) {
            return -1L;
        }
        if (bytes.length < 8) {
            throw new IllegalArgumentException("Unable to decode log index from the transaction header.");
        }
        long logIndex = 0L;
        for (int i = 0; i < 8; ++i) {
            logIndex <<= 8;
            logIndex ^= (long)(bytes[i] & 0xFF);
        }
        return logIndex;
    }
}

