/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.impl.device.DeviceMapperService;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class KernelDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    public static final String DATABASES_REPORT_BASE_DIR = "databases";
    private FileSystemAbstraction fs;
    private Config config;
    private Set<String> databaseNames;
    private Neo4jLayout neo4jLayout;

    public KernelDiagnosticsOfflineReportProvider() {
        super("logs", "plugins", "tree", "tx", "version");
    }

    @Override
    public void init(FileSystemAbstraction fs, Config config, Set<String> databaseNames) {
        this.fs = fs;
        this.config = config;
        this.databaseNames = databaseNames;
        this.neo4jLayout = Neo4jLayout.of((Configuration)config);
    }

    @Override
    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        ArrayList<DiagnosticsReportSource> sources = new ArrayList<DiagnosticsReportSource>();
        if (classifiers.contains("logs")) {
            this.getLogFiles(sources);
        }
        if (classifiers.contains("plugins")) {
            this.listPlugins(sources);
        }
        if (classifiers.contains("tree")) {
            for (String databaseName : this.databaseNames) {
                this.listDataDirectory(sources, databaseName);
            }
        }
        if (classifiers.contains("tx")) {
            for (String databaseName : this.databaseNames) {
                this.getTransactionLogFiles(sources, databaseName);
            }
        }
        if (classifiers.contains("version")) {
            KernelDiagnosticsOfflineReportProvider.getVersion(sources);
        }
        return sources;
    }

    private static void getVersion(List<DiagnosticsReportSource> sources) {
        Supplier<String> neo4jVersion = () -> "neo4j " + Version.getNeo4jVersion() + System.lineSeparator();
        sources.add(DiagnosticsReportSources.newDiagnosticsString("version.txt", neo4jVersion));
    }

    private void listPlugins(List<DiagnosticsReportSource> sources) {
        Path pluginDirectory = (Path)this.config.get(GraphDatabaseSettings.plugin_dir);
        if (this.fs.fileExists(pluginDirectory)) {
            StringBuilder sb = new StringBuilder();
            sb.append("List of plugin directory:").append(System.lineSeparator());
            try {
                this.listContentOfDirectory(pluginDirectory, "  ", sb);
            }
            catch (IOException e) {
                sb.append(e.getMessage()).append(System.lineSeparator());
            }
            sources.add(DiagnosticsReportSources.newDiagnosticsString("plugins.txt", sb::toString));
        }
    }

    private void listContentOfDirectory(Path directory, String prefix, StringBuilder sb) throws IOException {
        Path[] files;
        if (!this.fs.isDirectory(directory)) {
            return;
        }
        for (Path file : files = this.fs.listFiles(directory)) {
            if (this.fs.isDirectory(file)) {
                this.listContentOfDirectory(file, prefix + file.getFileSystem().getSeparator() + String.valueOf(file.getFileName()), sb);
                continue;
            }
            sb.append(prefix).append(file.getFileName()).append(System.lineSeparator());
        }
    }

    private void listDataDirectory(List<DiagnosticsReportSource> sources, String databaseName) {
        DatabaseLayout databaseLayout = DatabaseLayout.of((Neo4jLayout)this.neo4jLayout, (String)databaseName);
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fs, (DatabaseLayout)databaseLayout, null);
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, this.fs, databaseLayout, KernelDiagnosticsOfflineReportProvider.loadDeviceMapper());
        ArrayList files = new ArrayList();
        storeFiles.dump(files::add);
        sources.add(DiagnosticsReportSources.newDiagnosticsString(String.join((CharSequence)"/", DATABASES_REPORT_BASE_DIR, databaseName, "tree.txt"), () -> String.join((CharSequence)System.lineSeparator(), files)));
    }

    private static DeviceMapper loadDeviceMapper() {
        return DeviceMapperService.getInstance().createDeviceMapper((InternalLogProvider)NullLogProvider.getInstance());
    }

    private void getLogFiles(List<DiagnosticsReportSource> sources) {
        Path gcLog;
        Path neo4jLog;
        Path logDirectory = (Path)this.config.get(GraphDatabaseSettings.logs_directory);
        Path debugLogFile = logDirectory.resolve("debug.log");
        if (this.fs.fileExists(debugLogFile)) {
            sources.addAll(DiagnosticsReportSources.newDiagnosticsRotatingFile("logs/", this.fs, debugLogFile));
        }
        if (this.fs.fileExists(neo4jLog = logDirectory.resolve("neo4j.log"))) {
            sources.addAll(DiagnosticsReportSources.newDiagnosticsRotatingFile("logs/", this.fs, neo4jLog));
        }
        if (this.fs.fileExists(gcLog = logDirectory.resolve("gc.log"))) {
            sources.addAll(DiagnosticsReportSources.newDiagnosticsRotatingFile("logs/", this.fs, gcLog));
        }
    }

    private void getTransactionLogFiles(List<DiagnosticsReportSource> sources, String databaseName) {
        try {
            DatabaseLayout databaseLayout = DatabaseLayout.of((Neo4jLayout)this.neo4jLayout, (String)databaseName);
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(databaseLayout.getTransactionLogsDirectory(), this.fs).build();
            for (Path file : logFiles.logFiles()) {
                sources.add(DiagnosticsReportSources.newDiagnosticsFile(String.join((CharSequence)"/", DATABASES_REPORT_BASE_DIR, databaseName, "tx", file.getFileName().toString()), this.fs, file));
            }
        }
        catch (IOException e) {
            sources.add(DiagnosticsReportSources.newDiagnosticsString(String.join((CharSequence)"/", DATABASES_REPORT_BASE_DIR, databaseName, "tx.txt"), () -> "Error getting tx logs: " + e.getMessage()));
        }
    }
}

