/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogForceEvent;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryDetachedCheckpointV5_20;
import org.neo4j.kernel.impl.transaction.log.entry.v522.LogEntryDetachedCheckpointV5_22;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.DetachedLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointAppender
extends LifecycleAdapter
implements CheckpointAppender {
    private final LogFiles logFiles;
    private final CheckpointFile checkpointFile;
    private final TransactionLogChannelAllocator channelAllocator;
    private final TransactionLogFilesContext context;
    private final Panic databasePanic;
    private final LogRotation logRotation;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final InternalLog log;
    private final DetachedLogTailScanner logTailScanner;
    private StoreId storeId;
    private PhysicalFlushableLogPositionAwareChannel writer;
    private NativeScopedBuffer buffer;
    private PhysicalLogVersionedStoreChannel channel;
    private LogVersionRepository logVersionRepository;
    private KernelVersion previousKernelVersion;

    public DetachedCheckpointAppender(LogFiles logFiles, TransactionLogChannelAllocator channelAllocator, TransactionLogFilesContext context, CheckpointFile checkpointFile, LogRotation checkpointRotation, DetachedLogTailScanner logTailScanner, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this.logFiles = logFiles;
        this.checkpointFile = Objects.requireNonNull(checkpointFile);
        this.context = Objects.requireNonNull(context);
        this.channelAllocator = Objects.requireNonNull(channelAllocator);
        this.databasePanic = (Panic)Objects.requireNonNull(context.getDatabaseHealth());
        this.logRotation = Objects.requireNonNull(checkpointRotation);
        this.log = context.getLogProvider().getLog(DetachedCheckpointAppender.class);
        this.logTailScanner = logTailScanner;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
    }

    public void start() throws IOException {
        this.storeId = this.context.getStoreId();
        this.logVersionRepository = Objects.requireNonNull(this.context.getLogVersionRepositoryProvider().logVersionRepository(this.logFiles));
        long currentLogVersion = this.logVersionRepository.getCheckpointLogVersion();
        this.channel = this.channelAllocator.createLogChannel(currentLogVersion, 0L, -559063315, this.context.getKernelVersionProvider());
        ((LogRotationMonitor)this.context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0])).started(this.channel.getPath(), currentLogVersion);
        this.seekCheckpointChannel(currentLogVersion);
        this.buffer = new NativeScopedBuffer(this.context.getBufferSizeBytes(), ByteOrder.LITTLE_ENDIAN, this.context.getMemoryTracker());
        PhysicalFlushableLogPositionAwareChannel.VersionedPhysicalFlushableLogChannelProvider checksumChannelProvider = new PhysicalFlushableLogPositionAwareChannel.VersionedPhysicalFlushableLogChannelProvider(this.logRotation, this.context.getDatabaseTracers().getDatabaseTracer(), (ScopedBuffer)this.buffer);
        this.writer = new PhysicalFlushableLogPositionAwareChannel((LogVersionedStoreChannel)this.channel, this.logHeader(currentLogVersion), checksumChannelProvider);
    }

    private LogHeader logHeader(long logVersion) throws IOException {
        return this.channelAllocator.readLogHeaderForVersion(logVersion);
    }

    private void seekCheckpointChannel(long expectedVersion) throws IOException {
        Optional lastCheckPoint;
        LogTailMetadata tailMetadata = this.logTailScanner.getTailMetadata();
        if (tailMetadata.hasUnreadableBytesInCheckpointLogs()) {
            // empty if block
        }
        if ((lastCheckPoint = tailMetadata.getLastCheckPoint()).isEmpty()) {
            LogHeader logHeader = this.logHeader(this.channel.getLogVersion());
            this.channel.position(logHeader.getStartPosition().getByteOffset());
            KernelVersion logHeaderKernelVersion = logHeader.getKernelVersion();
            this.previousKernelVersion = logHeaderKernelVersion != null ? logHeaderKernelVersion : this.context.getKernelVersionProvider().kernelVersion();
            return;
        }
        LogPosition channelPosition = ((CheckpointInfo)lastCheckPoint.get()).channelPositionAfterCheckpoint();
        if (channelPosition.getLogVersion() != expectedVersion) {
            throw new IllegalStateException("Expected version of checkpoint log " + expectedVersion + ", does not match to found tail version " + channelPosition.getLogVersion());
        }
        this.channel.position(channelPosition.getByteOffset());
        this.previousKernelVersion = ((CheckpointInfo)lastCheckPoint.get()).kernelVersion();
    }

    public void shutdown() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writer, this.buffer, this.channel});
        this.writer = null;
        this.buffer = null;
        this.channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPoint(LogCheckPointEvent logCheckPointEvent, TransactionId transactionId, long appendIndex, KernelVersion kernelVersion, LogPosition oldestNotCompletedPosition, LogPosition checkpointedLogPosition, Instant checkpointTime, String reason) throws IOException {
        if (this.writer == null) {
            this.log.warn("Checkpoint was attempted while appender is not started. No checkpoint record will be appended.");
            return;
        }
        CheckpointFile checkpointFile = this.checkpointFile;
        synchronized (checkpointFile) {
            try {
                this.databasePanic.assertNoPanic(IOException.class);
                this.rotateIfNeeded(logCheckPointEvent, kernelVersion);
                this.writer.resetAppendedBytesCounter();
                LogEntrySerializationSets.serializationSet((KernelVersion)kernelVersion, (BinarySupportedKernelVersions)this.binarySupportedKernelVersions).select((byte)9).write((WritableChannel)this.writer, (LogEntry)DetachedCheckpointAppender.createCheckpointEntry(transactionId, appendIndex, kernelVersion, oldestNotCompletedPosition, checkpointedLogPosition, checkpointTime, reason, this.storeId));
                logCheckPointEvent.appendedBytes(this.writer.getAppendedBytes());
                this.forceAfterAppend(logCheckPointEvent);
            }
            catch (Throwable cause) {
                this.databasePanic.panic(cause);
                throw cause;
            }
        }
    }

    private void rotateIfNeeded(LogCheckPointEvent logCheckPointEvent, KernelVersion kernelVersion) throws IOException {
        boolean newKernelVersion;
        boolean bl = newKernelVersion = kernelVersion != this.previousKernelVersion;
        if (newKernelVersion) {
            if (kernelVersion.isLessThan(this.previousKernelVersion)) {
                if (kernelVersion.isAtLeast(KernelVersion.CLUSTER_FALLBACK_IN_RAW)) {
                    throw new IllegalStateException("Can not rotate checkpoint log - supplied kernel version (%s) is lower than previously seen (%s)".formatted(kernelVersion.name(), this.previousKernelVersion.name()));
                }
                newKernelVersion = false;
            }
            this.previousKernelVersion = kernelVersion;
        }
        this.logRotation.locklessRotateLogIfNeeded((LogRotateEvents)logCheckPointEvent, kernelVersion, newKernelVersion);
    }

    public long getCurrentPosition() {
        return this.channel.position();
    }

    private void forceAfterAppend(LogCheckPointEvent logCheckPointEvent) throws IOException {
        try (LogForceEvent ignored = logCheckPointEvent.beginLogForce();){
            this.writer.prepareForFlush().flush();
        }
    }

    public Path rotate() throws IOException {
        this.channel = this.rotateChannel(this.channel, this.context.getKernelVersionProvider());
        this.writer.setChannel((LogVersionedStoreChannel)this.channel, this.logHeader(this.channel.getLogVersion()));
        return this.channel.getPath();
    }

    public Path rotate(KernelVersion kernelVersion) throws IOException {
        this.channel = this.rotateChannel(this.channel, () -> kernelVersion);
        this.writer.setChannel((LogVersionedStoreChannel)this.channel, this.logHeader(this.channel.getLogVersion()));
        return this.channel.getPath();
    }

    private PhysicalLogVersionedStoreChannel rotateChannel(PhysicalLogVersionedStoreChannel channel, KernelVersionProvider kernelVersionProvider) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetCheckpointLogVersion();
        this.writer.prepareForFlush().flush();
        long endSize = channel.position();
        channel.truncate(endSize);
        int checksum = this.writer.currentChecksum().orElse(-559063315);
        PhysicalLogVersionedStoreChannel newChannel = this.channelAllocator.createLogChannel(newLogVersion, 0L, checksum, kernelVersionProvider);
        channel.close();
        return newChannel;
    }

    private static AbstractVersionAwareLogEntry createCheckpointEntry(TransactionId transactionId, long appendIndex, KernelVersion kernelVersion, LogPosition oldestNotCompletedPosition, LogPosition checkpoinedLogPosition, Instant checkpointTime, String reason, StoreId storeId) {
        if (kernelVersion.isAtLeast(KernelVersion.VERSION_CHECKPOINT_NOT_COMPLETED_POSITION_INTRODUCED)) {
            return new LogEntryDetachedCheckpointV5_22(kernelVersion, transactionId, appendIndex, oldestNotCompletedPosition, checkpoinedLogPosition, checkpointTime.toEpochMilli(), storeId, reason);
        }
        if (kernelVersion.isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED)) {
            return new LogEntryDetachedCheckpointV5_20(kernelVersion, transactionId, appendIndex, checkpoinedLogPosition, checkpointTime.toEpochMilli(), storeId, reason);
        }
        return new LogEntryDetachedCheckpointV5_0(kernelVersion, transactionId, checkpoinedLogPosition, checkpointTime.toEpochMilli(), storeId, reason);
    }
}

