/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.collection.diffset.LongDiffSets;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.ReadSecurityPropertyProvider;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.TraceableCursorImpl;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.util.EagerDegrees;
import org.neo4j.storageengine.util.SingleDegree;

class DefaultNodeCursor
extends TraceableCursorImpl<DefaultNodeCursor>
implements NodeCursor {
    final StorageNodeCursor storeCursor;
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    Read read;
    TxStateHolder txStateHolder;
    AccessModeProvider accessModeProvider;
    boolean checkHasChanges;
    boolean hasChanges;
    private LongIterator addedNodes;
    private boolean singleIsAddedInTx;
    private StorageNodeCursor securityStoreNodeCursor;
    private StorageRelationshipTraversalCursor securityStoreRelationshipCursor;
    private StoragePropertyCursor securityPropertyCursor;
    private long currentAddedInTx = -1L;
    private long single;
    private boolean isSingle;

    DefaultNodeCursor(CursorPool<DefaultNodeCursor> pool, StorageNodeCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool);
        this.storeCursor = storeCursor;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    void scan(Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.storeCursor.scan();
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
        this.isSingle = false;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = true;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        if (this.tracer != null) {
            this.tracer.onAllNodesScan();
        }
    }

    boolean scanBatch(Read read, AllNodeScan scan, long sizeHint, LongIterator addedNodes, boolean hasChanges, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
        this.isSingle = false;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = false;
        this.hasChanges = hasChanges;
        this.addedNodes = addedNodes;
        boolean scanBatch = this.storeCursor.scanBatch((Scan)scan, sizeHint);
        return addedNodes.hasNext() || scanBatch;
    }

    void single(long reference, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.storeCursor.single(reference);
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
        this.single = reference;
        this.isSingle = true;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = true;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        this.singleIsAddedInTx = false;
    }

    protected boolean currentNodeIsAddedInTx() {
        return this.currentAddedInTx != -1L;
    }

    public long nodeReference() {
        if (this.currentAddedInTx != -1L) {
            return this.currentAddedInTx;
        }
        return this.storeCursor.entityReference();
    }

    public TokenSet labels() {
        return this.labels(this.storeCursor);
    }

    public TokenSet labelsAndProperties(PropertyCursor propertyCursor, PropertySelection selection) {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.txStateHolder.txState();
            this.properties(propertyCursor, selection);
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            IntHashSet labels = new IntHashSet(this.storeCursor.labels());
            this.properties(propertyCursor, selection);
            return Labels.from((IntSet)txState.augmentLabels((MutableIntSet)labels, txState.getNodeState(this.storeCursor.entityReference())));
        }
        DefaultPropertyCursor defaultPropertyCursor = (DefaultPropertyCursor)propertyCursor;
        int[] labels = this.storeCursor.labelsAndProperties(defaultPropertyCursor.storeCursor, selection);
        defaultPropertyCursor.initNode(this, selection, this.read, false, this.txStateHolder, this.accessModeProvider);
        return Labels.from(labels);
    }

    public TokenSet labelsIgnoringTxStateSetRemove() {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.txStateHolder.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        return Labels.from(this.storeCursor.labels());
    }

    public boolean hasLabel(int label) {
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            LongDiffSets diffSets = txState.nodeStateLabelDiffSets(this.nodeReference());
            if (diffSets.isAdded((long)label)) {
                if (this.tracer != null) {
                    this.tracer.onHasLabel(label);
                }
                return true;
            }
            if (this.currentNodeIsAddedInTx() || diffSets.isRemoved((long)label)) {
                if (this.tracer != null) {
                    this.tracer.onHasLabel(label);
                }
                return false;
            }
        }
        if (this.tracer != null) {
            this.tracer.onHasLabel(label);
        }
        return this.storeCursor.hasLabel(label);
    }

    public boolean hasLabel() {
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            LongDiffSets diffSets = txState.nodeStateLabelDiffSets(this.nodeReference());
            if (diffSets.getAdded().notEmpty()) {
                if (this.tracer != null) {
                    this.tracer.onHasLabel();
                }
                return true;
            }
            if (this.currentNodeIsAddedInTx()) {
                if (this.tracer != null) {
                    this.tracer.onHasLabel();
                }
                return false;
            }
            if (diffSets.getRemoved().notEmpty()) {
                if (this.tracer != null) {
                    this.tracer.onHasLabel();
                }
                return this.labels().numberOfTokens() > 0;
            }
        }
        if (this.tracer != null) {
            this.tracer.onHasLabel();
        }
        return this.storeCursor.hasLabel();
    }

    public void relationships(RelationshipTraversalCursor cursor, RelationshipSelection selection) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this, selection, this.read, this.txStateHolder, this.accessModeProvider);
    }

    public boolean supportsFastRelationshipsTo() {
        return this.currentAddedInTx == -1L && this.storeCursor.supportsFastRelationshipsTo();
    }

    public void relationshipsTo(RelationshipTraversalCursor relationships, RelationshipSelection selection, long neighbourNodeReference) {
        ((DefaultRelationshipTraversalCursor)relationships).init(this, selection, neighbourNodeReference, this.read, this.txStateHolder, this.accessModeProvider);
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        ((DefaultPropertyCursor)cursor).initNode(this, selection, this.read, true, this.txStateHolder, this.accessModeProvider);
    }

    public long relationshipsReference() {
        return this.currentAddedInTx != -1L ? -1L : this.storeCursor.relationshipsReference();
    }

    public Reference propertiesReference() {
        return this.currentAddedInTx != -1L ? LongReference.NULL_REFERENCE : this.storeCursor.propertiesReference();
    }

    public boolean supportsFastDegreeLookup() {
        return (this.currentAddedInTx != -1L || this.storeCursor.supportsFastDegreeLookup()) && this.allowsTraverseAll();
    }

    public int[] relationshipTypes() {
        MutableIntSet types;
        boolean hasChanges = this.hasChanges();
        NodeState nodeTxState = hasChanges ? this.txStateHolder.txState().getNodeState(this.nodeReference()) : null;
        int[] storedTypes = this.currentAddedInTx == -1L ? this.storeCursor.relationshipTypes() : null;
        MutableIntSet mutableIntSet = types = storedTypes != null ? IntSets.mutable.of(storedTypes) : IntSets.mutable.empty();
        if (nodeTxState != null) {
            types.addAll(nodeTxState.getAddedRelationshipTypes());
        }
        return types.toArray();
    }

    public Degrees degrees(RelationshipSelection selection) {
        EagerDegrees degrees = new EagerDegrees();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees;
    }

    public int degree(RelationshipSelection selection) {
        SingleDegree degrees = new SingleDegree();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees.getTotal();
    }

    public int degreeWithMax(int maxDegree, RelationshipSelection selection) {
        SingleDegree degrees = new SingleDegree(maxDegree);
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return Math.min(degrees.getTotal(), maxDegree);
    }

    private void fillDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        NodeState nodeTxState;
        if (this.hasChanges() && (nodeTxState = this.txStateHolder.txState().getNodeState(this.nodeReference())) != null && !nodeTxState.fillDegrees(selection, degrees)) {
            return;
        }
        if (this.currentAddedInTx == -1L) {
            if (this.allowsTraverseAll()) {
                this.storeCursor.degrees(selection, degrees);
            } else {
                this.readRestrictedDegrees(selection, degrees);
            }
        }
    }

    private void readRestrictedDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        if (this.securityStoreRelationshipCursor == null) {
            this.securityStoreRelationshipCursor = this.internalCursors.allocateStorageRelationshipTraversalCursor();
        }
        this.storeCursor.relationships(this.securityStoreRelationshipCursor, selection);
        while (this.securityStoreRelationshipCursor.next()) {
            boolean incoming;
            long target;
            int type = this.securityStoreRelationshipCursor.type();
            if (!this.accessModeProvider.getAccessMode().allowsTraverseRelType(type)) continue;
            long source = this.securityStoreRelationshipCursor.sourceNodeReference();
            boolean loop = source == (target = this.securityStoreRelationshipCursor.targetNodeReference());
            boolean outgoing = !loop && source == this.nodeReference();
            boolean bl = incoming = !loop && !outgoing;
            if (!loop) {
                if (this.securityStoreNodeCursor == null) {
                    this.securityStoreNodeCursor = this.internalCursors.allocateStorageNodeCursor();
                }
                this.securityStoreNodeCursor.single(outgoing ? target : source);
                if (!this.securityStoreNodeCursor.next() || !this.allowsTraverse(this.securityStoreNodeCursor)) continue;
            }
            if (degrees.add(type, outgoing ? 1 : 0, incoming ? 1 : 0, loop ? 1 : 0)) continue;
            return;
        }
    }

    private boolean allowsTraverse(StorageNodeCursor nodeCursor) {
        IntSet securityProperties;
        int[] labels;
        AccessMode accessMode = this.accessModeProvider.getAccessMode();
        if (accessMode.allowsTraverseAllLabels()) {
            return true;
        }
        int[] nArray = labels = this.applyAccessModeToTxState ? this.labels(nodeCursor).all() : nodeCursor.labels();
        if (accessMode.hasTraversePropertyRules() && (securityProperties = accessMode.getTraverseSecurityProperties(labels)).notEmpty()) {
            ReadSecurityPropertyProvider securityPropertyProvider = this.getSecurityPropertyProvider(nodeCursor, securityProperties);
            return accessMode.allowsTraverseNodeWithPropertyRules(securityPropertyProvider, labels);
        }
        return accessMode.allowsTraverseNode(labels);
    }

    private StoragePropertyCursor lazyInitAndGetSecurityPropertyCursor() {
        if (this.securityPropertyCursor == null) {
            this.securityPropertyCursor = this.internalCursors.allocateStoragePropertyCursor();
        }
        return this.securityPropertyCursor;
    }

    private TokenSet labels(StorageNodeCursor nodeCursor) {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.txStateHolder.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            IntHashSet labels = new IntHashSet(nodeCursor.labels());
            return Labels.from((IntSet)txState.augmentLabels((MutableIntSet)labels, txState.getNodeState(nodeCursor.entityReference())));
        }
        return Labels.from(nodeCursor.labels());
    }

    private ReadSecurityPropertyProvider getSecurityPropertyProvider(StorageNodeCursor storageNodeCursor, IntSet securityProperties) {
        storageNodeCursor.properties(this.lazyInitAndGetSecurityPropertyCursor(), PropertySelection.selection((int[])securityProperties.toArray()));
        Iterable txStateChangedProperties = this.applyAccessModeToTxState ? this.txStateHolder.txState().getNodeState(this.nodeReference()).addedAndChangedProperties() : null;
        return new ReadSecurityPropertyProvider.LazyReadSecurityPropertyProvider(this.securityPropertyCursor, txStateChangedProperties, PropertySelection.selection((int[])securityProperties.toArray()));
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            if (this.isSingle && this.singleIsAddedInTx) {
                this.currentAddedInTx = this.single;
                this.singleIsAddedInTx = false;
                if (!this.applyAccessModeToTxState || this.allowsTraverse()) {
                    if (this.tracer != null) {
                        this.tracer.onNode(this.nodeReference());
                    }
                    return true;
                }
            }
            while (this.addedNodes.hasNext()) {
                this.currentAddedInTx = this.addedNodes.next();
                if (this.applyAccessModeToTxState && !this.allowsTraverse()) continue;
                if (this.tracer != null) {
                    this.tracer.onNode(this.nodeReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (this.storeCursor.next()) {
            boolean skip = hasChanges && this.txStateHolder.txState().nodeIsDeletedInThisBatch(this.storeCursor.entityReference());
            if (skip || !this.allowsTraverse()) continue;
            if (this.tracer != null) {
                this.tracer.onNode(this.nodeReference());
            }
            return true;
        }
        return false;
    }

    protected boolean allowsTraverse() {
        return this.allowsTraverse(this.storeCursor);
    }

    protected boolean allowsTraverseAll() {
        AccessMode accessMode = this.accessModeProvider.getAccessMode();
        return accessMode.allowsTraverseAllRelTypes() && accessMode.allowsTraverseAllLabels();
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.txStateHolder = null;
            this.accessModeProvider = null;
            this.checkHasChanges = true;
            this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
            this.storeCursor.close();
            this.storeCursor.reset();
            if (this.securityStoreNodeCursor != null) {
                this.securityStoreNodeCursor.reset();
            }
            if (this.securityStoreRelationshipCursor != null) {
                this.securityStoreRelationshipCursor.reset();
            }
            if (this.securityPropertyCursor != null) {
                this.securityPropertyCursor.reset();
            }
        }
        super.closeInternal();
    }

    public boolean isClosed() {
        return this.read == null;
    }

    boolean hasChanges() {
        if (this.checkHasChanges) {
            this.computeHasChanges();
        }
        return this.hasChanges;
    }

    private void computeHasChanges() {
        this.checkHasChanges = false;
        this.hasChanges = this.txStateHolder.hasTxStateWithChanges();
        if (this.hasChanges) {
            if (this.isSingle) {
                this.singleIsAddedInTx = this.txStateHolder.txState().nodeIsAddedInThisBatch(this.single);
            } else {
                this.addedNodes = this.txStateHolder.txState().addedAndRemovedNodes().getAdded().freeze().longIterator();
            }
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeCursor[closed state]";
        }
        return "NodeCursor[id=" + this.nodeReference() + ", " + this.storeCursor + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        StoragePropertyCursor localSecurityPropertyCursor = this.securityPropertyCursor;
        StorageRelationshipTraversalCursor localSecurityRelationshipCursor = this.securityStoreRelationshipCursor;
        StorageNodeCursor localSecurityNodeCursor = this.securityStoreNodeCursor;
        try (StoragePropertyCursor storagePropertyCursor = localSecurityPropertyCursor;
             StorageRelationshipTraversalCursor storageRelationshipTraversalCursor = localSecurityRelationshipCursor;
             StorageNodeCursor storageNodeCursor = localSecurityNodeCursor;){
            StorageNodeCursor storageNodeCursor2 = this.storeCursor;
            if (storageNodeCursor2 != null) {
                storageNodeCursor2.close();
            }
        }
        finally {
            this.securityPropertyCursor = null;
            this.securityStoreRelationshipCursor = null;
            this.securityStoreNodeCursor = null;
        }
    }
}

