/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security.exception;

import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class InvalidAuthTokenException
extends GqlException
implements Status.HasStatus {
    private final Status status = Status.Security.Unauthorized;
    private static final String THE_VALUE_ASSOCIATED_WITH_THE_PARAMETER_TEMPLATE = "The value associated with the parameter %s must be a %s but was: %s";
    private static final String PARAMETER_NOT_PROVIDED_TEMPLATE = "'%s' parameter not provided";
    private static final String WRONG_TYPE_TEMPLATE = "%s must be a %s but was: %s";

    private InvalidAuthTokenException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InvalidAuthTokenException unsupportedAuthenticationToken(String explanation) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new InvalidAuthTokenException(gql, String.format("Unsupported authentication token%s", explanation));
    }

    public static InvalidAuthTokenException parameterNotProvided(String parameter) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new InvalidAuthTokenException(gql, String.format(PARAMETER_NOT_PROVIDED_TEMPLATE, parameter));
    }

    public static InvalidAuthTokenException wrongTypeForParameter(String parameter, String expectedType, String actualType) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new InvalidAuthTokenException(gql, String.format(THE_VALUE_ASSOCIATED_WITH_THE_PARAMETER_TEMPLATE, parameter, expectedType, actualType));
    }

    public static InvalidAuthTokenException wrongType(String parameter, String expectedType, String actualType) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new InvalidAuthTokenException(gql, String.format(WRONG_TYPE_TEMPLATE, parameter, expectedType, actualType));
    }

    public static InvalidAuthTokenException valueMustBeMap(String key, String valueType) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new InvalidAuthTokenException(gql, "The value associated with the key `" + key + "` must be a Map but was: " + valueType);
    }

    public static InvalidAuthTokenException tokenError(String token, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new InvalidAuthTokenException(gql, cause.getMessage() + ": " + token);
    }

    public Status status() {
        return this.status;
    }
}

