/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionLogQueue;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.StorageEngineTransaction;

class QueueTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final TransactionLogQueue transactionLogQueue;

    QueueTransactionAppender(TransactionLogQueue transactionLogQueue) {
        this.transactionLogQueue = transactionLogQueue;
    }

    public void start() throws Exception {
        this.transactionLogQueue.start();
    }

    public void shutdown() throws Exception {
        this.transactionLogQueue.shutdown();
    }

    @Override
    public long append(StorageEngineTransaction batch, LogAppendEvent logAppendEvent) throws IOException, ExecutionException, InterruptedException {
        long committedAppendIndex = this.transactionLogQueue.submit(batch, logAppendEvent).getCommittedAppendIndex();
        QueueTransactionAppender.publishAsCommitted(batch);
        return committedAppendIndex;
    }

    private static void publishAsCommitted(StorageEngineTransaction batch) {
        while (batch != null) {
            batch.commit();
            batch = batch.next();
        }
    }
}

