/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.impl.util.WrappingEntity;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class RelationshipEntityWrappingValue
extends RelationshipValue
implements WrappingEntity<Relationship> {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipEntityWrappingValue.class) + RelationshipEntity.SHALLOW_SIZE;
    private final Relationship relationship;
    private volatile TextValue type;
    private volatile MapValue properties;
    private volatile VirtualNodeReference startNode;
    private volatile VirtualNodeReference endNode;

    static RelationshipEntityWrappingValue wrapLazy(Relationship relationship) {
        return new RelationshipEntityWrappingValue(relationship);
    }

    private RelationshipEntityWrappingValue(Relationship relationship) {
        super(relationship.getId(), -1L, -1L);
        this.relationship = relationship;
    }

    public Relationship relationshipEntity() {
        return this.relationship;
    }

    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeRelationshipReference(this.id());
        } else {
            MapValue p;
            RelationshipEntity proxy;
            boolean isDeleted = false;
            Relationship relationship = this.relationship;
            if (relationship instanceof RelationshipEntity && !(proxy = (RelationshipEntity)relationship).initializeData()) {
                throw new ReadAndDeleteTransactionConflictException(RelationshipEntity.isDeletedInCurrentTransaction(this.relationship));
            }
            try {
                p = this.properties();
            }
            catch (ReadAndDeleteTransactionConflictException e) {
                if (!e.wasDeletedInThisTransaction()) {
                    throw e;
                }
                p = VirtualValues.EMPTY_MAP;
                isDeleted = true;
            }
            if (this.id() < 0L) {
                writer.writeVirtualRelationshipHack((Object)this.relationship);
            }
            writer.writeRelationship(this.elementId(), this.id(), this.startNode().elementId(), this.startNode().id(), this.endNode().elementId(), this.endNode().id(), this.type(), p, isDeleted);
        }
    }

    public long estimatedHeapUsage() {
        long size = SHALLOW_SIZE;
        if (this.type != null) {
            size += this.type.estimatedHeapUsage();
        }
        if (this.properties != null) {
            size += this.properties.estimatedHeapUsage();
        }
        if (this.startNode != null) {
            size += this.startNode.estimatedHeapUsage();
        }
        if (this.endNode != null) {
            size += this.endNode.estimatedHeapUsage();
        }
        return size;
    }

    public void populate(RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        try {
            RelationshipEntity proxy;
            Relationship relationship = this.relationship;
            if (relationship instanceof RelationshipEntity && !(proxy = (RelationshipEntity)relationship).initializeData(relCursor)) {
                return;
            }
            this.type();
            this.properties(propertyCursor);
            this.startNode();
            this.endNode();
        }
        catch (NotFoundException | ReadAndDeleteTransactionConflictException throwable) {
            // empty catch block
        }
    }

    public void populate() {
        block5: {
            try {
                RelationshipEntity proxy;
                Relationship relationship = this.relationship;
                if (relationship instanceof RelationshipEntity && !(proxy = (RelationshipEntity)relationship).initializeData()) {
                    return;
                }
                this.type();
                this.properties();
                this.startNode();
                this.endNode();
            }
            catch (NotFoundException e) {
                if (!RelationshipEntity.isDeletedInCurrentTransaction(this.relationship)) {
                    throw e;
                }
            }
            catch (ReadAndDeleteTransactionConflictException e) {
                if (e.wasDeletedInThisTransaction()) break block5;
                throw e;
            }
        }
    }

    public boolean isPopulated() {
        return this.type != null && this.properties != null && this.startNode != null && this.endNode != null;
    }

    public boolean canPopulate() {
        Relationship relationship = this.relationship;
        if (relationship instanceof RelationshipEntity) {
            RelationshipEntity entity = (RelationshipEntity)relationship;
            return entity.getTransaction().isOpen();
        }
        return true;
    }

    public long startNodeId(Consumer<RelationshipVisitor> consumer) {
        long startNodeId = super.startNodeId(consumer);
        return startNodeId != -1L ? startNodeId : this.startNode().id();
    }

    public long endNodeId(Consumer<RelationshipVisitor> consumer) {
        long endNodeId = super.endNodeId(consumer);
        return endNodeId != -1L ? endNodeId : this.endNode().id();
    }

    public long startNodeId() {
        long startNodeId = super.startNodeId();
        return startNodeId != -1L ? startNodeId : this.startNode().id();
    }

    public long endNodeId() {
        long endNodeId = super.endNodeId();
        return endNodeId != -1L ? endNodeId : this.endNode().id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualNodeReference startNode() {
        VirtualNodeReference start = this.startNode;
        if (start == null) {
            RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
            synchronized (relationshipEntityWrappingValue) {
                start = this.startNode;
                if (start == null) {
                    start = this.startNode = ValueUtils.asNodeReference(this.relationship.getStartNode());
                }
            }
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualNodeReference endNode() {
        VirtualNodeReference end = this.endNode;
        if (end == null) {
            RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
            synchronized (relationshipEntityWrappingValue) {
                end = this.endNode;
                if (end == null) {
                    end = this.endNode = ValueUtils.asNodeReference(this.relationship.getEndNode());
                }
            }
        }
        return end;
    }

    public VirtualNodeValue otherNode(VirtualNodeValue node) {
        if (node instanceof NodeEntityWrappingNodeValue) {
            Node proxy = ((NodeEntityWrappingNodeValue)node).getEntity();
            return ValueUtils.fromNodeEntity(this.relationship.getOtherNode(proxy));
        }
        return super.otherNode(node);
    }

    public long otherNodeId(long node) {
        return this.relationship.getOtherNodeId(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextValue type() {
        TextValue t = this.type;
        if (t == null) {
            try {
                RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
                synchronized (relationshipEntityWrappingValue) {
                    t = this.type;
                    if (t == null) {
                        t = this.type = Values.utf8Value((String)this.relationship.getType().name());
                    }
                }
            }
            catch (IllegalStateException e) {
                throw new ReadAndDeleteTransactionConflictException(RelationshipEntity.isDeletedInCurrentTransaction(this.relationship), (Throwable)e);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties() {
        MapValue m = this.properties;
        if (m == null) {
            try {
                RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
                synchronized (relationshipEntityWrappingValue) {
                    m = this.properties;
                    if (m == null) {
                        m = this.properties = ValueUtils.asMapValue(this.relationship.getAllProperties());
                    }
                }
            }
            catch (IllegalStateException | NotFoundException e) {
                throw new ReadAndDeleteTransactionConflictException(RelationshipEntity.isDeletedInCurrentTransaction(this.relationship), e);
            }
        }
        return m;
    }

    public String elementId() {
        return this.relationship.getElementId();
    }

    @Override
    public Relationship getEntity() {
        return this.relationship;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties(PropertyCursor propertyCursor) {
        MapValue m = this.properties;
        if (m == null) {
            try {
                RelationshipEntityWrappingValue relationshipEntityWrappingValue = this;
                synchronized (relationshipEntityWrappingValue) {
                    m = this.properties;
                    if (m == null) {
                        Map<String, Object> relProperties = this.relationship instanceof RelationshipEntity ? ((RelationshipEntity)this.relationship).getAllProperties(propertyCursor) : this.relationship.getAllProperties();
                        m = this.properties = ValueUtils.asMapValue(relProperties);
                    }
                }
            }
            catch (IllegalStateException | NotFoundException e) {
                throw new ReadAndDeleteTransactionConflictException(RelationshipEntity.isDeletedInCurrentTransaction(this.relationship), e);
            }
        }
        return m;
    }
}

