/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.HashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityScanCursorBehaviour;
import org.neo4j.lock.Lock;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;

public class GenerateIndexUpdatesStep<CURSOR extends StorageEntityScanCursor<?>>
extends ProcessorStep<long[]> {
    private static final String TRACER_TAG_PREFIX = "indexPopulationStep:";
    private final StorageReader reader;
    private final Function<CursorContext, StoreCursors> storeCursorsFactory;
    private final PropertySelection propertySelection;
    private final EntityScanCursorBehaviour<CURSOR> entityCursorBehaviour;
    private final int[] relevantTokenIds;
    private final PropertyScanConsumer propertyScanConsumer;
    private final TokenScanConsumer tokenScanConsumer;
    private final boolean gatherTokenUpdates;
    private final boolean gatherPropertyUpdates;
    private final LongFunction<Lock> lockFunction;
    private final boolean alsoWrite;
    private final LongAdder completedEntities = new LongAdder();
    private final MemoryTracker memoryTracker;
    private final long maxBatchSizeBytes;

    public GenerateIndexUpdatesStep(StageControl control, Configuration config, StorageReader reader, Function<CursorContext, StoreCursors> storeCursorsFactory, PropertySelection propertySelection, EntityScanCursorBehaviour<CURSOR> entityCursorBehaviour, int[] entityTokenIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer tokenScanConsumer, LongFunction<Lock> lockFunction, int parallelism, long maxBatchSizeBytes, boolean alsoWrite, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        super(control, "generate updates", config, parallelism, contextFactory, new StatsProvider[0]);
        this.reader = reader;
        this.storeCursorsFactory = storeCursorsFactory;
        this.propertySelection = propertySelection;
        this.entityCursorBehaviour = entityCursorBehaviour;
        this.relevantTokenIds = entityTokenIdFilter;
        this.propertyScanConsumer = propertyScanConsumer;
        this.tokenScanConsumer = tokenScanConsumer;
        this.gatherPropertyUpdates = propertyScanConsumer != null;
        this.gatherTokenUpdates = tokenScanConsumer != null;
        this.lockFunction = lockFunction;
        this.alsoWrite = alsoWrite;
        this.memoryTracker = memoryTracker;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
    }

    protected void process(long[] entityIds, BatchSender sender, CursorContext cursorContext) throws Exception {
        GeneratedIndexUpdates updates = new GeneratedIndexUpdates(this.gatherPropertyUpdates, this.gatherTokenUpdates);
        int numEntities = 0;
        try (StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
             CURSOR entityCursor = this.entityCursorBehaviour.allocateEntityScanCursor(cursorContext, storeCursors);
             StoragePropertyCursor propertyCursor = this.reader.allocatePropertyCursor(cursorContext, storeCursors, this.memoryTracker);){
            for (long entityId : entityIds) {
                ++numEntities;
                try (Lock ignored = this.lockFunction.apply(entityId);){
                    entityCursor.single(entityId);
                    while (entityCursor.next()) {
                        this.generateUpdates(updates, entityCursor, propertyCursor);
                        if (updates.propertiesByteSize <= this.maxBatchSizeBytes) continue;
                        this.batchDone(updates, sender, numEntities);
                        numEntities = 0;
                        updates = new GeneratedIndexUpdates(this.gatherPropertyUpdates, this.gatherTokenUpdates);
                    }
                }
            }
        }
        this.batchDone(updates, sender, numEntities);
    }

    private void batchDone(GeneratedIndexUpdates updates, BatchSender sender, int numEntities) {
        updates.setNumberOfEntities(numEntities);
        if (this.alsoWrite) {
            updates.completeBatch();
        } else {
            sender.send((Object)updates);
        }
    }

    private void generateUpdates(GeneratedIndexUpdates updates, CURSOR entityCursor, StoragePropertyCursor propertyCursor) {
        int[] tokens = this.gatherPropertyUpdates ? this.entityCursorBehaviour.readTokensAndProperties(entityCursor, propertyCursor, this.propertySelection) : this.entityCursorBehaviour.readTokens(entityCursor);
        if (tokens.length == 0) {
            return;
        }
        if (this.gatherTokenUpdates) {
            updates.tokenUpdates.addRecord(entityCursor.entityReference(), tokens);
        }
        if (this.gatherPropertyUpdates && GenerateIndexUpdatesStep.containsAnyEntityToken(this.relevantTokenIds, tokens)) {
            this.readRelevantProperties(entityCursor, propertyCursor, tokens, updates);
        }
    }

    void readRelevantProperties(CURSOR cursor, StoragePropertyCursor propertyCursor, int[] tokens, GeneratedIndexUpdates indexUpdates) {
        HashMap<Integer, Value> relevantProperties = new HashMap<Integer, Value>();
        while (propertyCursor.next()) {
            int propertyKeyId = propertyCursor.propertyKey();
            Value value = propertyCursor.propertyValue();
            relevantProperties.put(propertyKeyId, value);
            indexUpdates.propertiesByteSize += value.estimatedHeapUsage();
        }
        if (!relevantProperties.isEmpty()) {
            indexUpdates.propertyUpdates.addRecord(cursor.entityReference(), tokens, relevantProperties);
        }
    }

    protected String buildCursorTracerName() {
        return TRACER_TAG_PREFIX + this.name();
    }

    long numberOfCompletedEntities() {
        return this.completedEntities.sum();
    }

    static boolean containsAnyEntityToken(int[] entityTokenFilter, int ... entityTokens) {
        for (int candidate : entityTokens) {
            if (!ArrayUtils.contains((int[])entityTokenFilter, (int)candidate)) continue;
            return true;
        }
        return false;
    }

    class GeneratedIndexUpdates {
        private final PropertyScanConsumer.Batch propertyUpdates;
        private final TokenScanConsumer.Batch tokenUpdates;
        private long propertiesByteSize;
        private volatile int numberOfEntities;

        GeneratedIndexUpdates(boolean gatherPropertyUpdates, boolean gatherTokenUpdates) {
            this.propertyUpdates = gatherPropertyUpdates ? GenerateIndexUpdatesStep.this.propertyScanConsumer.newBatch() : null;
            this.tokenUpdates = gatherTokenUpdates ? GenerateIndexUpdatesStep.this.tokenScanConsumer.newBatch() : null;
        }

        void completeBatch() {
            if (GenerateIndexUpdatesStep.this.gatherPropertyUpdates) {
                this.propertyUpdates.process();
            }
            if (GenerateIndexUpdatesStep.this.gatherTokenUpdates) {
                this.tokenUpdates.process();
            }
            GenerateIndexUpdatesStep.this.completedEntities.add(this.numberOfEntities);
        }

        void setNumberOfEntities(int numEntities) {
            this.numberOfEntities = numEntities;
        }
    }
}

