/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.List;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.RelationshipEndpointSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;

public class RestrictedSchemaWrite
implements SchemaWrite {
    private final SchemaWrite inner;
    private final SecurityContext securityContext;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;

    RestrictedSchemaWrite(SchemaWrite inner, SecurityContext securityContext, SecurityAuthorizationHandler securityAuthorizationHandler) {
        this.inner = inner;
        this.securityContext = securityContext;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
    }

    public IndexProviderDescriptor indexProviderByName(String providerName) {
        return this.inner.indexProviderByName(providerName);
    }

    public IndexType indexTypeByProviderName(String providerName) {
        return this.inner.indexTypeByProviderName(providerName);
    }

    public List<IndexProviderDescriptor> indexProvidersByType(IndexType indexType) {
        return this.inner.indexProvidersByType(indexType);
    }

    public IndexDescriptor indexCreate(IndexPrototype prototype) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_INDEX);
        return this.inner.indexCreate(prototype);
    }

    public void indexDrop(IndexDescriptor index) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_INDEX);
        this.inner.indexDrop(index);
    }

    public void indexDrop(String indexName) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_INDEX);
        this.inner.indexDrop(indexName);
    }

    public ConstraintDescriptor uniquePropertyConstraintCreate(IndexPrototype prototype) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.uniquePropertyConstraintCreate(prototype);
    }

    public ConstraintDescriptor keyConstraintCreate(IndexPrototype prototype) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.keyConstraintCreate(prototype);
    }

    public ConstraintDescriptor nodePropertyExistenceConstraintCreate(LabelSchemaDescriptor schema, String name, boolean isDependent) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.nodePropertyExistenceConstraintCreate(schema, name, isDependent);
    }

    public ConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor schema, String name, boolean isDependent) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.relationshipPropertyExistenceConstraintCreate(schema, name, isDependent);
    }

    public ConstraintDescriptor propertyTypeConstraintCreate(SchemaDescriptor schema, String name, PropertyTypeSet propertyType, boolean isDependent) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.propertyTypeConstraintCreate(schema, name, propertyType, isDependent);
    }

    public ConstraintDescriptor relationshipEndpointConstraintCreate(RelationshipEndpointSchemaDescriptor schema, String name, int endpointLabelId, EndpointType endpointType) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.relationshipEndpointConstraintCreate(schema, name, endpointLabelId, endpointType);
    }

    public void constraintDrop(String name, boolean canDropDependent) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_CONSTRAINT);
        this.inner.constraintDrop(name, canDropDependent);
    }

    public void constraintDrop(ConstraintDescriptor constraint, boolean canDropDependent) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_CONSTRAINT);
        this.inner.constraintDrop(constraint, canDropDependent);
    }
}

