/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.reverse.ReservedBatch;

public class EagerlyReversedCommandBatchCursor
implements CommandBatchCursor {
    private final List<ReservedBatch> batches = new ArrayList<ReservedBatch>();
    private final CommandBatchCursor cursor;
    private int indexToReturn;

    private EagerlyReversedCommandBatchCursor(CommandBatchCursor cursor) throws IOException {
        this.cursor = cursor;
        LogPosition batchPosition = cursor.position();
        while (cursor.next()) {
            this.batches.add(new ReservedBatch((CommittedCommandBatch)cursor.get(), batchPosition));
            batchPosition = cursor.position();
        }
        this.indexToReturn = this.batches.size();
    }

    public boolean next() {
        if (this.indexToReturn > 0) {
            --this.indexToReturn;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.cursor.close();
    }

    public CommittedCommandBatch get() {
        return this.batches.get(this.indexToReturn).commitedBatch();
    }

    @Override
    public LogPosition position() {
        return this.batches.get(this.indexToReturn).batchStartPosition();
    }

    public static CommandBatchCursor eagerlyReverse(CommandBatchCursor cursor) throws IOException {
        return new EagerlyReversedCommandBatchCursor(cursor);
    }
}

