/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.InternalKernelRuntimeException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexPopulationJobController;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.drop.DefaultIndexDropController;
import org.neo4j.kernel.impl.api.index.drop.IndexDropController;
import org.neo4j.kernel.impl.api.index.drop.MultiVersionIndexDropController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.index.stats.IndexUsageStatsConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.time.Stopwatch;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class IndexingService
extends LifecycleAdapter
implements IndexUpdateListener,
IndexingProvidersService {
    private static final String INDEX_SERVICE_INDEX_CLOSING_TAG = "indexServiceIndexClosing";
    private static final String INIT_TAG = "Initialize IndexingService";
    private static final String START_TAG = "Start index population";
    public static final int USAGE_REPORT_FREQUENCY_SECONDS = 10;
    private final IndexSamplingController samplingController;
    private final IndexProxyCreator indexProxyCreator;
    private final IndexProviderMap providerMap;
    private final IndexMapReference indexMapRef;
    private final Iterable<IndexDescriptor> indexDescriptors;
    private final InternalLog internalLog;
    private final IndexStatisticsStore indexStatisticsStore;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final String databaseName;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final Config config;
    private final ImmutableSet<OpenOption> openOptions;
    private final TokenNameLookup tokenNameLookup;
    private final JobScheduler jobScheduler;
    private final InternalLogProvider internalLogProvider;
    private final IndexMonitor monitor;
    private final SchemaState schemaState;
    private final IndexPopulationJobController populationJobController;
    private final IndexStoreView storeView;
    private final StorageEngineIndexingBehaviour storageEngineIndexingBehaviour;
    private final KernelVersionProvider kernelVersionProvider;
    private final IndexDropController indexDropController;
    private JobHandle<?> eventuallyConsistentFulltextIndexRefreshJob;
    private volatile JobHandle<?> usageReportJob;
    private volatile State state = State.NOT_STARTED;

    IndexingService(ReadableStorageEngine storageEngine, IndexProxyCreator indexProxyCreator, IndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreViewFactory indexStoreViewFactory, Iterable<IndexDescriptor> indexDescriptors, IndexSamplingController samplingController, TokenNameLookup tokenNameLookup, JobScheduler scheduler, SchemaState schemaState, InternalLogProvider internalLogProvider, IndexMonitor monitor, IndexStatisticsStore indexStatisticsStore, CursorContextFactory contextFactory, MemoryTracker memoryTracker, String databaseName, DatabaseReadOnlyChecker readOnlyChecker, Config config, KernelVersionProvider kernelVersionProvider, FileSystemAbstraction fs, TransactionVisibilityProvider transactionVisibilityProvider) {
        this.storageEngineIndexingBehaviour = storageEngine.indexingBehaviour();
        this.indexProxyCreator = indexProxyCreator;
        this.providerMap = providerMap;
        this.indexMapRef = indexMapRef;
        this.indexDescriptors = indexDescriptors;
        this.samplingController = samplingController;
        this.tokenNameLookup = tokenNameLookup;
        this.jobScheduler = scheduler;
        this.schemaState = schemaState;
        this.internalLogProvider = internalLogProvider;
        this.monitor = monitor;
        this.populationJobController = new IndexPopulationJobController(scheduler);
        this.internalLog = internalLogProvider.getLog(this.getClass());
        this.indexStatisticsStore = indexStatisticsStore;
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
        this.databaseName = databaseName;
        this.readOnlyChecker = readOnlyChecker;
        this.config = config;
        this.openOptions = storageEngine.getOpenOptions();
        this.storeView = indexStoreViewFactory.createTokenIndexStoreView(indexMapRef::getIndexProxy);
        this.kernelVersionProvider = kernelVersionProvider;
        this.indexDropController = this.createIndexDropController(internalLogProvider, transactionVisibilityProvider, fs);
    }

    private IndexDropController createIndexDropController(InternalLogProvider internalLogProvider, TransactionVisibilityProvider transactionVisibilityProvider, FileSystemAbstraction fs) {
        return this.openOptions.contains((Object)PageCacheOpenOptions.MULTI_VERSIONED) && !TransactionVisibilityProvider.EMPTY_VISIBILITY_PROVIDER.equals(transactionVisibilityProvider) ? new MultiVersionIndexDropController(this.jobScheduler, transactionVisibilityProvider, this, fs, (LogProvider)internalLogProvider) : new DefaultIndexDropController(this);
    }

    public void init() throws IOException {
        this.validateDefaultProviderExisting();
        try (CursorContext cursorContext = this.contextFactory.create(INIT_TAG);){
            this.indexMapRef.modify(indexMap -> {
                Stopwatch stopwatch = Stopwatch.start();
                EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
                for (IndexDescriptor descriptor : this.indexDescriptors) {
                    IndexProviderDescriptor providerDescriptor = descriptor.getIndexProvider();
                    IndexProvider provider = this.providerMap.lookup(providerDescriptor);
                    InternalIndexState initialState = provider.getInitialState(descriptor, cursorContext, this.openOptions);
                    indexStates.computeIfAbsent(initialState, internalIndexState -> new ArrayList()).add(new IndexLogRecord(descriptor));
                    this.internalLog.debug(this.indexStateInfo("init", initialState, descriptor));
                    IndexProxy indexProxy = switch (initialState) {
                        default -> throw new IncompatibleClassChangeError();
                        case InternalIndexState.ONLINE -> {
                            this.monitor.initialState(this.databaseName, descriptor, InternalIndexState.ONLINE);
                            yield this.indexProxyCreator.createOnlineIndexProxy(descriptor);
                        }
                        case InternalIndexState.POPULATING -> {
                            this.monitor.initialState(this.databaseName, descriptor, InternalIndexState.POPULATING);
                            yield this.indexProxyCreator.createRecoveringIndexProxy(descriptor);
                        }
                        case InternalIndexState.FAILED -> {
                            this.monitor.initialState(this.databaseName, descriptor, InternalIndexState.FAILED);
                            IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(descriptor, cursorContext, this.openOptions));
                            yield this.indexProxyCreator.createFailedIndexProxy(descriptor, failure);
                        }
                    };
                    indexMap.putIndexProxy(indexProxy);
                }
                this.logIndexStateSummary("init", indexStates, indexMap.size(), stopwatch.elapsed());
                return indexMap;
            });
        }
    }

    private void validateDefaultProviderExisting() {
        if (this.providerMap == null || this.providerMap.getDefaultProvider() == null) {
            throw new IllegalStateException("You cannot run the database without an index provider, please make sure that a valid provider (subclass of " + IndexProvider.class.getName() + ") is on your classpath.");
        }
    }

    public void start() throws Exception {
        this.state = State.STARTING;
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("refresh", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)IndexProxy::refresh)));
        LongObjectHashMap rebuildingDescriptors = new LongObjectHashMap();
        this.indexMapRef.modify(arg_0 -> this.lambda$start$3((MutableLongObjectMap)rebuildingDescriptors, arg_0));
        this.samplingController.recoverIndexSamples();
        this.samplingController.start();
        this.indexDropController.start();
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, index) -> {
            IndexProxy proxy;
            if (!index.isUnique()) {
                return;
            }
            try {
                proxy = this.getIndexProxy((IndexDescriptor)index);
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException("What? This index was seen during recovery just now, why isn't it available now?", e);
            }
            if (proxy.getDescriptor().getOwningConstraintId().isEmpty()) {
                return;
            }
            this.monitor.awaitingPopulationOfRecoveredIndex(index);
            this.awaitOnlineAfterRecovery(proxy);
        });
        this.usageReportJob = this.jobScheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, this::reportUsageStatistics, 10L, 10L, TimeUnit.SECONDS);
        this.state = State.RUNNING;
        this.startEventuallyConsistentFulltextIndexRefreshThread();
    }

    public void awaitFulltextIndexRefresh() {
        Duration interval = (Duration)this.config.get(FulltextSettings.eventually_consistent_refresh_interval);
        if (!interval.isZero()) {
            for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
                try {
                    if (!indexProxy.getDescriptor().schema().isSchemaDescriptorType(FulltextSchemaDescriptor.class)) continue;
                    indexProxy.refresh();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private void startEventuallyConsistentFulltextIndexRefreshThread() {
        Duration interval = (Duration)this.config.get(FulltextSettings.eventually_consistent_refresh_interval);
        if (!interval.isZero()) {
            this.eventuallyConsistentFulltextIndexRefreshJob = this.jobScheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, this::checkAndScheduleEventuallyConsistentFulltextIndexRefresh, interval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void checkAndScheduleEventuallyConsistentFulltextIndexRefresh() {
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            indexProxy.maintenance();
        }
    }

    private void dontRebuildIndexesInReadOnlyMode(MutableLongObjectMap<IndexDescriptor> rebuildingDescriptors) {
        if (this.readOnlyChecker.isReadOnly() && rebuildingDescriptors.notEmpty()) {
            String indexString = rebuildingDescriptors.values().stream().map(String::valueOf).collect(Collectors.joining(", ", "{", "}"));
            throw new IllegalStateException("Some indexes need to be rebuilt. This is not allowed in read only mode. Please start db in writable mode to rebuild indexes. Indexes needing rebuild: " + indexString);
        }
    }

    private void populateIndexesOfAllTypes(MutableLongObjectMap<IndexDescriptor> rebuildingDescriptors, IndexMap indexMap) {
        HashMap<IndexPopulationCategory, MutableLongObjectMap> rebuildingDescriptorsByType = new HashMap<IndexPopulationCategory, MutableLongObjectMap>();
        for (IndexDescriptor descriptor : rebuildingDescriptors) {
            IndexPopulationCategory category = new IndexPopulationCategory(descriptor, this.storageEngineIndexingBehaviour);
            rebuildingDescriptorsByType.computeIfAbsent(category, type -> new LongObjectHashMap()).put(descriptor.getId(), (Object)descriptor);
        }
        for (Map.Entry descriptorToPopulate : rebuildingDescriptorsByType.entrySet()) {
            IndexPopulationJob populationJob = this.newIndexPopulationJob(((IndexPopulationCategory)descriptorToPopulate.getKey()).entityType(), Subject.SYSTEM);
            this.populate((MutableLongObjectMap<IndexDescriptor>)((MutableLongObjectMap)descriptorToPopulate.getValue()), indexMap, populationJob);
        }
    }

    private void populate(MutableLongObjectMap<IndexDescriptor> rebuildingDescriptors, IndexMap indexMap, IndexPopulationJob populationJob) {
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, descriptor) -> {
            IndexProxy proxy = this.indexProxyCreator.createPopulatingIndexProxy((IndexDescriptor)descriptor, this.monitor, populationJob);
            proxy.start();
            indexMap.putIndexProxy(proxy);
        });
        try (CursorContext cursorContext = this.contextFactory.create(START_TAG);){
            this.startIndexPopulation(populationJob, cursorContext);
        }
    }

    private void awaitOnlineAfterRecovery(IndexProxy proxy) {
        block7: while (true) {
            switch (1.$SwitchMap$org$neo4j$internal$kernel$api$InternalIndexState[proxy.getState().ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    String message = String.format("Index %s entered %s state while recovery waited for it to be fully populated.", proxy.getDescriptor(), InternalIndexState.FAILED);
                    IndexPopulationFailure populationFailure = proxy.getPopulationFailure();
                    String causeOfFailure = populationFailure.asString();
                    this.internalLog.info(IndexPopulationFailure.appendCauseOfFailure(message, causeOfFailure));
                    return;
                }
                case 3: {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Waiting for index to become ONLINE was interrupted", e);
                    }
                }
                continue block7;
            }
            break;
        }
        throw new IllegalStateException(proxy.getState().name());
    }

    public void stop() throws Exception {
        if (this.eventuallyConsistentFulltextIndexRefreshJob != null) {
            this.eventuallyConsistentFulltextIndexRefreshJob.cancel();
        }
        this.usageReportJob.cancel();
        this.indexDropController.stop();
        this.samplingController.stop();
        this.populationJobController.stop();
    }

    public void shutdown() throws IOException {
        this.state = State.STOPPED;
        this.closeAllIndexes();
    }

    @Override
    public void validateBeforeCommit(IndexDescriptor index, Value[] tuple, long entityId) {
        this.indexMapRef.validateBeforeCommit(index, tuple, entityId);
    }

    @Override
    public void validateIndexPrototype(IndexPrototype prototype) {
        IndexProvider provider = this.providerMap.lookup(prototype.getIndexProvider());
        provider.validatePrototype(prototype);
    }

    @Override
    public IndexProviderDescriptor getDefaultProvider() {
        return this.providerMap.getDefaultProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getFulltextProvider() {
        return this.providerMap.getFulltextProvider().getProviderDescriptor();
    }

    @Override
    public Collection<IndexProvider> getIndexProviders() {
        ArrayList<IndexProvider> indexProviders = new ArrayList<IndexProvider>();
        this.providerMap.accept(indexProviders::add);
        return indexProviders;
    }

    @Override
    public IndexProviderDescriptor getTokenIndexProvider() {
        return this.providerMap.getTokenIndexProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getTextIndexProvider() {
        return this.providerMap.getTextIndexProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getPointIndexProvider() {
        return this.providerMap.getPointIndexProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getVectorIndexProvider() {
        return this.providerMap.getVectorIndexProvider().getProviderDescriptor();
    }

    @Override
    public IndexProvider getIndexProvider(IndexProviderDescriptor descriptor) {
        return this.providerMap.lookup(descriptor);
    }

    @Override
    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return this.providerMap.completeConfiguration(index, this.storageEngineIndexingBehaviour);
    }

    @Override
    public IndexProviderDescriptor indexProviderByName(String providerName) {
        return this.providerMap.lookup(providerName).getProviderDescriptor();
    }

    @Override
    public IndexType indexTypeByProviderName(String providerName) {
        return this.providerMap.lookup(providerName).getIndexType();
    }

    @Override
    public List<IndexProviderDescriptor> indexProvidersByType(IndexType indexType) {
        return this.providerMap.lookup(indexType).stream().map(IndexProvider::getProviderDescriptor).toList();
    }

    public void applyUpdates(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, CursorContext cursorContext, boolean parallel) throws KernelException {
        if (this.state == State.NOT_STARTED) {
            this.apply(updates, IndexUpdateMode.RECOVERY, cursorContext, parallel);
        } else if (this.state == State.RUNNING || this.state == State.STARTING) {
            this.apply(updates, IndexUpdateMode.ONLINE, cursorContext, parallel);
        } else {
            throw new IllegalStateException("Can't apply index updates " + Iterables.asList(updates) + " while indexing service is " + this.state);
        }
    }

    private void apply(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, IndexUpdateMode updateMode, CursorContext cursorContext, boolean parallel) throws KernelException {
        try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(updateMode, parallel);){
            for (IndexEntryUpdate<IndexDescriptor> indexUpdate : updates) {
                IndexingService.processUpdate(updaterMap, indexUpdate, cursorContext);
            }
        }
    }

    public void createIndexes(Subject subject, IndexDescriptor ... rules) {
        IndexPopulationStarter populationStarter = new IndexPopulationStarter(subject, rules);
        this.indexMapRef.modify(populationStarter);
        populationStarter.startPopulation();
    }

    private static void processUpdate(IndexUpdaterMap updaterMap, IndexEntryUpdate<IndexDescriptor> indexUpdate, CursorContext cursorContext) throws IndexEntryConflictException {
        IndexUpdater updater = updaterMap.getUpdater((IndexDescriptor)indexUpdate.indexKey(), cursorContext);
        if (updater != null) {
            updater.process(indexUpdate);
        }
    }

    public void dropIndex(IndexDescriptor indexDescriptor) {
        this.indexDropController.dropIndex(indexDescriptor);
    }

    public void internalIndexDrop(IndexDescriptor indexDescriptor) {
        Preconditions.checkState((this.state == State.RUNNING || this.state == State.NOT_STARTED ? 1 : 0) != 0, (String)"Dropping index in unexpected state %s", (Object[])new Object[]{this.state.name()});
        this.indexMapRef.modify(indexMap -> {
            long indexId = indexDescriptor.getId();
            IndexProxy index = indexMap.removeIndexProxy(indexId);
            if (this.state == State.RUNNING) {
                Preconditions.checkState((index != null ? 1 : 0) != 0, (String)"Index %s doesn't exists", (Object[])new Object[]{indexDescriptor});
                index.drop();
            } else if (index != null) {
                try {
                    index.drop();
                }
                catch (Exception e) {
                    try (CursorContext cursorContext = this.contextFactory.create(INDEX_SERVICE_INDEX_CLOSING_TAG);){
                        index.close(cursorContext);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return indexMap;
        });
    }

    @VisibleForTesting
    public void forceIndexState(String indexName, InternalIndexState state) {
        this.indexMapRef.modify(indexMap -> {
            IndexDescriptor descriptor = indexMap.getAllIndexProxies().stream().map(IndexProxy::getDescriptor).filter(id -> indexName.equals(id.getName())).findFirst().orElseThrow();
            indexMap.removeIndexProxy(descriptor.getId());
            indexMap.putIndexProxy(switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case InternalIndexState.ONLINE -> this.indexProxyCreator.createOnlineIndexProxy(descriptor);
                case InternalIndexState.POPULATING -> this.indexProxyCreator.createPopulatingIndexProxy(descriptor, IndexMonitor.NO_MONITOR, this.newIndexPopulationJob(descriptor.schema().entityType(), Subject.SYSTEM));
                case InternalIndexState.FAILED -> this.indexProxyCreator.createFailedIndexProxy(descriptor, IndexPopulationFailure.failure("test forced failure"));
            });
            return indexMap;
        });
        this.schemaState.clear();
    }

    public void triggerIndexSampling(IndexSamplingMode mode) {
        this.internalLog.info("Manual trigger for sampling all indexes [" + mode + "]");
        this.monitor.indexSamplingTriggered(mode);
        this.samplingController.sampleIndexes(mode);
    }

    public void triggerIndexSampling(IndexDescriptor index, IndexSamplingMode mode) {
        String description = index.userDescription(this.tokenNameLookup);
        this.internalLog.info("Manual trigger for sampling index " + description + " [" + mode + "]");
        this.samplingController.sampleIndex(index.getId(), mode);
    }

    private static void dropRecoveringIndexes(IndexMap indexMap, LongIterable indexesToRebuild) {
        indexesToRebuild.forEach((LongProcedure & Serializable)idx -> {
            IndexProxy indexProxy = indexMap.removeIndexProxy(idx);
            assert (indexProxy != null);
            indexProxy.drop();
        });
    }

    public void activateIndex(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getIndexProxy(descriptor);
                index.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
                index.activate();
                this.internalLog.info("Constraint %s is %s.", new Object[]{index.getDescriptor(), InternalIndexState.ONLINE.name()});
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new InternalKernelRuntimeException((Throwable)e, "Unable to activate index, thread was interrupted.");
        }
    }

    public IndexProxy getIndexProxy(IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(index);
    }

    public Iterable<IndexProxy> getIndexProxies() {
        return this.indexMapRef.getAllIndexProxies();
    }

    public void checkpoint(DatabaseFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        try (FileFlushEvent fileFlushEvent = flushEvent.beginFileFlush();){
            this.internalLog.debug("Checkpointing %s", new Object[]{this.indexStatisticsStore.storeFile().getFileName()});
            this.indexStatisticsStore.checkpoint(fileFlushEvent, cursorContext);
        }
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("force", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)proxy -> {
            this.internalLog.debug("Checkpointing %s", new Object[]{proxy.getDescriptor().userDescription(this.tokenNameLookup)});
            try (FileFlushEvent fileFlushEvent = flushEvent.beginFileFlush();){
                proxy.force(fileFlushEvent, cursorContext);
            }
        })));
    }

    private LongObjectProcedure<IndexProxy> indexProxyOperation(String name, ThrowingConsumer<IndexProxy, Exception> operation) {
        return (LongObjectProcedure & Serializable)(id, indexProxy) -> {
            try {
                operation.accept(indexProxy);
            }
            catch (Exception e) {
                try {
                    if (this.indexMapRef.getIndexProxy(indexProxy.getDescriptor()) != null) {
                        throw new UnderlyingStorageException("Unable to " + name + " " + indexProxy, (Throwable)e);
                    }
                }
                catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                    // empty catch block
                }
            }
        };
    }

    private void closeAllIndexes() {
        try (CursorContext cursorContext = this.contextFactory.create(INDEX_SERVICE_INDEX_CLOSING_TAG);){
            this.indexMapRef.modify(indexMap -> {
                Collection<IndexProxy> indexesToStop = indexMap.getAllIndexProxies();
                for (IndexProxy index : indexesToStop) {
                    try {
                        index.close(cursorContext);
                    }
                    catch (Exception e) {
                        this.internalLog.error("Unable to close index", (Throwable)e);
                    }
                }
                return new IndexMap();
            });
        }
    }

    public ResourceIterator<Path> snapshotIndexFiles() throws IOException {
        ArrayList<ResourceIterator> snapshots = new ArrayList<ResourceIterator>();
        snapshots.add(Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexStatisticsStore.storeFile())));
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshots.iterator());
    }

    public IndexMonitor getMonitor() {
        return this.monitor;
    }

    private IndexPopulationJob newIndexPopulationJob(EntityType type, Subject subject) {
        MultipleIndexPopulator multiPopulator = new MultipleIndexPopulator(this.storeView, this.internalLogProvider, type, this.schemaState, this.jobScheduler, this.tokenNameLookup, this.contextFactory, this.memoryTracker, this.databaseName, subject, this.config);
        return new IndexPopulationJob(multiPopulator, this.monitor, this.contextFactory, this.memoryTracker, this.databaseName, subject, EntityType.NODE, this.config);
    }

    private void startIndexPopulation(IndexPopulationJob job, CursorContext cursorContext) {
        if (this.storeView.isEmpty(cursorContext)) {
            job.run();
        } else {
            this.populationJobController.startIndexPopulation(job);
        }
    }

    private String indexStateInfo(String tag, InternalIndexState state, IndexDescriptor descriptor) {
        return String.format("IndexingService.%s: index %d on %s is %s", tag, descriptor.getId(), descriptor.schema().userDescription(this.tokenNameLookup), state.name());
    }

    private void logIndexStateSummary(String method, Map<InternalIndexState, List<IndexLogRecord>> indexStates, int totalIndexes, Duration elapsed) {
        if (indexStates.isEmpty()) {
            return;
        }
        int mostPopularStateCount = Integer.MIN_VALUE;
        InternalIndexState mostPopularState = null;
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            if (indexStateEntry.getValue().size() <= mostPopularStateCount) continue;
            mostPopularState = indexStateEntry.getKey();
            mostPopularStateCount = indexStateEntry.getValue().size();
        }
        indexStates.remove(mostPopularState);
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            InternalIndexState state = indexStateEntry.getKey();
            List<IndexLogRecord> logRecords = indexStateEntry.getValue();
            for (IndexLogRecord logRecord : logRecords) {
                this.internalLog.info(this.indexStateInfo(method, state, logRecord.descriptor()));
            }
        }
        this.internalLog.info(String.format("IndexingService.%s: indexes not specifically mentioned above are %s. Total %d indexes. Processed in %s", method, mostPopularState, totalIndexes, Format.duration((long)elapsed.toMillis(), (TimeUnit)TimeUnit.HOURS, (TimeUnit)TimeUnit.MILLISECONDS)));
    }

    @VisibleForTesting
    public void reportUsageStatistics() {
        if (this.kernelVersionProvider.kernelVersion().isAtLeast(KernelVersion.VERSION_INDEX_USAGE_STATISTICS_INTRODUCED)) {
            this.indexMapRef.getAllIndexProxies().forEach(p -> p.reportUsageStatistics((IndexUsageStatsConsumer)this.indexStatisticsStore));
        }
    }

    private /* synthetic */ IndexMap lambda$start$3(MutableLongObjectMap rebuildingDescriptors, IndexMap indexMap) {
        Stopwatch stopwatch = Stopwatch.start();
        EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
        indexMap.forEachIndexProxy((LongObjectProcedure<IndexProxy>)(LongObjectProcedure & Serializable)(indexId, proxy) -> {
            InternalIndexState state = proxy.getState();
            IndexDescriptor descriptor = proxy.getDescriptor();
            IndexLogRecord indexLogRecord = new IndexLogRecord(descriptor);
            indexStates.computeIfAbsent(state, internalIndexState -> new ArrayList()).add(indexLogRecord);
            this.internalLog.debug(this.indexStateInfo("start", state, descriptor));
            switch (state) {
                case ONLINE: 
                case FAILED: {
                    proxy.start();
                    break;
                }
                case POPULATING: {
                    rebuildingDescriptors.put(indexId, (Object)descriptor);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + state);
                }
            }
        });
        this.logIndexStateSummary("start", indexStates, indexMap.size(), stopwatch.elapsed());
        this.dontRebuildIndexesInReadOnlyMode((MutableLongObjectMap<IndexDescriptor>)rebuildingDescriptors);
        IndexingService.dropRecoveringIndexes(indexMap, (LongIterable)rebuildingDescriptors.keySet());
        this.populateIndexesOfAllTypes((MutableLongObjectMap<IndexDescriptor>)rebuildingDescriptors, indexMap);
        return indexMap;
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }

    @FunctionalInterface
    public static interface IndexProxyProvider {
        public IndexProxy getIndexProxy(IndexDescriptor var1) throws IndexNotFoundKernelException;
    }

    private record IndexPopulationCategory(EntityType entityType, boolean lookupIndexDifferentiator) {
        IndexPopulationCategory(IndexDescriptor descriptor, StorageEngineIndexingBehaviour indexingBehaviour) {
            this(descriptor.schema().entityType(), descriptor.schema().entityType() == EntityType.RELATIONSHIP && indexingBehaviour.useNodeIdsInRelationshipTokenIndex() && descriptor.isTokenIndex());
        }
    }

    private final class IndexPopulationStarter
    implements UnaryOperator<IndexMap> {
        private final Subject subject;
        private final IndexDescriptor[] descriptors;
        private final Map<IndexPopulationCategory, IndexPopulationJob> populationJobs = new HashMap<IndexPopulationCategory, IndexPopulationJob>();

        IndexPopulationStarter(Subject subject, IndexDescriptor[] descriptors) {
            this.subject = subject;
            this.descriptors = descriptors;
        }

        @Override
        public IndexMap apply(IndexMap indexMap) {
            for (IndexDescriptor descriptor : this.descriptors) {
                IndexProxy index = indexMap.getIndexProxy(descriptor);
                if (index != null && IndexingService.this.state == State.NOT_STARTED) continue;
                IndexDescriptor completeDescriptor = IndexingService.this.completeConfiguration(descriptor);
                if (IndexingService.this.state == State.RUNNING) {
                    IndexPopulationJob populationJob = this.populationJobs.computeIfAbsent(new IndexPopulationCategory(completeDescriptor, IndexingService.this.storageEngineIndexingBehaviour), category -> IndexingService.this.newIndexPopulationJob(completeDescriptor.schema().entityType(), this.subject));
                    index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(completeDescriptor, IndexingService.this.monitor, populationJob);
                    index.start();
                } else {
                    index = IndexingService.this.indexProxyCreator.createRecoveringIndexProxy(completeDescriptor);
                }
                indexMap.putIndexProxy(index);
            }
            return indexMap;
        }

        void startPopulation() {
            try (CursorContext cursorContext = IndexingService.this.contextFactory.create(IndexingService.START_TAG);){
                this.populationJobs.keySet().stream().sorted((o1, o2) -> Boolean.compare(o1.lookupIndexDifferentiator, o2.lookupIndexDifferentiator)).forEach(category -> IndexingService.this.startIndexPopulation(this.populationJobs.get(category), cursorContext));
            }
        }
    }

    private record IndexLogRecord(IndexDescriptor descriptor) {
    }
}

