/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class SystemGraphDatabaseReferenceRepository
implements DatabaseReferenceRepository {
    private static final DatabaseReference SYSTEM_DATABASE_REFERENCE = new DatabaseReferenceImpl.Internal(new NormalizedDatabaseName("system"), NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID, true);
    private final Supplier<DatabaseContext> systemDatabaseSupplier;

    public SystemGraphDatabaseReferenceRepository(Supplier<DatabaseContext> systemDatabaseSupplier) {
        this.systemDatabaseSupplier = systemDatabaseSupplier;
    }

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName databaseAlias) {
        if (Objects.equals("system", databaseAlias.name())) {
            return Optional.of(SYSTEM_DATABASE_REFERENCE);
        }
        return this.execute(model -> model.getDatabaseRefByAlias(this.normalizeCatalogName(databaseAlias.name())));
    }

    private String normalizeCatalogName(String databaseAlias) {
        if (databaseAlias.matches("`.*\\..*`")) {
            String unquoted = databaseAlias.substring(1, databaseAlias.length() - 1);
            return unquoted.replace("``", "`");
        }
        return databaseAlias;
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        return this.execute(TopologyGraphDbmsModel::getAllDatabaseReferences);
    }

    @Override
    public Set<DatabaseReferenceImpl.Internal> getInternalDatabaseReferences() {
        return this.execute(TopologyGraphDbmsModel::getAllInternalDatabaseReferences);
    }

    @Override
    public Set<DatabaseReferenceImpl.External> getExternalDatabaseReferences() {
        return this.execute(TopologyGraphDbmsModel::getAllExternalDatabaseReferences);
    }

    @Override
    public Set<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferences() {
        return this.execute(TopologyGraphDbmsModel::getAllCompositeDatabaseReferences);
    }

    @Override
    public Optional<DatabaseReferenceImpl.SPD> getSpdDatabaseReference() {
        return this.execute(TopologyGraphDbmsModel::getAllShardedPropertyDatabaseReferences).stream().findFirst();
    }

    private <T> T execute(Function<TopologyGraphDbmsModel, T> operation) {
        DatabaseContext databaseContext = this.systemDatabaseSupplier.get();
        GraphDatabaseAPI systemDb = databaseContext.databaseFacade();
        if (!systemDb.isAvailable(100L)) {
            throw new DatabaseShutdownException((Throwable)new DatabaseManagementException("System database is not (yet) available"));
        }
        try (Transaction tx = systemDb.beginTx();){
            CommunityTopologyGraphDbmsModel model = new CommunityTopologyGraphDbmsModel(tx);
            T t = operation.apply(model);
            return t;
        }
    }
}

