/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public abstract class DatabaseReferenceImpl
implements DatabaseReference {
    private static final Comparator<DatabaseReference> referenceComparator = Comparator.comparing(a -> a.alias().name(), String::compareToIgnoreCase);
    private static final Comparator<DatabaseReference> nullSafeReferenceComparator = Comparator.nullsLast(referenceComparator);
    private static final NormalizedDatabaseName defaultNamespace = new NormalizedDatabaseName("system-root");

    public int compareTo(DatabaseReference that) {
        return nullSafeReferenceComparator.compare(this, that);
    }

    public String toPrettyString() {
        String namespace = this.namespace().map(ns -> ns.name() + ".").orElse("");
        String name = this.alias().name();
        return namespace + name;
    }

    public NormalizedDatabaseName fullName() {
        String namespace = this.namespace().map(ns -> ns.name() + ".").orElse("");
        String name = this.alias().name();
        return new NormalizedDatabaseName(namespace + name);
    }

    public boolean isComposite() {
        return false;
    }

    public static final class SPD
    extends Internal {
        private final Map<Integer, DatabaseReference> entityDetailStores;

        public static String shardName(String databaseName, int index) {
            return String.format("%s-shard-%02d", databaseName, index);
        }

        public static <T> Map<Integer, T> createForShards(String databaseName, int count, Function<String, Optional<T>> mapper) {
            return IntStream.range(0, count).boxed().collect(Collectors.toMap(i -> i, i -> ((Optional)mapper.apply(SPD.shardName(databaseName, i))).orElseThrow()));
        }

        public SPD(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, Map<Integer, DatabaseReference> entityDetailStores) {
            super(alias, namedDatabaseId, true);
            this.entityDetailStores = entityDetailStores;
        }

        @Override
        public Optional<NormalizedDatabaseName> namespace() {
            return Optional.empty();
        }

        public Map<Integer, DatabaseReference> entityDetailStores() {
            return this.entityDetailStores;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SPD spd = (SPD)o;
            return Objects.equals(this.entityDetailStores, spd.entityDetailStores());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.entityDetailStores);
        }

        @Override
        public String toString() {
            return "ShardedPropertyDatabase{alias=" + this.alias + ", namespace=" + this.namespace + ", namedDatabaseId=" + this.namedDatabaseId + ", primary=" + this.primary + ", entityDetailStores=" + this.entityDetailStores + "}";
        }
    }

    public static final class Composite
    extends Internal {
        private final List<DatabaseReference> constituents;

        public Composite(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, Set<DatabaseReference> constituents) {
            super(alias, namedDatabaseId, true);
            this.constituents = constituents.stream().sorted().toList();
        }

        @Override
        public Optional<NormalizedDatabaseName> namespace() {
            return Optional.empty();
        }

        public List<DatabaseReference> constituents() {
            return this.constituents;
        }

        public Optional<DatabaseReference> getConstituentByName(String databaseName) {
            for (DatabaseReference constituent : this.constituents) {
                if (!constituent.fullName().equals((Object)new NormalizedDatabaseName(databaseName))) continue;
                return Optional.of(constituent);
            }
            return Optional.empty();
        }

        public Optional<DatabaseReference> getConstituentById(UUID databaseId) {
            for (DatabaseReference constituent : this.constituents) {
                if (!constituent.id().equals(databaseId)) continue;
                return Optional.of(constituent);
            }
            return Optional.empty();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Composite composite = (Composite)o;
            return Objects.equals(this.constituents, composite.constituents);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.constituents);
        }

        @Override
        public String toString() {
            return "Composite{alias=" + this.alias + ", namespace=" + this.namespace + ", namedDatabaseId=" + this.namedDatabaseId + ", primary=" + this.primary + ", constituents=" + this.constituents + "}";
        }

        @Override
        public boolean isComposite() {
            return true;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class Internal
    extends DatabaseReferenceImpl {
        protected final NormalizedDatabaseName alias;
        protected final NormalizedDatabaseName namespace;
        protected final NamedDatabaseId namedDatabaseId;
        protected final boolean primary;

        public Internal(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, boolean primary) {
            this(alias, null, namedDatabaseId, primary);
        }

        public Internal(NormalizedDatabaseName alias, NormalizedDatabaseName namespace, NamedDatabaseId namedDatabaseId, boolean primary) {
            this.alias = alias;
            this.namespace = Objects.equals(namespace, defaultNamespace) ? null : namespace;
            this.namedDatabaseId = namedDatabaseId;
            this.primary = primary;
        }

        public NamedDatabaseId databaseId() {
            return this.namedDatabaseId;
        }

        public NormalizedDatabaseName alias() {
            return this.alias;
        }

        public Optional<NormalizedDatabaseName> namespace() {
            return Optional.ofNullable(this.namespace);
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public UUID id() {
            return this.namedDatabaseId.databaseId().uuid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Internal internal = (Internal)o;
            return this.primary == internal.primary && Objects.equals(this.alias, internal.alias) && Objects.equals(this.namespace, internal.namespace) && Objects.equals(this.namedDatabaseId, internal.namedDatabaseId);
        }

        public int hashCode() {
            return Objects.hash(this.alias, this.namespace, this.namedDatabaseId, this.primary);
        }

        public String toString() {
            return "Internal{alias=" + this.alias + ", namespace=" + this.namespace + ", namedDatabaseId=" + this.namedDatabaseId + ", primary=" + this.primary + "}";
        }
    }

    public static final class External
    extends DatabaseReferenceImpl {
        private final NormalizedDatabaseName targetAlias;
        private final NormalizedDatabaseName alias;
        private final NormalizedDatabaseName namespace;
        private final RemoteUri externalUri;
        private final UUID uuid;

        public External(NormalizedDatabaseName targetAlias, NormalizedDatabaseName alias, RemoteUri externalUri, UUID uuid) {
            this(targetAlias, alias, null, externalUri, uuid);
        }

        public External(NormalizedDatabaseName targetAlias, NormalizedDatabaseName alias, NormalizedDatabaseName namespace, RemoteUri externalUri, UUID uuid) {
            this.targetAlias = targetAlias;
            this.alias = alias;
            this.namespace = Objects.equals(namespace, defaultNamespace) ? null : namespace;
            this.externalUri = externalUri;
            this.uuid = uuid;
        }

        public NormalizedDatabaseName alias() {
            return this.alias;
        }

        public Optional<NormalizedDatabaseName> namespace() {
            return Optional.ofNullable(this.namespace);
        }

        public boolean isPrimary() {
            return false;
        }

        public RemoteUri externalUri() {
            return this.externalUri;
        }

        public NormalizedDatabaseName targetAlias() {
            return this.targetAlias;
        }

        public UUID id() {
            return this.uuid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            External external = (External)o;
            return Objects.equals(this.targetAlias, external.targetAlias) && Objects.equals(this.alias, external.alias) && Objects.equals(this.namespace, external.namespace) && Objects.equals(this.externalUri, external.externalUri) && Objects.equals(this.uuid, external.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.targetAlias, this.alias, this.namespace, this.externalUri, this.uuid);
        }

        public String toString() {
            return "External{alias=" + this.alias + ", namespace=" + this.namespace + ", remoteUri=" + this.externalUri + ", remoteName=" + this.targetAlias + ", uuid=" + this.uuid + "}";
        }
    }
}

