/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Objects;
import org.neo4j.internal.helpers.collection.LfuCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class TransactionMetadataCache {
    private static final int DEFAULT_METADATA_CACHE_SIZE = 10000;
    private final LfuCache<Long, TransactionMetadata> appendIndexMetadataCache = new LfuCache("Append index start position cache", 10000);

    public void clear() {
        this.appendIndexMetadataCache.clear();
    }

    public TransactionMetadata getTransactionMetadata(long appendIndex) {
        return (TransactionMetadata)this.appendIndexMetadataCache.get((Object)appendIndex);
    }

    public void cacheTransactionMetadata(long appendIndex, LogPosition position) {
        if (LogPosition.UNSPECIFIED == position) {
            throw new IllegalArgumentException("Metadata cache only supports specified log positions.");
        }
        TransactionMetadata result = new TransactionMetadata(position);
        this.appendIndexMetadataCache.put((Object)appendIndex, (Object)result);
    }

    public record TransactionMetadata(LogPosition startPosition) {
        @Override
        public String toString() {
            return "TransactionMetadata{, startPosition=" + this.startPosition + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetadata that = (TransactionMetadata)o;
            return Objects.equals(this.startPosition, that.startPosition);
        }
    }
}

