/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.ReadTracer;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

class DefaultRelationshipTraversalCursor
extends DefaultRelationshipCursor<DefaultRelationshipTraversalCursor>
implements RelationshipTraversalCursor {
    private final StorageRelationshipTraversalCursor storeCursor;
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private DefaultNodeCursor securityNodeCursor;
    private LongIterator addedRelationships;
    private long originNodeReference;
    private RelationshipSelection selection;
    private long neighbourNodeReference;

    DefaultRelationshipTraversalCursor(CursorPool<DefaultRelationshipTraversalCursor> pool, StorageRelationshipTraversalCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super((StorageRelationshipCursor)storeCursor, pool);
        this.storeCursor = storeCursor;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    void init(long nodeReference, long reference, RelationshipSelection selection, Read read) {
        this.originNodeReference = nodeReference;
        this.selection = selection;
        this.neighbourNodeReference = -1L;
        this.storeCursor.init(nodeReference, reference, selection);
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    void init(DefaultNodeCursor nodeCursor, RelationshipSelection selection, Read read) {
        this.originNodeReference = nodeCursor.nodeReference();
        this.selection = selection;
        this.neighbourNodeReference = -1L;
        if (!nodeCursor.currentNodeIsAddedInTx()) {
            nodeCursor.storeCursor.relationships(this.storeCursor, selection);
        } else {
            this.storeCursor.reset();
        }
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    void init(long addedRelationship, Read read) {
        assert (addedRelationship != -1L);
        this.originNodeReference = -1L;
        this.neighbourNodeReference = -1L;
        this.selection = null;
        this.storeCursor.reset();
        this.init(read);
        this.checkHasChanges = false;
        this.hasChanges = true;
        this.addedRelationships = PrimitiveLongCollections.single((long)addedRelationship);
    }

    void init(DefaultNodeCursor nodeCursor, RelationshipSelection selection, long neighbourNodeReference, Read read) {
        this.originNodeReference = nodeCursor.nodeReference();
        this.selection = selection;
        this.neighbourNodeReference = neighbourNodeReference;
        if (!nodeCursor.currentNodeIsAddedInTx()) {
            nodeCursor.storeCursor.relationshipsTo(this.storeCursor, selection, neighbourNodeReference);
        }
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    public void otherNode(NodeCursor cursor) {
        this.read.singleNode(this.otherNodeReference(), cursor);
    }

    public long otherNodeReference() {
        if (this.currentAddedInTx != -1L) {
            long originNodeReference = this.originNodeReference();
            if (this.txStateSourceNodeReference == originNodeReference) {
                return this.txStateTargetNodeReference;
            }
            if (this.txStateTargetNodeReference == originNodeReference) {
                return this.txStateSourceNodeReference;
            }
            throw new IllegalStateException(String.format("Relationship[%d] which was added in tx has an origin node [%d] which is neither source [%d] nor target [%d]", this.currentAddedInTx, originNodeReference, this.txStateSourceNodeReference, this.txStateTargetNodeReference));
        }
        return this.storeCursor.neighbourNodeReference();
    }

    public long originNodeReference() {
        return this.originNodeReference;
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            while (this.addedRelationships.hasNext()) {
                long next = this.addedRelationships.next();
                this.read.txState().relationshipVisit(next, this.relationshipTxStateDataVisitor);
                if (this.applyAccessModeToTxState && !this.allowed() || this.neighbourNodeReference != -1L && this.otherNodeReference() != this.neighbourNodeReference) continue;
                if (this.tracer != null) {
                    this.tracer.onRelationship(this.relationshipReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (this.storeCursor.next()) {
            boolean skip = hasChanges && this.read.txState().relationshipIsDeletedInThisBatch(this.storeCursor.entityReference());
            if (skip || !this.allowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        super.setTracer(tracer);
        this.storeCursor.setTracer((ReadTracer)tracer);
    }

    @Override
    public void removeTracer() {
        this.storeCursor.removeTracer();
        super.removeTracer();
    }

    protected boolean allowed() {
        AccessMode accessMode = this.read.getAccessMode();
        if (accessMode.allowsTraverseRelType(this.type())) {
            if (accessMode.allowsTraverseAllLabels()) {
                return true;
            }
            if (this.securityNodeCursor == null) {
                this.securityNodeCursor = this.internalCursors.allocateNodeCursor();
            }
            if (this.applyAccessModeToTxState && this.currentAddedInTx != -1L && this.neighbourNodeReference != -1L) {
                this.read.singleNode(this.neighbourNodeReference, this.securityNodeCursor);
            } else {
                this.read.singleNode(this.storeCursor.neighbourNodeReference(), this.securityNodeCursor);
            }
            return this.securityNodeCursor.next();
        }
        return false;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.selection = null;
            this.storeCursor.close();
            if (this.securityNodeCursor != null) {
                this.securityNodeCursor.close();
                this.securityNodeCursor.release();
                this.securityNodeCursor = null;
            }
        }
        super.closeInternal();
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        if (this.selection != null) {
            this.addedRelationships = this.selection.addedRelationships(this.read.txState().getNodeState(this.originNodeReference));
        }
    }

    public boolean isClosed() {
        return this.read == null;
    }

    @Override
    public void release() {
        if (this.storeCursor != null) {
            this.storeCursor.close();
        }
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
            this.securityNodeCursor = null;
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTraversalCursor[closed state]";
        }
        return "RelationshipTraversalCursor[id=" + this.storeCursor.entityReference() + ", " + this.storeCursor + "]";
    }
}

