/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.util.Optional;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LastAppendBatchInfoProvider;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class LogTailInformation
implements LogTailMetadata {
    public final CheckpointInfo lastCheckPoint;
    public final long firstAppendIndexAfterLastCheckPoint;
    public final boolean filesNotFound;
    public final long currentLogVersion;
    public final byte firstLogEntryVersionAfterCheckpoint;
    private final boolean recordAfterCheckpoint;
    private final StoreId storeId;
    private final KernelVersionProvider fallbackKernelVersionProvider;
    private final LastAppendBatchInfoProvider lastAppendBatchInfoProvider;
    private AppendBatchInfo lastBatchInfo;

    public LogTailInformation(boolean recordAfterCheckpoint, long firstAppendIndexAfterLastCheckPoint, boolean filesNotFound, long currentLogVersion, byte firstLogEntryVersionAfterCheckpoint, KernelVersionProvider fallbackKernelVersionProvider, LastAppendBatchInfoProvider lastAppendBatchInfoProvider) {
        this(null, recordAfterCheckpoint, firstAppendIndexAfterLastCheckPoint, filesNotFound, currentLogVersion, firstLogEntryVersionAfterCheckpoint, null, fallbackKernelVersionProvider, lastAppendBatchInfoProvider);
    }

    public LogTailInformation(CheckpointInfo lastCheckPoint, boolean recordAfterCheckpoint, long firstAppendIndexAfterLastCheckPoint, boolean filesNotFound, long currentLogVersion, byte firstLogEntryVersionAfterCheckpoint, StoreId storeId, KernelVersionProvider fallbackKernelVersionProvider, LastAppendBatchInfoProvider lastAppendBatchInfoProvider) {
        this.lastCheckPoint = lastCheckPoint;
        this.firstAppendIndexAfterLastCheckPoint = firstAppendIndexAfterLastCheckPoint;
        this.filesNotFound = filesNotFound;
        this.currentLogVersion = currentLogVersion;
        this.firstLogEntryVersionAfterCheckpoint = firstLogEntryVersionAfterCheckpoint;
        this.recordAfterCheckpoint = recordAfterCheckpoint;
        this.storeId = storeId;
        this.fallbackKernelVersionProvider = fallbackKernelVersionProvider;
        this.lastAppendBatchInfoProvider = lastAppendBatchInfoProvider;
    }

    public boolean logsAfterLastCheckpoint() {
        return this.recordAfterCheckpoint;
    }

    public boolean logsMissing() {
        return this.lastCheckPoint == null && this.filesNotFound;
    }

    public boolean hasUnreadableBytesInCheckpointLogs() {
        return this.lastCheckPoint != null && !this.lastCheckPoint.channelPositionAfterCheckpoint().equals((Object)this.lastCheckPoint.checkpointFilePostReadPosition());
    }

    public boolean isRecoveryRequired() {
        return this.recordAfterCheckpoint || this.logsMissing() || this.hasUnreadableBytesInCheckpointLogs();
    }

    public Optional<StoreId> getStoreId() {
        return Optional.ofNullable(this.storeId);
    }

    public Optional<CheckpointInfo> getLastCheckPoint() {
        return Optional.ofNullable(this.lastCheckPoint);
    }

    public String toString() {
        return "LogTailInformation{lastCheckPoint=" + this.lastCheckPoint + ", firstAppendIndexAfterLastCheckPoint=" + this.firstAppendIndexAfterLastCheckPoint + ", filesNotFound=" + this.filesNotFound + ", currentLogVersion=" + this.currentLogVersion + ", firstLogEntryVersionAfterCheckpoint=" + this.firstLogEntryVersionAfterCheckpoint + ", recordAfterCheckpoint=" + this.recordAfterCheckpoint + "}";
    }

    public long getCheckpointLogVersion() {
        if (this.lastCheckPoint == null) {
            return EMPTY_LOG_TAIL.getCheckpointLogVersion();
        }
        return this.lastCheckPoint.channelPositionAfterCheckpoint().getLogVersion();
    }

    public KernelVersion kernelVersion() {
        if (this.lastCheckPoint != null) {
            return this.lastCheckPoint.kernelVersion();
        }
        if (this.firstLogEntryVersionAfterCheckpoint != 0) {
            return KernelVersion.getForVersion((byte)this.firstLogEntryVersionAfterCheckpoint);
        }
        return this.fallbackKernelVersionProvider.kernelVersion();
    }

    public long getLogVersion() {
        return this.filesNotFound ? EMPTY_LOG_TAIL.getLogVersion() : this.currentLogVersion;
    }

    public TransactionId getLastCommittedTransaction() {
        if (this.lastCheckPoint == null) {
            return TransactionIdStore.emptyVersionedTransaction((KernelVersion)this.kernelVersion());
        }
        return this.lastCheckPoint.transactionId();
    }

    public LogPosition getLastTransactionLogPosition() {
        if (this.lastCheckPoint == null) {
            return EMPTY_LOG_TAIL.getLastTransactionLogPosition();
        }
        return this.lastCheckPoint.transactionLogPosition();
    }

    public long getLastCheckpointedAppendIndex() {
        if (this.lastCheckPoint == null) {
            return EMPTY_LOG_TAIL.getLastCheckpointedAppendIndex();
        }
        return this.lastCheckPoint.appendIndex();
    }

    public AppendBatchInfo lastBatch() {
        if (this.filesNotFound) {
            return EMPTY_LOG_TAIL.lastBatch();
        }
        if (this.lastBatchInfo != null) {
            return this.lastBatchInfo;
        }
        this.lastBatchInfo = (AppendBatchInfo)this.lastAppendBatchInfoProvider.get();
        return this.lastBatchInfo;
    }
}

