/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import inet.ipaddr.IPAddressString;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.AccessRule;

public class WebURLAccessRule
implements AccessRule<URL> {
    public static final String LOAD_CSV_USER_AGENT_PREFIX = "NeoLoadCSV_";
    private static final int REDIRECT_LIMIT = 10;
    private final Configuration config;
    public static final int CONNECTION_TIMEOUT = 2000;
    public static final int READ_TIMOUT = 600000;
    private static final CookieManager cookieManager = new CookieManager();

    public WebURLAccessRule(Configuration config) {
        this.config = config;
    }

    public static String userAgent() {
        Runtime.Version version = Runtime.version();
        String agent = System.getProperty("http.agent");
        if (agent == null) {
            return "Java/" + version;
        }
        return agent + " Java/" + version;
    }

    URL checkNotBlockedAndPinToIP(URL url, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws UnknownHostException, MalformedURLException, URISyntaxException, URLAccessValidationError {
        List blockedIpRanges = (List)this.config.get(GraphDatabaseInternalSettings.cypher_ip_blocklist);
        InetAddress inetAddress = InetAddress.getByName(url.getHost());
        for (IPAddressString blockedIpRange : blockedIpRanges) {
            if (!blockedIpRange.contains(new IPAddressString(inetAddress.getHostAddress()))) continue;
            throw new URLAccessValidationError("access to " + inetAddress + " is blocked via the configuration property " + GraphDatabaseInternalSettings.cypher_ip_blocklist.name());
        }
        securityAuthorizationHandler.assertLoadAllowed(securityContext, url.toURI(), inetAddress);
        URL result = url;
        if (url.getProtocol().equals("http") || url.getProtocol().equals("ftp")) {
            Object ipAddress = inetAddress instanceof Inet6Address ? "[" + inetAddress.getHostAddress() + "]" : inetAddress.getHostAddress();
            result = this.substituteHostByIP(url, (String)ipAddress);
        }
        return result;
    }

    protected URL substituteHostByIP(URL u, String ip) throws MalformedURLException {
        String s = u.getUserInfo();
        Object object = s != null && !s.isEmpty() ? s + "@" : "";
        s = u.getHost();
        String string = s != null && !s.isEmpty() ? ip : "";
        int port = u.getPort();
        s = u.getPath();
        String string2 = s != null ? s : "";
        s = u.getQuery();
        Object object2 = s != null ? "?" + s : "";
        s = u.getRef();
        String newURLString = u.getProtocol() + "://" + (String)object + string + (String)(port != u.getDefaultPort() && port > 0 ? ":" + Integer.toString(port) : "") + string2 + (String)object2 + (String)(s != null ? "#" + s : "");
        return new URL(newURLString);
    }

    private URLConnection checkUrlIncludingHops(URL url, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws IOException, URISyntaxException, URLAccessValidationError {
        URLConnection urlCon;
        boolean keepFollowingRedirects;
        URL result = url;
        int redirectLimit = 10;
        do {
            if ((urlCon = (result = this.checkNotBlockedAndPinToIP(result, securityAuthorizationHandler, securityContext)).openConnection()) instanceof HttpURLConnection) {
                URL newUrl;
                HttpURLConnection httpCon = (HttpURLConnection)urlCon;
                httpCon.setRequestProperty("User-Agent", String.format("%s%s", LOAD_CSV_USER_AGENT_PREFIX, WebURLAccessRule.userAgent()));
                httpCon.setInstanceFollowRedirects(false);
                httpCon.connect();
                httpCon.getInputStream();
                keepFollowingRedirects = WebURLAccessRule.isRedirect(httpCon.getResponseCode());
                if (!keepFollowingRedirects) continue;
                if (redirectLimit-- == 0) {
                    httpCon.disconnect();
                    throw new URLAccessValidationError("Redirect limit exceeded");
                }
                String location = httpCon.getHeaderField("Location");
                if (location == null) {
                    httpCon.disconnect();
                    throw new IOException("URL responded with a redirect but the location header was null");
                }
                try {
                    newUrl = new URL(location);
                    if (!newUrl.getProtocol().equalsIgnoreCase(result.getProtocol())) {
                        return httpCon;
                    }
                }
                catch (MalformedURLException e) {
                    newUrl = new URL(httpCon.getURL(), location);
                }
                result = newUrl;
                continue;
            }
            keepFollowingRedirects = false;
        } while (keepFollowingRedirects);
        return urlCon;
    }

    private static boolean isRedirect(int responseCode) {
        return responseCode >= 300 && responseCode <= 307 && responseCode != 306 && responseCode != 304;
    }

    public URLConnection validate(URL url, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws URLAccessValidationError, IOException {
        String host = url.getHost();
        if (host != null && !host.isEmpty()) {
            try {
                return this.checkUrlIncludingHops(url, securityAuthorizationHandler, securityContext);
            }
            catch (URISyntaxException e) {
                throw new URLAccessValidationError("Unable to verify access to " + host + ". Cause: " + e.getMessage());
            }
        }
        throw new URLAccessValidationError("Unable to verify access to URL" + url + ". URL is missing a host.");
    }

    @Override
    public CharReadable getReader(URL url, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws URLAccessValidationError {
        try {
            InputStream stream = this.openStream(url, securityAuthorizationHandler, securityContext);
            return Readables.wrap((InputStream)stream, (String)url.toString(), (Charset)StandardCharsets.UTF_8, (long)0L);
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadExternalResourceException(String.format("Couldn't load the external resource at: %s", url), (Throwable)e);
        }
    }

    private InputStream openStream(URL url, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws IOException, URISyntaxException, URLAccessValidationError {
        URLConnection con = this.validate(url, securityAuthorizationHandler, securityContext);
        if (con instanceof HttpURLConnection && WebURLAccessRule.isRedirect(((HttpURLConnection)con).getResponseCode())) {
            throw new LoadExternalResourceException(String.format("LOAD CSV failed to access resource. The request to %s was at some point redirected to from which it could not proceed. This may happen if %s redirects to a resource which uses a different protocol than the original request.", con.getURL(), con.getURL()));
        }
        con.setConnectTimeout(2000);
        con.setReadTimeout(600000);
        InputStream stream = con.getInputStream();
        if ("gzip".equals(con.getContentEncoding())) {
            return new GZIPInputStream(stream);
        }
        if ("deflate".equals(con.getContentEncoding())) {
            return new InflaterInputStream(stream);
        }
        return stream;
    }

    static {
        CookieHandler.setDefault(cookieManager);
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
    }
}

