/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.tracer;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.tracer.CountingLogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;

class CountingLogCheckPointEvent
implements LogCheckPointEvent {
    private final AtomicLong checkpointCounter = new AtomicLong();
    private final AtomicLong accumulatedCheckpointTotalTimeMillis = new AtomicLong();
    private final long maxPages;
    private final LongAdder appendedBytes;
    private final CountingLogRotateEvent countingLogRotateEvent;
    private volatile LastCheckpointInfo lastCheckpointInfo = new LastCheckpointInfo(0L, 0L, 0L, 0L, 0L, 0L);
    private final DatabaseFlushEvent databaseFlushEvent;

    CountingLogCheckPointEvent(PageCacheTracer pageCacheTracer, LongAdder appendedBytes, CountingLogRotateEvent countingLogRotateEvent) {
        this.maxPages = pageCacheTracer.maxPages();
        this.appendedBytes = appendedBytes;
        this.countingLogRotateEvent = countingLogRotateEvent;
        this.databaseFlushEvent = pageCacheTracer.beginDatabaseFlush();
    }

    @Override
    public void checkpointCompleted(long checkpointMillis) {
        this.checkpointCounter.incrementAndGet();
        this.accumulatedCheckpointTotalTimeMillis.addAndGet(checkpointMillis);
        this.lastCheckpointInfo = new LastCheckpointInfo(checkpointMillis, this.databaseFlushEvent.pagesFlushed(), this.databaseFlushEvent.ioPerformed(), this.databaseFlushEvent.getIoLimit(), this.databaseFlushEvent.getTimesLimited(), this.databaseFlushEvent.getMillisLimited());
    }

    @Override
    public void close() {
    }

    @Override
    public void appendedBytes(long bytes) {
        this.appendedBytes.add(bytes);
    }

    @Override
    public DatabaseFlushEvent beginDatabaseFlush() {
        this.databaseFlushEvent.reset();
        return this.databaseFlushEvent;
    }

    @Override
    public long getPagesFlushed() {
        return this.lastCheckpointInfo.pagesFlushed();
    }

    @Override
    public long getIOsPerformed() {
        return this.lastCheckpointInfo.performedIO();
    }

    @Override
    public long getTimesPaused() {
        return this.lastCheckpointInfo.timesPaused();
    }

    @Override
    public long getMillisPaused() {
        return this.lastCheckpointInfo.millisPaused();
    }

    @Override
    public long getConfiguredIOLimit() {
        return this.lastCheckpointInfo.ioLimit();
    }

    @Override
    public double flushRatio() {
        if (this.maxPages == 0L) {
            return 0.0;
        }
        return (double)this.lastCheckpointInfo.pagesFlushed() / (double)this.maxPages;
    }

    @Override
    public LogForceWaitEvent beginLogForceWait() {
        return LogForceWaitEvent.NULL;
    }

    @Override
    public LogForceEvent beginLogForce() {
        return LogForceEvent.NULL;
    }

    long numberOfCheckPoints() {
        return this.checkpointCounter.get();
    }

    long checkPointAccumulatedTotalTimeMillis() {
        return this.accumulatedCheckpointTotalTimeMillis.get();
    }

    long lastCheckpointTimeMillis() {
        return this.lastCheckpointInfo.timeMillis();
    }

    @Override
    public LogRotateEvent beginLogRotate() {
        return this.countingLogRotateEvent;
    }

    public long flushedBytes() {
        return this.databaseFlushEvent.getFlushEvent().localBytesWritten();
    }

    private record LastCheckpointInfo(long timeMillis, long pagesFlushed, long performedIO, long ioLimit, long timesPaused, long millisPaused) {
    }
}

