/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UpdateCountingIndexUpdater;
import org.neo4j.kernel.impl.api.index.stats.IndexUsageStatsConsumer;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class OnlineIndexProxy
implements IndexProxy {
    private final IndexProxyStrategy indexProxyStrategy;
    final IndexAccessor accessor;
    private final IndexUsageTracking usageTracking;
    private final DatabaseIndexStats indexCounters;
    private boolean started;
    private final boolean forcedIdempotentMode;

    OnlineIndexProxy(IndexProxyStrategy indexProxyStrategy, IndexAccessor accessor, boolean forcedIdempotentMode, IndexUsageTracking usageTracking, DatabaseIndexStats indexCounters) {
        this.usageTracking = usageTracking;
        assert (accessor != null);
        this.indexProxyStrategy = indexProxyStrategy;
        this.accessor = accessor;
        this.forcedIdempotentMode = forcedIdempotentMode;
        this.indexCounters = indexCounters;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        IndexUpdater actual = this.accessor.newUpdater(this.escalateModeIfNecessary(mode), cursorContext, parallel);
        return this.started ? this.updateCountingUpdater(actual) : actual;
    }

    private IndexUpdateMode escalateModeIfNecessary(IndexUpdateMode mode) {
        if (this.forcedIdempotentMode) {
            if (mode != IndexUpdateMode.ONLINE) {
                throw new IllegalArgumentException("Unexpected mode " + mode + " given that " + this + " has been marked with forced idempotent mode. Expected mode " + IndexUpdateMode.ONLINE);
            }
            return IndexUpdateMode.ONLINE_IDEMPOTENT;
        }
        return mode;
    }

    private IndexUpdater updateCountingUpdater(IndexUpdater indexUpdater) {
        return new UpdateCountingIndexUpdater(this.indexProxyStrategy, indexUpdater);
    }

    public void drop() {
        this.indexProxyStrategy.removeStatisticsForIndex();
        this.accessor.drop();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.indexProxyStrategy.getIndexDescriptor();
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) {
        this.accessor.force(flushEvent, cursorContext);
    }

    @Override
    public void refresh() {
        this.accessor.refresh();
    }

    @Override
    public void close(CursorContext cursorContext) throws IOException {
        this.accessor.close();
    }

    @Override
    public ValueIndexReader newValueReader() {
        return this.accessor.newValueReader(this.usageTracking.track());
    }

    @Override
    public TokenIndexReader newTokenReader() {
        return this.accessor.newTokenReader(this.usageTracking.track());
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) {
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
        this.accessor.validateBeforeCommit(entityId, tuple);
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is ONLINE");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.DONE;
    }

    public ResourceIterator<Path> snapshotFiles() throws IOException {
        return this.accessor.snapshotFiles();
    }

    public Map<String, Value> indexConfig() {
        return this.accessor.indexConfig();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + this.accessor + ", descriptor:" + this.indexProxyStrategy.getIndexDescriptor() + "]";
    }

    @VisibleForTesting
    public IndexAccessor accessor() {
        return this.accessor;
    }

    @Override
    public void reportUsageStatistics(IndexUsageStatsConsumer consumer) {
        IndexDescriptor descriptor = this.getDescriptor();
        IndexUsageStats stats = this.usageTracking.getAndReset();
        this.indexCounters.reportQueryCount(descriptor, stats.readCount());
        consumer.addUsageStats(descriptor.getId(), stats);
    }
}

