/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.UnclosableChannel;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryDetachedCheckpointV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class CheckpointInfoFactory {
    private static final long COMMIT_ENTRY_OFFSET = 22L;
    private static final long LEGACY_COMMIT_ENTRY_OFFSET = 18L;

    public static CheckpointInfo ofLogEntry(LogEntry entry, LogPosition checkpointEntryPosition, LogPosition channelPositionAfterCheckpoint, LogPosition checkpointFilePostReadPosition, TransactionLogFilesContext context, LogFile logFile) {
        if (entry instanceof LogEntryDetachedCheckpointV4_2) {
            LogEntryDetachedCheckpointV4_2 checkpoint42 = (LogEntryDetachedCheckpointV4_2)entry;
            TransactionInfo transactionInfo = CheckpointInfoFactory.readTransactionInfo(context, logFile, checkpoint42.getLogPosition());
            return new CheckpointInfo(checkpoint42.getLogPosition(), checkpoint42.getStoreId(), checkpointEntryPosition, channelPositionAfterCheckpoint, checkpointFilePostReadPosition, transactionInfo.version(), transactionInfo.transactionId(), checkpoint42.getReason());
        }
        if (entry instanceof LogEntryDetachedCheckpointV5_0) {
            LogEntryDetachedCheckpointV5_0 checkpoint50 = (LogEntryDetachedCheckpointV5_0)entry;
            return new CheckpointInfo(checkpoint50.getLogPosition(), checkpoint50.getStoreId(), checkpointEntryPosition, channelPositionAfterCheckpoint, checkpointFilePostReadPosition, checkpoint50.getVersion(), checkpoint50.getTransactionId(), checkpoint50.getReason());
        }
        throw new UnsupportedOperationException("Expected to observe only checkpoint entries, but: `" + entry + "` was found.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TransactionInfo readTransactionInfo(TransactionLogFilesContext context, LogFile logFile, LogPosition transactionPosition) {
        try (PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(transactionPosition.getLogVersion());
             ReadAheadLogChannel reader = new ReadAheadLogChannel(new UnclosableChannel(channel), LogVersionBridge.NO_MORE_CHANNELS, context.getMemoryTracker());
             LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)new VersionAwareLogEntryReader(context.getCommandReaderFactory()), (ReadableClosablePositionAwareChecksumChannel)reader);){
            Object logEntry;
            LogPosition checkedPosition = null;
            while (logEntryCursor.next()) {
                logEntry = logEntryCursor.get();
                checkedPosition = reader.getCurrentPosition();
                if (!(logEntry instanceof LogEntryCommit)) continue;
                LogEntryCommit commit = (LogEntryCommit)logEntry;
                if (!checkedPosition.equals((Object)transactionPosition)) continue;
                TransactionInfo transactionInfo = new TransactionInfo(new TransactionId(commit.getTxId(), commit.getChecksum(), commit.getTimeWritten()), commit.getVersion());
                return transactionInfo;
            }
            if ((Boolean)context.getConfig().get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files) != false) throw new IllegalStateException("Checkpoint record pointed to " + transactionPosition + ", but log commit entry not found at that position. Last checked position: " + checkedPosition);
            logEntry = new TransactionInfo(TransactionIdStore.UNKNOWN_TRANSACTION_ID, KernelVersion.V4_4);
            return logEntry;
        }
        catch (IOException e) {
            Throwable cause = e;
            try (PhysicalLogVersionedStoreChannel fallbackChannel = logFile.openForVersion(transactionPosition.getLogVersion());){
                fallbackChannel.position(transactionPosition.getByteOffset() - 22L);
                Optional<TransactionInfo> transactionInfo44 = CheckpointInfoFactory.tryReadTransactionInfo(fallbackChannel, context, false);
                if (transactionInfo44.isPresent()) {
                    TransactionInfo logEntry = transactionInfo44.get();
                    return logEntry;
                }
                fallbackChannel.position(transactionPosition.getByteOffset() - 18L);
                Optional<TransactionInfo> transactionInfo42 = CheckpointInfoFactory.tryReadTransactionInfo(fallbackChannel, context, true);
                if (!transactionInfo42.isPresent()) throw new RuntimeException("Unable to find last transaction in log files. Position: " + transactionPosition, cause);
                TransactionInfo transactionInfo = transactionInfo42.get();
                return transactionInfo;
            }
            catch (Exception fe) {
                cause = Exceptions.chain((Throwable)cause, (Throwable)fe);
            }
            throw new RuntimeException("Unable to find last transaction in log files. Position: " + transactionPosition, cause);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to find last transaction in log files. Position: " + transactionPosition, t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<TransactionInfo> tryReadTransactionInfo(PhysicalLogVersionedStoreChannel fallbackChannel, TransactionLogFilesContext context, boolean skipChecksum) throws IOException {
        try (ReadAheadLogChannel fallbackReader = new ReadAheadLogChannel(new UnclosableChannel(fallbackChannel), LogVersionBridge.NO_MORE_CHANNELS, context.getMemoryTracker());){
            byte versionCode = fallbackReader.get();
            if (versionCode > KernelVersion.LATEST.version()) {
                Optional<TransactionInfo> optional = Optional.empty();
                return optional;
            }
            KernelVersion kernelVersion = versionCode < KernelVersion.EARLIEST.version() ? KernelVersion.EARLIEST : KernelVersion.getForVersion((byte)versionCode);
            boolean reverseBytes = kernelVersion.isLessThan(KernelVersion.VERSION_LITTLE_ENDIAN_TX_LOG_INTRODUCED);
            byte entryCode = fallbackReader.get();
            if (entryCode != 5) {
                Optional<TransactionInfo> optional = Optional.empty();
                return optional;
            }
            long transactionId = CheckpointInfoFactory.maybeReverse(fallbackReader.getLong(), reverseBytes);
            long timeWritten = CheckpointInfoFactory.maybeReverse(fallbackReader.getLong(), reverseBytes);
            int checksum = skipChecksum ? 0 : CheckpointInfoFactory.maybeReverse(fallbackReader.getInt(), reverseBytes);
            Optional<TransactionInfo> optional = Optional.of(new TransactionInfo(new TransactionId(transactionId, checksum, timeWritten), kernelVersion));
            return optional;
        }
        catch (Exception e) {
            context.getLogProvider().getLog(CheckpointInfoFactory.class).debug("Fail to extract legacy transaction info.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static int maybeReverse(int value, boolean reverseBytes) {
        return reverseBytes ? Integer.reverseBytes(value) : value;
    }

    private static long maybeReverse(long value, boolean reverseBytes) {
        return reverseBytes ? Long.reverseBytes(value) : value;
    }

    private record TransactionInfo(TransactionId transactionId, KernelVersion version) {
    }
}

