/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionLogQueue;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

class QueueTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final TransactionLogQueue transactionLogQueue;

    QueueTransactionAppender(TransactionLogQueue transactionLogQueue) {
        this.transactionLogQueue = transactionLogQueue;
    }

    public void start() throws Exception {
        this.transactionLogQueue.start();
    }

    public void shutdown() throws Exception {
        this.transactionLogQueue.shutdown();
    }

    @Override
    public long append(TransactionToApply batch, LogAppendEvent logAppendEvent) throws IOException, ExecutionException, InterruptedException {
        long committedTxId = this.transactionLogQueue.submit(batch, logAppendEvent).getCommittedTxId();
        QueueTransactionAppender.publishAsCommitted(batch);
        return committedTxId;
    }

    private static void publishAsCommitted(TransactionToApply batch) {
        while (batch != null) {
            batch.publishAsCommitted();
            batch = batch.next();
        }
    }
}

