/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import org.neo4j.common.Subject;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.StorageCommand;

public class PhysicalTransactionCursor
implements TransactionCursor {
    private final ReadableClosablePositionAwareChecksumChannel channel;
    private final LogEntryCursor logEntryCursor;
    private final LogPositionMarker lastGoodPositionMarker = new LogPositionMarker();
    private CommittedTransactionRepresentation current;

    public PhysicalTransactionCursor(ReadableClosablePositionAwareChecksumChannel channel, LogEntryReader entryReader) throws IOException {
        this.channel = channel;
        channel.getCurrentPosition(this.lastGoodPositionMarker);
        this.logEntryCursor = new LogEntryCursor(entryReader, channel);
    }

    public CommittedTransactionRepresentation get() {
        return this.current;
    }

    public boolean next() throws IOException {
        this.current = null;
        if (!this.logEntryCursor.next()) {
            return false;
        }
        LogEntry entry = this.logEntryCursor.get();
        assert (entry instanceof LogEntryStart) : "Expected Start entry, read " + entry + " instead";
        LogEntryStart startEntry = (LogEntryStart)entry;
        ArrayList<StorageCommand> entries = new ArrayList<StorageCommand>();
        while (true) {
            if (!this.logEntryCursor.next()) {
                return false;
            }
            entry = this.logEntryCursor.get();
            if (entry instanceof LogEntryCommit) break;
            LogEntryCommand command = (LogEntryCommand)entry;
            entries.add(command.getCommand());
        }
        LogEntryCommit commitEntry = (LogEntryCommit)entry;
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(entries, startEntry.getAdditionalHeader(), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), commitEntry.getTimeWritten(), -1, Subject.ANONYMOUS);
        this.current = new CommittedTransactionRepresentation(startEntry, transaction, commitEntry);
        this.channel.getCurrentPosition(this.lastGoodPositionMarker);
        return true;
    }

    public void close() throws IOException {
        this.logEntryCursor.close();
    }

    @Override
    public LogPosition position() {
        return this.lastGoodPositionMarker.newPosition();
    }
}

