/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.nio.file.Path;
import java.time.Instant;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.logging.InternalLog;

public class LoggingLogFileMonitor
implements RecoveryMonitor,
RecoveryStartInformationProvider.Monitor,
LogRotationMonitor {
    private long firstTransactionRecovered = -1L;
    private long lastTransactionRecovered;
    private final InternalLog log;

    public LoggingLogFileMonitor(InternalLog log) {
        this.log = log;
    }

    @Override
    public void recoveryRequired(LogPosition startPosition) {
        this.log.info("Recovery required from position " + startPosition);
    }

    @Override
    public void recoveryCompleted(int numberOfRecoveredTransactions, long recoveryTimeInMilliseconds) {
        if (numberOfRecoveredTransactions != 0) {
            this.log.info(String.format("Recovery completed. %d transactions, first:%d, last:%d recovered, time spent: %s", numberOfRecoveredTransactions, this.firstTransactionRecovered, this.lastTransactionRecovered, Format.duration((long)recoveryTimeInMilliseconds)));
        } else {
            this.log.info("No recovery required");
        }
    }

    @Override
    public void failToRecoverTransactionsAfterCommit(Throwable t, LogEntryCommit commitEntry, LogPosition recoveryToPosition) {
        this.log.warn(String.format("Fail to recover all transactions. Last recoverable transaction id:%d, committed at:%d. Any later transaction after %s are unreadable and will be truncated.", commitEntry.getTxId(), commitEntry.getTimeWritten(), recoveryToPosition), t);
    }

    @Override
    public void partialRecovery(RecoveryPredicate recoveryPredicate, CommittedTransactionRepresentation lastTransaction) {
        this.log.info("Partial database recovery based on provided criteria: " + recoveryPredicate.describe() + ". Last replayed transaction: " + LoggingLogFileMonitor.describeTransaction(lastTransaction) + ".");
    }

    @Override
    public void failToRecoverTransactionsAfterPosition(Throwable t, LogPosition recoveryFromPosition) {
        this.log.warn(String.format("Fail to recover all transactions. Any later transactions after position %s are unreadable and will be truncated.", recoveryFromPosition), t);
    }

    @Override
    public void failToExtractInitialFileHeader(Exception e) {
        this.log.warn("Fail to read initial transaction log file header.", (Throwable)e);
    }

    @Override
    public void transactionRecovered(long txId) {
        if (this.firstTransactionRecovered == -1L) {
            this.firstTransactionRecovered = txId;
        }
        this.lastTransactionRecovered = txId;
    }

    @Override
    public void noCommitsAfterLastCheckPoint(LogPosition logPosition) {
        this.log.info(String.format("No commits found after last check point (which is at %s)", logPosition != null ? logPosition.toString() : "<no log position given>"));
    }

    @Override
    public void commitsAfterLastCheckPoint(LogPosition logPosition, long firstTxIdAfterLastCheckPoint) {
        this.log.info(String.format("Commits found after last check point (which is at %s). First txId after last checkpoint: %d ", logPosition, firstTxIdAfterLastCheckPoint));
    }

    @Override
    public void noCheckPointFound() {
        this.log.info("No check point found in transaction log");
    }

    @Override
    public void started(Path logFile, long logVersion) {
        this.log.info("Starting transaction log [%s] at version=%d", new Object[]{logFile, logVersion});
    }

    @Override
    public void startRotation(long currentLogVersion) {
    }

    @Override
    public void finishLogRotation(Path logFile, long logVersion, long lastTransactionId, long rotationMillis, long millisSinceLastRotation) {
        StringBuilder sb = new StringBuilder("Rotated to transaction log [");
        sb.append(logFile).append("] version=").append(logVersion).append(", last transaction in previous log=");
        sb.append(lastTransactionId).append(", rotation took ").append(rotationMillis).append(" millis");
        if (millisSinceLastRotation > 0L) {
            sb.append(", started after ").append(millisSinceLastRotation).append(" millis");
        }
        this.log.info(sb.append('.').toString());
    }

    private static String describeTransaction(CommittedTransactionRepresentation lastTransaction) {
        if (lastTransaction == null) {
            return "Not found.";
        }
        LogEntryCommit commitEntry = lastTransaction.getCommitEntry();
        return "transaction id: " + commitEntry.getTxId() + ", time " + Format.date((Instant)Instant.ofEpochMilli(commitEntry.getTimeWritten()));
    }
}

