/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultEntityTokenIndexCursor;

public abstract class DefaultRelationshipTypeIndexCursor
extends DefaultEntityTokenIndexCursor<DefaultRelationshipTypeIndexCursor>
implements RelationshipTypeIndexCursor {
    DefaultRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool) {
        super(pool);
    }

    @Override
    LongSet createAddedInTxState(TransactionState txState, int token) {
        return txState.relationshipsWithTypeChanged(token).getAdded().freeze();
    }

    @Override
    LongSet createDeletedInTxState(TransactionState txState, int token) {
        return txState.addedAndRemovedRelationships().getRemoved().freeze();
    }

    @Override
    void traceScan(KernelReadTracer tracer, int token) {
        tracer.onRelationshipTypeScan(token);
    }

    @Override
    void traceNext(KernelReadTracer tracer, long entity) {
        tracer.onRelationship(entity);
    }

    @Override
    boolean allowedToSeeAllEntitiesWithToken(AccessMode accessMode, int token) {
        return accessMode.allowsTraverseRelType(token) && accessMode.allowsTraverseAllLabels();
    }

    public int type() {
        return this.tokenId;
    }

    public long relationshipReference() {
        return this.entityReference();
    }

    public float score() {
        return Float.NaN;
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTypeIndexCursor[closed state]";
        }
        return "RelationshipTypeIndexCursor[relationship=" + this.entityReference() + "]";
    }

    public abstract void release();
}

