/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.common.Subject;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.chunk.ChunkMetadata;
import org.neo4j.kernel.impl.api.chunk.CommandChunk;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.CommandBatch;

public record RollbackChunkRepresentation(KernelVersion kernelVersion, long transactionId, long timeWritten, int checksum) implements CommittedCommandBatch
{
    @Override
    public CommandBatch commandBatch() {
        return new CommandChunk(Collections.emptyList(), new ChunkMetadata(false, true, true, LogPosition.UNSPECIFIED, -1L, new MutableLong(-1L), this.timeWritten, -1L, this.timeWritten, -1, this.kernelVersion, Subject.ANONYMOUS));
    }

    @Override
    public int serialize(LogEntryWriter<? extends WritableChannel> writer) throws IOException {
        return writer.writeRollbackEntry(this.kernelVersion, this.transactionId, this.timeWritten);
    }

    @Override
    public long txId() {
        return this.transactionId;
    }

    @Override
    public boolean isRollback() {
        return true;
    }

    @Override
    public LogPosition previousBatchLogPosition() {
        return LogPosition.UNSPECIFIED;
    }
}

