/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.storageengine.api.PropertySelection;

class DefaultNodeValueIndexCursor
extends DefaultEntityValueIndexCursor<DefaultNodeValueIndexCursor>
implements NodeValueIndexCursor {
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private DefaultNodeCursor securityNodeCursor;
    private DefaultPropertyCursor securityPropertyCursor;
    private int[] propertyIds;

    DefaultNodeValueIndexCursor(CursorPool<DefaultNodeValueIndexCursor> pool, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool);
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    @Override
    protected boolean canAccessAllDescribedEntities(IndexDescriptor descriptor) {
        this.propertyIds = descriptor.schema().getPropertyIds();
        int[] labelIds = descriptor.schema().getEntityTokenIds();
        AccessMode accessMode = this.read.getAccessMode();
        for (int label : labelIds) {
            if (accessMode.allowsTraverseAllNodesWithLabel(label)) continue;
            return false;
        }
        for (int propId : this.propertyIds) {
            if (accessMode.disallowsReadPropertyForSomeLabel(propId)) {
                return false;
            }
            for (int label : labelIds) {
                if (accessMode.allowsReadNodeProperty(() -> Labels.from(label), propId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    void traceOnEntity(KernelReadTracer tracer, long entity) {
        tracer.onNode(entity);
    }

    @Override
    String implementationName() {
        return "NodeValueIndexCursor";
    }

    @Override
    protected final boolean canAccessEntityAndProperties(long reference) {
        this.ensureSecurityNodeCursor();
        this.readEntity(read -> read.singleNode(reference, this.securityNodeCursor));
        if (!this.securityNodeCursor.next()) {
            return false;
        }
        int[] labels = this.securityNodeCursor.labelsIgnoringTxStateSetRemove().all();
        AccessMode accessMode = this.read.getAccessMode();
        if (accessMode.hasPropertyReadRules(this.propertyIds)) {
            this.ensureSecurityPropertyCursor();
            this.securityNodeCursor.properties(this.securityPropertyCursor, PropertySelection.selection((int[])this.propertyIds));
            return this.securityPropertyCursor.allowed(this.propertyIds, labels);
        }
        return accessMode.allowsReadNodeProperties(() -> Labels.from(labels), this.propertyIds);
    }

    public void node(NodeCursor cursor) {
        this.readEntity(read -> read.singleNode(this.entityReference(), cursor));
    }

    public long nodeReference() {
        return this.entityReference();
    }

    @Override
    protected LongSet removed(TransactionState txState, LongSet removedFromIndex) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)removedFromIndex).asUnmodifiable();
    }

    @Override
    public void release() {
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
            this.securityNodeCursor = null;
        }
        if (this.securityPropertyCursor != null) {
            this.securityPropertyCursor.close();
            this.securityPropertyCursor.release();
            this.securityPropertyCursor = null;
        }
    }

    @Override
    protected boolean doStoreValuePassesQueryFilter(long reference, PropertySelection propertySelection, PropertyIndexQuery[] query) {
        this.ensureSecurityNodeCursor();
        this.read.singleNode(reference, this.securityNodeCursor);
        if (this.securityNodeCursor.next()) {
            this.ensureSecurityPropertyCursor();
            this.securityNodeCursor.properties(this.securityPropertyCursor, propertySelection);
            return CursorPredicates.propertiesMatch(this.securityPropertyCursor, query);
        }
        return false;
    }

    private void ensureSecurityNodeCursor() {
        if (this.securityNodeCursor == null) {
            this.securityNodeCursor = this.internalCursors.allocateNodeCursor();
        }
    }

    private void ensureSecurityPropertyCursor() {
        if (this.securityPropertyCursor == null) {
            this.securityPropertyCursor = this.internalCursors.allocatePropertyCursor();
        }
    }
}

