/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.IOException;
import java.net.URL;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.FileURLAccessRule;
import org.neo4j.kernel.impl.security.WebURLAccessRule;

public class URLAccessRules {
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final WebURLAccessRule webAccess;
    private final FileURLAccessRule fileAccess;

    public URLAccessRules(AbstractSecurityLog securityLog, Configuration configuration) {
        this.securityAuthorizationHandler = new SecurityAuthorizationHandler(securityLog);
        this.webAccess = new WebURLAccessRule(configuration);
        this.fileAccess = new FileURLAccessRule(configuration);
    }

    public WebURLAccessRule webAccess() {
        return this.webAccess;
    }

    public CharReadable validateAndOpen(SecurityContext securityContext, URL url) throws URLAccessValidationError {
        String protocol = url.getProtocol();
        try {
            return switch (protocol) {
                case "file" -> this.fileAccess.getReader(url, this.securityAuthorizationHandler, securityContext);
                case "http", "https", "ftp" -> this.webAccess.getReader(url, this.securityAuthorizationHandler, securityContext);
                default -> throw new URLAccessValidationError("loading resources via protocol '" + protocol + "' is not permitted");
            };
        }
        catch (IOException e) {
            throw new LoadExternalResourceException(String.format("Couldn't load the external resource at: %s", url), (Throwable)e);
        }
    }
}

