/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.Supplier;
import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserAggregationUpdater;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AdminAccessMode;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.BasicContext;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextGraphDatabaseAPI;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureKernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextValueMapper;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.kernel.impl.security.WebUrlAccessChecker;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public abstract class ProcedureCaller {
    final ProcedureView procedureView;
    final DependencyResolver databaseDependencies;

    private ProcedureCaller(DependencyResolver databaseDependencies, ProcedureView procedureView) {
        this.databaseDependencies = databaseDependencies;
        this.procedureView = procedureView;
    }

    public AnyValue callFunction(int id, AnyValue[] input, ProcedureCallContext context) throws ProcedureException {
        this.performCheckBeforeOperation();
        AccessMode mode = this.securityContext().mode();
        if (!mode.allowsExecuteFunction(id).allowsAccess()) {
            String message = String.format("Executing a user defined function is not allowed for %s.", this.securityContext().description());
            throw this.securityAuthorizationHandler().logAndGetAuthorizationException(this.securityContext(), message);
        }
        SecurityContext securityContext = mode.shouldBoostFunction(id).allowsAccess() ? this.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, AccessMode.Static.READ)) : this.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, AccessMode.Static.READ));
        try (OverridableSecurityContext.Revertable ignore = this.overrideSecurityContext(securityContext);){
            AnyValue anyValue = this.procedureView.callFunction(this.prepareContext(securityContext, context), id, input);
            return anyValue;
        }
    }

    public AnyValue callBuiltInFunction(int id, AnyValue[] input, ProcedureCallContext context) throws ProcedureException {
        this.performCheckBeforeOperation();
        return this.procedureView.callFunction(this.prepareContext(this.securityContext(), context), id, input);
    }

    AccessMode checkAggregationFunctionAccessMode(int functionId) {
        AccessMode mode = this.securityContext().mode();
        if (!mode.allowsExecuteAggregatingFunction(functionId).allowsAccess()) {
            String message = String.format("Executing a user defined aggregating function is not allowed for %s.", this.securityContext().description());
            throw this.securityAuthorizationHandler().logAndGetAuthorizationException(this.securityContext(), message);
        }
        return mode;
    }

    UserAggregationReducer createGenericAggregator(boolean overrideAccessMode, AccessMode mode, int functionId, ProcedureCallContext context) throws ProcedureException {
        final SecurityContext securityContext = overrideAccessMode ? this.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, AccessMode.Static.READ)) : this.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, AccessMode.Static.READ));
        try (OverridableSecurityContext.Revertable ignore = this.overrideSecurityContext(securityContext);){
            final UserAggregationReducer aggregator = this.procedureView.createAggregationFunction(this.prepareContext(securityContext, context), functionId);
            UserAggregationReducer userAggregationReducer = new UserAggregationReducer(){

                public UserAggregationUpdater newUpdater() throws ProcedureException {
                    try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                        final UserAggregationUpdater updater = aggregator.newUpdater();
                        UserAggregationUpdater userAggregationUpdater = new UserAggregationUpdater(){

                            public void update(AnyValue[] input) throws ProcedureException {
                                try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                                    updater.update(input);
                                }
                            }

                            public void applyUpdates() throws ProcedureException {
                                try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                                    updater.applyUpdates();
                                }
                            }
                        };
                        return userAggregationUpdater;
                    }
                }

                public AnyValue result() throws ProcedureException {
                    try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                        AnyValue anyValue = aggregator.result();
                        return anyValue;
                    }
                }
            };
            return userAggregationReducer;
        }
    }

    public UserAggregationReducer createBuiltInAggregationFunction(int id, ProcedureCallContext context) throws ProcedureException {
        this.performCheckBeforeOperation();
        return this.procedureView.createAggregationFunction(this.prepareContext(this.securityContext(), context), id);
    }

    Context prepareContext(SecurityContext securityContext, ProcedureCallContext procedureContext) {
        return BasicContext.buildContext(this.databaseDependencies, this.createValueMapper()).withKernelTransaction(this.kernelTransaction()).withGraphDatabaseSupplier(this.graphDatabaseAPISupplier()).withSecurityContext(securityContext).withProcedureCallContext(procedureContext).withClock(this.clockContext()).withUrlAccessChecker(this.urlAccessChecker()).context();
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(int id, AnyValue[] input, AccessMode.Static procedureMode, ProcedureCallContext procedureCallContext) throws ProcedureException {
        RawIterator<AnyValue[], ProcedureException> procedureCall;
        this.performCheckBeforeOperation();
        SecurityContext securityContext = this.securityContext();
        AccessMode mode = securityContext.mode();
        if (!mode.allowsExecuteProcedure(id).allowsAccess()) {
            String message = String.format("Executing procedure is not allowed for %s.", securityContext.description());
            throw this.securityAuthorizationHandler().logAndGetAuthorizationException(securityContext, message);
        }
        SecurityContext procedureSecurityContext = mode.shouldBoostProcedure(id).allowsAccess() ? securityContext.withMode((AccessMode)new OverriddenAccessMode(mode, procedureMode)).withMode(AdminAccessMode.FULL) : securityContext.withMode((AccessMode)new RestrictedAccessMode(mode, procedureMode));
        try (OverridableSecurityContext.Revertable ignore = this.overrideSecurityContext(procedureSecurityContext);){
            procedureCall = this.doCallProcedure(this.prepareContext(procedureSecurityContext, procedureCallContext), id, input);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<AnyValue[], ProcedureException> createIterator(final SecurityContext procedureSecurityContext, final RawIterator<AnyValue[], ProcedureException> procedureCall) {
        return new RawIterator<AnyValue[], ProcedureException>(){

            public boolean hasNext() throws ProcedureException {
                try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            public AnyValue[] next() throws ProcedureException {
                try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(procedureSecurityContext);){
                    AnyValue[] anyValueArray = (AnyValue[])procedureCall.next();
                    return anyValueArray;
                }
            }
        };
    }

    abstract SecurityContext securityContext();

    abstract OverridableSecurityContext.Revertable overrideSecurityContext(SecurityContext var1);

    abstract KernelTransaction kernelTransaction();

    abstract Supplier<GraphDatabaseAPI> graphDatabaseAPISupplier();

    abstract void performCheckBeforeOperation();

    abstract SecurityAuthorizationHandler securityAuthorizationHandler();

    abstract ClockContext clockContext();

    URLAccessChecker urlAccessChecker() {
        return new WebUrlAccessChecker(((URLAccessRules)this.databaseDependencies.resolveDependency(URLAccessRules.class)).webAccess(), this.securityAuthorizationHandler(), this.securityContext());
    }

    abstract ValueMapper<Object> createValueMapper();

    public abstract UserAggregationReducer createAggregationFunction(int var1, ProcedureCallContext var2) throws ProcedureException;

    abstract RawIterator<AnyValue[], ProcedureException> doCallProcedure(Context var1, int var2, AnyValue[] var3) throws ProcedureException;

    public static class ForThreadExecutionContextScope
    extends ProcedureCaller {
        private final ExecutionContext executionContext;
        private final OverridableSecurityContext overridableSecurityContext;
        private final ExecutionContextProcedureKernelTransaction ktx;
        private final SecurityAuthorizationHandler securityAuthorizationHandler;
        private final Supplier<ClockContext> clockContextSupplier;

        ForThreadExecutionContextScope(ExecutionContext executionContext, DependencyResolver databaseDependencies, OverridableSecurityContext overridableSecurityContext, ExecutionContextProcedureKernelTransaction ktx, SecurityAuthorizationHandler securityAuthorizationHandler, Supplier<ClockContext> clockContextSupplier, ProcedureView procedureView) {
            super(databaseDependencies, procedureView);
            this.executionContext = executionContext;
            this.overridableSecurityContext = overridableSecurityContext;
            this.ktx = ktx;
            this.securityAuthorizationHandler = securityAuthorizationHandler;
            this.clockContextSupplier = clockContextSupplier;
        }

        @Override
        public UserAggregationReducer createAggregationFunction(int id, ProcedureCallContext context) throws ProcedureException {
            boolean overrideAccessMode;
            this.performCheckBeforeOperation();
            AccessMode mode = this.checkAggregationFunctionAccessMode(id);
            boolean bl = overrideAccessMode = mode != AccessMode.Static.FULL && mode.shouldBoostAggregatingFunction(id).allowsAccess();
            if (overrideAccessMode) {
                return this.createGenericAggregator(true, mode, id, context);
            }
            return this.procedureView.createAggregationFunction(this.prepareContext(this.securityContext(), context), id);
        }

        @Override
        RawIterator<AnyValue[], ProcedureException> doCallProcedure(Context ctx, int id, AnyValue[] input) throws ProcedureException {
            return this.procedureView.callProcedure(ctx, id, input, (ResourceMonitor)this.executionContext);
        }

        @Override
        SecurityContext securityContext() {
            return this.overridableSecurityContext.currentSecurityContext();
        }

        @Override
        OverridableSecurityContext.Revertable overrideSecurityContext(SecurityContext context) {
            return this.overridableSecurityContext.overrideWith(context);
        }

        @Override
        ExecutionContextProcedureKernelTransaction kernelTransaction() {
            return this.ktx;
        }

        @Override
        Supplier<GraphDatabaseAPI> graphDatabaseAPISupplier() {
            return () -> new ExecutionContextGraphDatabaseAPI((GraphDatabaseAPI)this.databaseDependencies.resolveDependency(GraphDatabaseAPI.class));
        }

        @Override
        void performCheckBeforeOperation() {
            this.ktx.assertOpen();
        }

        @Override
        SecurityAuthorizationHandler securityAuthorizationHandler() {
            return this.securityAuthorizationHandler;
        }

        @Override
        ClockContext clockContext() {
            return this.clockContextSupplier.get();
        }

        @Override
        ValueMapper<Object> createValueMapper() {
            return new ExecutionContextValueMapper(this.executionContext);
        }
    }

    public static class ForTransactionScope
    extends ProcedureCaller {
        private final KernelTransaction ktx;

        public ForTransactionScope(KernelTransaction ktx, DependencyResolver databaseDependencies, ProcedureView procedureView) {
            super(databaseDependencies, procedureView);
            this.ktx = ktx;
        }

        @Override
        void performCheckBeforeOperation() {
            this.ktx.assertOpen();
        }

        @Override
        SecurityAuthorizationHandler securityAuthorizationHandler() {
            return this.ktx.securityAuthorizationHandler();
        }

        @Override
        ClockContext clockContext() {
            return this.ktx.clocks();
        }

        @Override
        ValueMapper<Object> createValueMapper() {
            return new DefaultValueMapper(this.ktx.internalTransaction());
        }

        @Override
        public UserAggregationReducer createAggregationFunction(int id, ProcedureCallContext context) throws ProcedureException {
            this.performCheckBeforeOperation();
            AccessMode mode = this.checkAggregationFunctionAccessMode(id);
            boolean overrideAccessMode = mode.shouldBoostAggregatingFunction(id).allowsAccess();
            return this.createGenericAggregator(overrideAccessMode, mode, id, context);
        }

        @Override
        RawIterator<AnyValue[], ProcedureException> doCallProcedure(Context ctx, int id, AnyValue[] input) throws ProcedureException {
            return this.procedureView.callProcedure(ctx, id, input, this.ktx.resourceMonitor());
        }

        @Override
        SecurityContext securityContext() {
            return this.ktx.securityContext();
        }

        @Override
        OverridableSecurityContext.Revertable overrideSecurityContext(SecurityContext context) {
            KernelTransaction.Revertable revertable = this.ktx.overrideWith(context);
            return () -> ((KernelTransaction.Revertable)revertable).close();
        }

        @Override
        KernelTransaction kernelTransaction() {
            return this.ktx;
        }

        @Override
        Supplier<GraphDatabaseAPI> graphDatabaseAPISupplier() {
            return () -> (GraphDatabaseAPI)this.databaseDependencies.resolveDependency(GraphDatabaseAPI.class);
        }
    }
}

