/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogIndexEncoding;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedLogTailScanner {
    static final long NO_TRANSACTION_ID = -1L;
    public static final byte NO_ENTRY = 0;
    private static final String TRANSACTION_LOG_NAME = "Transaction";
    private static final String CHECKPOINT_LOG_NAME = "Checkpoint";
    private final LogFiles logFiles;
    private final CommandReaderFactory commandReaderFactory;
    private final LogTailScannerMonitor monitor;
    private final MemoryTracker memoryTracker;
    private final CheckpointFile checkpointFile;
    private final boolean failOnCorruptedLogFiles;
    private final FileSystemAbstraction fileSystem;
    private final KernelVersionProvider fallbackKernelVersionProvider;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private LogTailMetadata logTail;

    public DetachedLogTailScanner(LogFiles logFiles, TransactionLogFilesContext context, CheckpointFile checkpointFile, LogTailScannerMonitor monitor) {
        this.logFiles = logFiles;
        this.commandReaderFactory = context.getCommandReaderFactory();
        this.memoryTracker = context.getMemoryTracker();
        this.checkpointFile = checkpointFile;
        this.fileSystem = context.getFileSystem();
        this.failOnCorruptedLogFiles = context.isFailOnCorruptedLogFiles();
        this.fallbackKernelVersionProvider = context.getKernelVersionProvider();
        this.logTail = context.getExternalTailInfo();
        this.monitor = monitor;
        this.binarySupportedKernelVersions = context.getBinarySupportedKernelVersions();
    }

    public LogTailInformation findLogTail() {
        LogFile logFile = this.logFiles.getLogFile();
        long highestLogVersion = logFile.getHighestLogVersion();
        long lowestLogVersion = logFile.getLowestLogVersion();
        try {
            Optional<CheckpointInfo> lastAccessibleCheckpoint = this.checkpointFile.findLatestCheckpoint();
            if (lastAccessibleCheckpoint.isEmpty()) {
                return this.noCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion);
            }
            CheckpointInfo checkpoint = lastAccessibleCheckpoint.get();
            this.verifyKernelVersion(checkpoint.kernelVersionByte());
            this.verifyCheckpointPosition(checkpoint.channelPositionAfterCheckpoint());
            if (this.isValidCheckpoint(logFile, checkpoint)) {
                return this.validCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion, checkpoint);
            }
            if (this.failOnCorruptedLogFiles) {
                String exceptionMessage = String.format("Last available %s checkpoint does not point to a valid location in transaction logs.", checkpoint);
                DetachedLogTailScanner.throwUnableToCleanRecover(new RuntimeException(exceptionMessage));
            }
            List<CheckpointInfo> checkpointInfos = this.checkpointFile.reachableCheckpoints();
            ListIterator<CheckpointInfo> reverseCheckpoints = checkpointInfos.listIterator(checkpointInfos.size() - 1);
            while (reverseCheckpoints.hasPrevious()) {
                CheckpointInfo previousCheckpoint = reverseCheckpoints.previous();
                if (!this.isValidCheckpoint(logFile, previousCheckpoint)) continue;
                return this.validCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion, previousCheckpoint);
            }
            return this.noCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void verifyKernelVersion(byte kernelVersionByte) {
        KernelVersion kernelVersion;
        try {
            kernelVersion = KernelVersion.getForVersion((byte)kernelVersionByte);
        }
        catch (IllegalArgumentException e) {
            throw UnsupportedLogVersionException.unsupported((BinarySupportedKernelVersions)this.binarySupportedKernelVersions, (byte)kernelVersionByte);
        }
        if (!this.binarySupportedKernelVersions.latestSupportedIsAtLeast(kernelVersion)) {
            throw UnsupportedLogVersionException.unsupported((BinarySupportedKernelVersions)this.binarySupportedKernelVersions, (byte)kernelVersionByte);
        }
    }

    private LogTailInformation validCheckpointLogTail(LogFile logFile, long highestLogVersion, long lowestLogVersion, CheckpointInfo checkpoint) throws IOException {
        StartCommitEntries entries = this.getFirstTransactionIdAfterCheckpoint(logFile, checkpoint.transactionLogPosition());
        return new LogTailInformation(this.loadConsensusIndexIfNeeded(logFile, checkpoint), entries.isPresent(), entries.getTransactionId(), lowestLogVersion == -1L, highestLogVersion, entries.getEntryVersion(), checkpoint.storeId(), this.fallbackKernelVersionProvider);
    }

    private LogTailInformation noCheckpointLogTail(LogFile logFile, long highestLogVersion, long lowestLogVersion) throws IOException {
        StartCommitEntries entries = this.getFirstTransactionId(logFile, lowestLogVersion);
        return new LogTailInformation(entries.isPresent(), entries.getTransactionId(), lowestLogVersion == -1L, highestLogVersion, entries.getEntryVersion(), this.fallbackKernelVersionProvider);
    }

    private StartCommitEntries getFirstTransactionId(LogFile logFile, long lowestLogVersion) throws IOException {
        LogHeader logHeader;
        LogPosition logPosition = LogPosition.UNSPECIFIED;
        if (logFile.versionExists(lowestLogVersion) && (logHeader = logFile.extractHeader(lowestLogVersion)) != null) {
            logPosition = logHeader.getStartPosition();
        }
        return this.getFirstTransactionIdAfterCheckpoint(logFile, logPosition);
    }

    private boolean isValidCheckpoint(LogFile logFile, CheckpointInfo checkpointInfo) throws IOException {
        LogPosition logPosition = checkpointInfo.transactionLogPosition();
        long logVersion = logPosition.getLogVersion();
        if (!logFile.versionExists(logVersion)) {
            return false;
        }
        Path logFileForVersion = logFile.getLogFileForVersion(logVersion);
        if (this.fileSystem.getFileSize(logFileForVersion) < logPosition.getByteOffset()) {
            return false;
        }
        LogHeader logHeader = logFile.extractHeader(logVersion);
        if (logHeader == null) {
            return false;
        }
        StoreId headerStoreId = logHeader.getStoreId();
        return headerStoreId == null || headerStoreId.isSameOrUpgradeSuccessor(checkpointInfo.storeId()) || checkpointInfo.storeId().isSameOrUpgradeSuccessor(headerStoreId);
    }

    private StartCommitEntries getFirstTransactionIdAfterCheckpoint(LogFile logFile, LogPosition logPosition) throws IOException {
        boolean corruptedTransactionLogs = false;
        LogEntryStart start = null;
        LogEntryCommit commit = null;
        LogEntryChunkEnd chunkEnd = null;
        LogPosition lookupPosition = null;
        if (logPosition != LogPosition.UNSPECIFIED) {
            long logVersion = logPosition.getLogVersion();
            try {
                while (logFile.versionExists(logVersion)) {
                    lookupPosition = lookupPosition == null ? logPosition : logFile.extractHeader(logVersion).getStartPosition();
                    VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions);
                    try (ReadableLogChannel reader = logFile.getReader(lookupPosition, LogVersionBridge.NO_MORE_CHANNELS);
                         LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableLogPositionAwareChannel)reader);){
                        while ((start == null || commit == null) && cursor.next()) {
                            LogEntryStart e;
                            LogEntry entry = cursor.get();
                            if (commit == null && entry instanceof LogEntryCommit) {
                                LogEntryCommit e2;
                                commit = e2 = (LogEntryCommit)entry;
                                continue;
                            }
                            if (chunkEnd == null && entry instanceof LogEntryChunkEnd) {
                                LogEntryChunkEnd e3;
                                chunkEnd = e3 = (LogEntryChunkEnd)entry;
                                continue;
                            }
                            if (start != null || !(entry instanceof LogEntryStart)) continue;
                            start = e = (LogEntryStart)entry;
                        }
                    }
                    if (start != null && (commit != null || chunkEnd != null)) {
                        return new StartCommitEntries(start, commit, chunkEnd);
                    }
                    this.verifyReaderPosition(logVersion, logEntryReader.lastPosition());
                    ++logVersion;
                }
            }
            catch (Error | ClosedByInterruptException e) {
                throw e;
            }
            catch (Throwable t) {
                this.monitor.corruptedLogFile(logVersion, t);
                if (this.failOnCorruptedLogFiles) {
                    DetachedLogTailScanner.throwUnableToCleanRecover(t);
                }
                corruptedTransactionLogs = true;
            }
        }
        return new StartCommitEntries(start, commit, chunkEnd, corruptedTransactionLogs);
    }

    private CheckpointInfo loadConsensusIndexIfNeeded(LogFile logFile, CheckpointInfo checkpoint) throws IOException {
        if (checkpoint.consensusIndexInCheckpoint()) {
            return checkpoint;
        }
        long requiredTransactionId = checkpoint.transactionId().transactionId();
        long consensusIndex = this.findConsensusIndexForTransactionId(logFile, requiredTransactionId, checkpoint.transactionLogPosition());
        if (consensusIndex == -1L) {
            return checkpoint;
        }
        return new CheckpointInfo(checkpoint.transactionLogPosition(), checkpoint.storeId(), checkpoint.checkpointEntryPosition(), checkpoint.channelPositionAfterCheckpoint(), checkpoint.checkpointFilePostReadPosition(), checkpoint.kernelVersion(), checkpoint.kernelVersionByte(), new TransactionId(checkpoint.transactionId().transactionId(), checkpoint.transactionId().checksum(), checkpoint.transactionId().commitTimestamp(), consensusIndex), checkpoint.reason());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long findConsensusIndexForTransactionId(LogFile logFile, long requiredTransactionId, LogPosition checkpointTransactionPosition) throws IOException {
        long logVersion = checkpointTransactionPosition.getLogVersion();
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions);
        try {
            while (logFile.versionExists(logVersion)) {
                LogPosition logHeaderStart;
                LogHeader logHeader = logFile.extractHeader(logVersion);
                if (logHeader != null && (logHeaderStart = logHeader.getStartPosition()).compareTo(checkpointTransactionPosition) < 0) {
                    try (ReadableLogChannel reader = logFile.getReader(logHeaderStart, LogVersionBridge.NO_MORE_CHANNELS);
                         LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableLogPositionAwareChannel)reader);){
                        LogEntryStart start = null;
                        while (cursor.next()) {
                            LogEntry entry = cursor.get();
                            if (entry instanceof LogEntryStart) {
                                LogEntryStart e;
                                start = e = (LogEntryStart)entry;
                                continue;
                            }
                            if (!(entry instanceof LogEntryCommit)) continue;
                            LogEntryCommit commit = (LogEntryCommit)entry;
                            if (start != null && commit.getTxId() == requiredTransactionId) {
                                long l = LogIndexEncoding.decodeLogIndex(start.getAdditionalHeader());
                                return l;
                            }
                            start = null;
                        }
                    }
                }
                --logVersion;
            }
            return -1L;
        }
        catch (Error | ClosedByInterruptException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    private void verifyReaderPosition(long version, LogPosition logPosition) throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        long highestLogVersion = logFile.getHighestLogVersion();
        try (PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(version);){
            this.verifyLogChannel(channel, logPosition, version, highestLogVersion, true, TRANSACTION_LOG_NAME);
        }
    }

    private void verifyCheckpointPosition(LogPosition lastCheckpointPosition) throws IOException {
        long checkpointLogVersion = lastCheckpointPosition.getLogVersion();
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        long highestLogVersion = checkpointFile.getHighestLogVersion();
        try (PhysicalLogVersionedStoreChannel channel = checkpointFile.openForVersion(checkpointLogVersion);){
            channel.position(lastCheckpointPosition.getByteOffset());
            if (this.failOnCorruptedLogFiles) {
                this.verifyLogChannel(channel, lastCheckpointPosition, checkpointLogVersion, highestLogVersion, false, CHECKPOINT_LOG_NAME);
            }
        }
    }

    private void verifyLogChannel(PhysicalLogVersionedStoreChannel channel, LogPosition logPosition, long currentVersion, long highestVersion, boolean checkLastFile, String logName) throws IOException {
        this.verifyLogVersion(currentVersion, logPosition);
        long logFileSize = channel.size();
        long channelLeftovers = Math.subtractExact(logFileSize, logPosition.getByteOffset());
        if (channelLeftovers != 0L) {
            if (checkLastFile) {
                DetachedLogTailScanner.verifyLastFile(highestVersion, currentVersion, logPosition, logFileSize, channelLeftovers, logName);
            }
            this.verifyNoMoreReadableDataAvailable(currentVersion, channel, logPosition, channelLeftovers, logName);
        }
    }

    private void verifyLogVersion(long version, LogPosition logPosition) {
        if (logPosition.getLogVersion() != version) {
            throw new IllegalStateException(String.format("Expected to observe log positions only for log file with version %d but encountered version %d while reading %s.", version, logPosition.getLogVersion(), FileUtils.getCanonicalFile((Path)this.logFiles.getLogFile().getLogFileForVersion(version))));
        }
    }

    static void throwUnableToCleanRecover(Throwable t) {
        throw new RuntimeException("Error reading transaction logs, recovery not possible. To force the database to start anyway, you can specify '" + GraphDatabaseInternalSettings.fail_on_corrupted_log_files.name() + "=false'. This will try to recover as much as possible and then truncate the corrupt part of the transaction log. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", t);
    }

    private static void verifyLastFile(long highestLogVersion, long version, LogPosition logPosition, long logFileSize, long channelLeftovers, String logName) {
        if (version != highestLogVersion) {
            throw new RuntimeException(String.format("%s log files with version %d has %d unreadable bytes. Was able to read upto %d but %d is available.", logName, version, channelLeftovers, logPosition.getByteOffset(), logFileSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNoMoreReadableDataAvailable(long version, LogVersionedStoreChannel channel, LogPosition logPosition, long channelLeftovers, String logName) throws IOException {
        long initialPosition = channel.position();
        try {
            channel.position(logPosition.getByteOffset());
            try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(Numbers.safeCastLongToInt((long)Math.min(ByteUnit.kibiBytes((long)12L), channelLeftovers)), ByteOrder.LITTLE_ENDIAN, this.memoryTracker);){
                ByteBuffer byteBuffer = scopedBuffer.getBuffer();
                channel.readAll(byteBuffer);
                byteBuffer.flip();
                if (!DetachedLogTailScanner.isAllZerosBuffer(byteBuffer)) {
                    throw new RuntimeException(String.format("%s log file with version %d has some data available after last readable log entry. Last readable position %d, read ahead buffer content: %s.", logName, version, logPosition.getByteOffset(), DetachedLogTailScanner.dumpBufferToString(byteBuffer)));
                }
            }
        }
        finally {
            channel.position(initialPosition);
        }
    }

    public LogTailMetadata getTailMetadata() {
        if (this.logTail == null) {
            this.logTail = this.findLogTail();
        }
        return this.logTail;
    }

    private static String dumpBufferToString(ByteBuffer byteBuffer) {
        byte[] data = new byte[byteBuffer.limit()];
        byteBuffer.get(data);
        return Arrays.toString(data);
    }

    private static boolean isAllZerosBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] array;
            for (byte b : array = byteBuffer.array()) {
                if (b == 0) continue;
                return false;
            }
        } else {
            while (byteBuffer.hasRemaining()) {
                if (byteBuffer.get() == 0) continue;
                return false;
            }
        }
        return true;
    }

    private static class StartCommitEntries {
        private final LogEntryStart start;
        private final LogEntryCommit commit;
        private final LogEntryChunkEnd chunkEnd;
        private final boolean corruptedLogs;

        StartCommitEntries(LogEntryStart start, LogEntryCommit commit, LogEntryChunkEnd chunkEnd) {
            this(start, commit, chunkEnd, false);
        }

        StartCommitEntries(LogEntryStart start, LogEntryCommit commit, LogEntryChunkEnd chunkEnd, boolean corruptedLogs) {
            this.start = start;
            this.commit = commit;
            this.chunkEnd = chunkEnd;
            this.corruptedLogs = corruptedLogs;
        }

        public long getTransactionId() {
            if (this.commit != null) {
                return this.commit.getTxId();
            }
            if (this.chunkEnd != null) {
                return this.chunkEnd.getTransactionId();
            }
            return -1L;
        }

        public boolean isPresent() {
            return this.start != null || this.corruptedLogs;
        }

        public byte getEntryVersion() {
            if (this.start != null) {
                return this.start.kernelVersion().version();
            }
            return 0;
        }
    }
}

