/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContext;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.storemigration.LogsMigrator;
import org.neo4j.kernel.impl.storemigration.MigrationStatus;
import org.neo4j.kernel.impl.storemigration.StorageEngineMigrationAbstraction;
import org.neo4j.kernel.impl.storemigration.UnableToMigrateException;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitorFactory;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.MigrationStoreVersionCheck;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;

public class StoreMigrator {
    private static final String STORE_UPGRADE_TAG = "storeMigrate";
    public static final String MIGRATION_DIRECTORY = "migrate";
    private static final String MIGRATION_STATUS_FILE = "_status";
    private final CursorContextFactory contextFactory;
    private final DatabaseTracers databaseTracers;
    private final DatabaseLayout databaseLayout;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final PageCache pageCache;
    private final LogService logService;
    private final JobScheduler jobScheduler;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;
    private final IndexProviderMap indexProviderMap;
    private final StorageEngineFactory storageEngineFactory;
    private final InternalLog internalLog;
    private Supplier<LogTailMetadata> logTailSupplier;
    private final StorageEngineMigrationAbstraction storageEngineMigrationAbstraction;

    public StoreMigrator(FileSystemAbstraction fs, Config config, LogService logService, PageCache pageCache, DatabaseTracers databaseTracers, JobScheduler jobScheduler, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, StorageEngineFactory targetStorageEngineFactory, IndexProviderMap indexProviderMap, MemoryTracker memoryTracker, Supplier<LogTailMetadata> logTailSupplier) {
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.pageCache = pageCache;
        this.databaseLayout = databaseLayout;
        this.storageEngineFactory = storageEngineFactory;
        this.jobScheduler = jobScheduler;
        this.databaseTracers = databaseTracers;
        this.pageCacheTracer = databaseTracers.getPageCacheTracer();
        this.memoryTracker = memoryTracker;
        this.indexProviderMap = indexProviderMap;
        this.internalLog = logService.getInternalLog(this.getClass());
        this.logTailSupplier = logTailSupplier;
        this.contextFactory = new CursorContextFactory(databaseTracers.getPageCacheTracer(), (VersionContextSupplier)new LazyVersionContextSupplier());
        this.storageEngineMigrationAbstraction = new StorageEngineMigrationAbstraction(storageEngineFactory, targetStorageEngineFactory);
    }

    public void migrateIfNeeded(String formatToMigrateTo, boolean forceBtreeIndexesToRange) throws UnableToMigrateException, IOException {
        this.checkStoreExists();
        try (CursorContext cursorContext = this.contextFactory.create(STORE_UPGRADE_TAG);){
            MigrationStructures migrationStructures = this.getMigrationStructures();
            this.finishInterruptedMigration(migrationStructures);
            CheckResult checkResult = this.doMigrationCheck(formatToMigrateTo, cursorContext);
            this.internalLog.info("'" + checkResult.versionToMigrateFrom().getStoreVersionUserString() + "' has been identified as the current version of the store");
            this.internalLog.info("'" + checkResult.versionToMigrateTo().getStoreVersionUserString() + "' has been identified as the target version of the store migration");
            if (checkResult.onRequestedVersion()) {
                LogsMigrator logsMigrator = new LogsMigrator(this.fs, this.storageEngineFactory, this.databaseLayout, this.pageCache, this.config, this.contextFactory, this.logTailSupplier, this.pageCacheTracer);
                if (this.logTailSupplier.get().kernelVersion().isLessThan(KernelVersion.getLatestVersion((Config)this.config))) {
                    LogsMigrator.CheckResult logsCheckResult = logsMigrator.assertCleanlyShutDown();
                    this.doOnlyLogsMigration(logsCheckResult, checkResult.versionToMigrateTo);
                } else {
                    this.internalLog.info("The current store version and the migration target version are the same, so there is nothing to do.");
                }
                return;
            }
            this.doMigrate(migrationStructures, MigrationStatus.MigrationState.migrating, checkResult.versionToMigrateFrom(), checkResult.versionToMigrateTo(), VisibleMigrationProgressMonitorFactory.forMigration(this.internalLog), LogsMigrator.CheckResult::migrate, forceBtreeIndexesToRange, this.storageEngineMigrationAbstraction);
        }
    }

    private void doOnlyLogsMigration(LogsMigrator.CheckResult logsCheckResult, StoreVersionIdentifier versionToMigrateTo) {
        this.internalLog.info("'" + this.logTailSupplier.get().kernelVersion() + "' has been identified as the current kernel version of the store.");
        this.internalLog.info("'" + KernelVersion.getLatestVersion((Config)this.config) + "' has been identified as the target kernel version of the store migration.");
        StoreVersion toVersion = (StoreVersion)this.storageEngineFactory.versionInformation(versionToMigrateTo).orElseThrow();
        MigrationProgressMonitor progressMonitor = VisibleMigrationProgressMonitorFactory.forMigration(this.internalLog);
        progressMonitor.started(0);
        progressMonitor.startTransactionLogsMigration();
        LogsMigrator.MigrationTransactionIds txIds = logsCheckResult.migrate();
        progressMonitor.completeTransactionLogsMigration();
        List<StoreMigrationParticipant> participants = this.getStoreMigrationParticipants(this.storageEngineMigrationAbstraction, false);
        this.postMigration(participants, toVersion, txIds.txIdBeforeMigration(), txIds.txIdAfterMigration());
        progressMonitor.completed();
    }

    public void upgradeIfNeeded() throws UnableToMigrateException, IOException {
        if (!this.storageEngineFactory.storageExists(this.fs, this.databaseLayout)) {
            return;
        }
        try (CursorContext cursorContext = this.contextFactory.create(STORE_UPGRADE_TAG);){
            MigrationStructures migrationStructures = this.getMigrationStructures();
            this.finishInterruptedUpgrade(cursorContext, migrationStructures);
            CheckResult checkResult = this.doUpgradeCheck(cursorContext);
            if (checkResult.onRequestedVersion()) {
                return;
            }
            this.internalLog.info("'" + checkResult.versionToMigrateFrom().getStoreVersionUserString() + "' has been identified as the current version of the store");
            this.internalLog.info("'" + checkResult.versionToMigrateTo().getStoreVersionUserString() + "' has been identified as the target version of the store upgrade");
            this.doMigrate(migrationStructures, MigrationStatus.MigrationState.migrating, checkResult.versionToMigrateFrom(), checkResult.versionToMigrateTo(), VisibleMigrationProgressMonitorFactory.forUpgrade(this.internalLog), LogsMigrator.CheckResult::upgrade, false, this.storageEngineMigrationAbstraction);
        }
    }

    private MigrationStructures getMigrationStructures() {
        DatabaseLayout migrationStructure = DatabaseLayout.ofFlat((Path)this.databaseLayout.file(MIGRATION_DIRECTORY));
        return new MigrationStructures(migrationStructure, migrationStructure.file(MIGRATION_STATUS_FILE));
    }

    private void doMigrate(MigrationStructures migrationStructures, MigrationStatus.MigrationState migrationState, StoreVersionIdentifier versionToMigrateFrom, StoreVersionIdentifier versionToMigrateTo, MigrationProgressMonitor progressMonitor, LogsAction logsAction, boolean forceBtreeIndexesToRange, StorageEngineMigrationAbstraction storageEngineMigrationAbstraction) throws IOException {
        List<StoreMigrationParticipant> participants = this.getStoreMigrationParticipants(storageEngineMigrationAbstraction, forceBtreeIndexesToRange);
        progressMonitor.started(participants.size());
        LogsMigrator logsMigrator = new LogsMigrator(this.fs, storageEngineMigrationAbstraction.getTargetStorageEngineFactory(), this.databaseLayout, this.pageCache, this.config, this.contextFactory, this.logTailSupplier, this.pageCacheTracer);
        LogsMigrator.CheckResult logsCheckResult = logsMigrator.assertCleanlyShutDown();
        StoreVersion fromVersion = (StoreVersion)storageEngineMigrationAbstraction.getStorageEngineFactory().versionInformation(versionToMigrateFrom).orElseThrow();
        StoreVersion toVersion = (StoreVersion)storageEngineMigrationAbstraction.getTargetStorageEngineFactory().versionInformation(versionToMigrateTo).orElseThrow();
        if (MigrationStatus.MigrationState.migrating.isNeededFor(migrationState)) {
            this.cleanMigrationDirectory(migrationStructures.migrationLayout.databaseDirectory());
            MigrationStatus.MigrationState.migrating.setMigrationStatus(this.fs, migrationStructures.migrationStateFile, versionToMigrateFrom, versionToMigrateTo, this.memoryTracker);
            this.migrateToIsolatedDirectory(participants, this.databaseLayout, migrationStructures.migrationLayout, fromVersion, toVersion, progressMonitor);
            MigrationStatus.MigrationState.moving.setMigrationStatus(this.fs, migrationStructures.migrationStateFile, versionToMigrateFrom, versionToMigrateTo, this.memoryTracker);
        }
        if (MigrationStatus.MigrationState.moving.isNeededFor(migrationState)) {
            StoreMigrator.moveMigratedFilesToStoreDirectory(participants, migrationStructures.migrationLayout, this.databaseLayout, fromVersion, toVersion);
        }
        progressMonitor.startTransactionLogsMigration();
        LogsMigrator.MigrationTransactionIds txIds = logsAction.handleLogs(logsCheckResult);
        progressMonitor.completeTransactionLogsMigration();
        this.postMigration(participants, toVersion, txIds.txIdBeforeMigration(), txIds.txIdAfterMigration());
        this.cleanup(participants, migrationStructures.migrationLayout);
        progressMonitor.completed();
    }

    private CheckResult doMigrationCheck(String formatToMigrateTo, CursorContext cursorContext) {
        MigrationStoreVersionCheck storeVersionCheck = this.storageEngineMigrationAbstraction.getStoreVersionCheck(this.fs, this.pageCache, this.databaseLayout, this.config, this.logService, this.contextFactory);
        MigrationStoreVersionCheck.MigrationCheckResult checkResult = storeVersionCheck.getAndCheckMigrationTargetVersion(formatToMigrateTo, cursorContext);
        StoreVersionIdentifier fromVersion = checkResult.versionToMigrateFrom();
        StoreVersionIdentifier toVersion = checkResult.versionToMigrateTo();
        return switch (checkResult.outcome()) {
            default -> throw new IncompatibleClassChangeError();
            case MigrationStoreVersionCheck.MigrationOutcome.MIGRATION_POSSIBLE -> new CheckResult(false, fromVersion, toVersion);
            case MigrationStoreVersionCheck.MigrationOutcome.NO_OP -> new CheckResult(true, fromVersion, toVersion);
            case MigrationStoreVersionCheck.MigrationOutcome.STORE_VERSION_RETRIEVAL_FAILURE -> throw new UnableToMigrateException("Failed to read current store version. This usually indicate a store corruption", checkResult.cause());
            case MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_MIGRATION_PATH -> throw new UnableToMigrateException(String.format("Store migration from '%s' to '%s' not supported", fromVersion.getStoreVersionUserString(), toVersion != null ? toVersion.getStoreVersionUserString() : formatToMigrateTo));
            case MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_TARGET_VERSION -> throw new UnableToMigrateException("The current store version is not supported. Please migrate the store to be able to continue");
        };
    }

    private CheckResult doUpgradeCheck(CursorContext cursorContext) {
        StoreVersionCheck storeVersionCheck = this.storageEngineFactory.versionCheck(this.fs, this.databaseLayout, this.config, this.pageCache, this.logService, this.contextFactory);
        StoreVersionCheck.UpgradeCheckResult checkResult = storeVersionCheck.getAndCheckUpgradeTargetVersion(cursorContext);
        return switch (checkResult.outcome()) {
            default -> throw new IncompatibleClassChangeError();
            case StoreVersionCheck.UpgradeOutcome.UPGRADE_POSSIBLE -> new CheckResult(false, checkResult.versionToUpgradeFrom(), checkResult.versionToUpgradeTo());
            case StoreVersionCheck.UpgradeOutcome.NO_OP -> new CheckResult(true, checkResult.versionToUpgradeFrom(), checkResult.versionToUpgradeTo());
            case StoreVersionCheck.UpgradeOutcome.STORE_VERSION_RETRIEVAL_FAILURE -> throw new IllegalStateException("Failed to read current store version.", checkResult.cause());
            case StoreVersionCheck.UpgradeOutcome.UNSUPPORTED_TARGET_VERSION -> throw new UnableToMigrateException(String.format("The selected target store format '%s' (introduced in %s) is no longer supported", checkResult.versionToUpgradeTo().getStoreVersionUserString(), storeVersionCheck.getIntroductionVersionFromVersion(checkResult.versionToUpgradeTo())));
        };
    }

    private void finishInterruptedMigration(MigrationStructures migrationStructures) throws IOException {
        MigrationStatus migrationStatus = MigrationStatus.readMigrationStatus(this.fs, migrationStructures.migrationStateFile, this.memoryTracker);
        if (migrationStatus.migrationInProgress()) {
            MigrationStatus.MigrationState state = migrationStatus.state();
            if (state == MigrationStatus.MigrationState.moving) {
                this.internalLog.info("Resuming migration in progress to '" + migrationStatus.versionToMigrateTo().getStoreVersionUserString() + "'");
                StoreVersionIdentifier versionToMigrateTo = migrationStatus.versionToMigrateTo();
                Config localConfig = Config.newBuilder().fromConfig(this.config).set(GraphDatabaseSettings.db_format, (Object)versionToMigrateTo.getFormatName()).build();
                StorageEngineFactory targetStorageEngineFactory = StorageEngineFactory.selectStorageEngine((Configuration)localConfig);
                StorageEngineMigrationAbstraction storageEngineMigrationAbstraction = new StorageEngineMigrationAbstraction(this.storageEngineFactory, targetStorageEngineFactory);
                this.doMigrate(migrationStructures, MigrationStatus.MigrationState.moving, migrationStatus.versionToMigrateFrom(), versionToMigrateTo, VisibleMigrationProgressMonitorFactory.forMigration(this.internalLog), LogsMigrator.CheckResult::migrate, false, storageEngineMigrationAbstraction);
                this.logTailSupplier = this.getLogTailSupplier(targetStorageEngineFactory);
            } else {
                this.removeOldMigrationDir(migrationStructures.migrationLayout.databaseDirectory());
            }
        }
    }

    private void finishInterruptedUpgrade(CursorContext cursorContext, MigrationStructures migrationStructures) throws IOException {
        MigrationStatus migrationStatus = MigrationStatus.readMigrationStatus(this.fs, migrationStructures.migrationStateFile, this.memoryTracker);
        if (migrationStatus.migrationInProgress()) {
            MigrationStatus.MigrationState state = migrationStatus.state();
            if (state == MigrationStatus.MigrationState.moving) {
                CheckResult checkResult = this.doUpgradeCheck(cursorContext);
                if (!migrationStatus.expectedMigration(checkResult.versionToMigrateTo)) {
                    throw new UnableToMigrateException("A partially complete migration to " + migrationStatus.versionToMigrateTo().getStoreVersionUserString() + " found when trying to migrate to " + checkResult.versionToMigrateTo.getStoreVersionUserString() + ". Complete that migration before continuing. This can be done by running the migration tool");
                }
                this.internalLog.info("Resuming upgrade in progress to '" + checkResult.versionToMigrateTo + "'");
                this.doMigrate(migrationStructures, MigrationStatus.MigrationState.moving, migrationStatus.versionToMigrateFrom(), migrationStatus.versionToMigrateTo(), VisibleMigrationProgressMonitorFactory.forUpgrade(this.internalLog), LogsMigrator.CheckResult::upgrade, false, this.storageEngineMigrationAbstraction);
                this.logTailSupplier = this.getLogTailSupplier(this.storageEngineFactory);
            } else {
                this.removeOldMigrationDir(migrationStructures.migrationLayout.databaseDirectory());
            }
        }
    }

    private List<StoreMigrationParticipant> getStoreMigrationParticipants(StorageEngineMigrationAbstraction storageEngineMigrationAbstraction, boolean forceBtreeIndexesToRange) {
        return storageEngineMigrationAbstraction.getMigrationParticipants(forceBtreeIndexesToRange, this.fs, this.pageCache, this.pageCacheTracer, this.config, this.logService, this.jobScheduler, this.contextFactory, this.memoryTracker, this.indexProviderMap);
    }

    private void migrateToIsolatedDirectory(List<StoreMigrationParticipant> participants, DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, StoreVersion fromVersion, StoreVersion toVersion, MigrationProgressMonitor progressMonitor) {
        try {
            for (StoreMigrationParticipant participant : participants) {
                ProgressReporter progressReporter = progressMonitor.startSection(participant.getName());
                IndexImporterFactoryImpl indexImporterFactory = new IndexImporterFactoryImpl();
                participant.migrate(directoryLayout, migrationLayout, progressReporter, fromVersion, toVersion, (IndexImporterFactory)indexImporterFactory, this.logTailSupplier.get());
                progressReporter.completed();
            }
        }
        catch (IOException | UncheckedIOException | KernelException e) {
            throw new UnableToMigrateException("A critical failure during migration has occurred", e);
        }
    }

    private static void moveMigratedFilesToStoreDirectory(Iterable<StoreMigrationParticipant> participants, DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, StoreVersion versionToMigrateFrom, StoreVersion versionToMigrateTo) {
        try {
            for (StoreMigrationParticipant participant : participants) {
                participant.moveMigratedFiles(migrationLayout, directoryLayout, versionToMigrateFrom, versionToMigrateTo);
            }
        }
        catch (IOException e) {
            throw new UnableToMigrateException("A critical failure during migration has occurred. Failed to move migrated files into place", e);
        }
    }

    private void checkStoreExists() {
        if (!this.storageEngineFactory.storageExists(this.fs, this.databaseLayout)) {
            throw new UnableToMigrateException("Database '" + this.databaseLayout.getDatabaseName() + "' either does not exists or it has not been initialised");
        }
    }

    private void postMigration(Iterable<StoreMigrationParticipant> participants, StoreVersion toVersion, long txIdBeforeMigration, long txIdAfterMigration) {
        try {
            for (StoreMigrationParticipant participant : participants) {
                participant.postMigration(this.databaseLayout, toVersion, txIdBeforeMigration, txIdAfterMigration);
            }
        }
        catch (IOException e) {
            throw new UnableToMigrateException("A critical failure during migration has occurred. Unable to do post-migration step", e);
        }
    }

    private void cleanup(Iterable<StoreMigrationParticipant> participants, DatabaseLayout migrationStructure) {
        try {
            for (StoreMigrationParticipant participant : participants) {
                participant.cleanup(migrationStructure);
            }
        }
        catch (IOException e) {
            throw new UnableToMigrateException("A critical failure during store migration has occurred. Failed to clean up after migration", e);
        }
        this.removeOldMigrationDir(migrationStructure.databaseDirectory());
    }

    private void cleanMigrationDirectory(Path migrationDirectory) {
        this.removeOldMigrationDir(migrationDirectory);
        try {
            this.fs.mkdir(migrationDirectory);
        }
        catch (IOException e) {
            throw new UnableToMigrateException("A critical failure during migration has occurred. Failed to create a migration directory " + migrationDirectory, e);
        }
    }

    private void removeOldMigrationDir(Path migrationDirectory) {
        try {
            if (this.fs.fileExists(migrationDirectory)) {
                this.fs.deleteRecursively(migrationDirectory);
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new UnableToMigrateException("A critical failure during migration has occurred. Failed to delete a migration directory " + migrationDirectory, e);
        }
    }

    private Suppliers.Lazy<LogTailMetadata> getLogTailSupplier(StorageEngineFactory storageEngineFactory) {
        return Suppliers.lazySingleton(() -> {
            try {
                return new LogTailExtractor(this.fs, this.pageCache, this.config, storageEngineFactory, this.databaseTracers).getTailMetadata(this.databaseLayout, this.memoryTracker, () -> KernelVersion.getLatestVersion((Config)this.config));
            }
            catch (Exception e) {
                throw new UnableToMigrateException("Fail to load log tail during migration.", e);
            }
        });
    }

    private class LazyVersionContextSupplier
    extends FixedVersionContextSupplier {
        public LazyVersionContextSupplier() {
            super(0L);
        }

        public VersionContext createVersionContext() {
            return new LazyTailVersionContext(StoreMigrator.this.logTailSupplier);
        }
    }

    private record MigrationStructures(DatabaseLayout migrationLayout, Path migrationStateFile) {
    }

    private record CheckResult(boolean onRequestedVersion, StoreVersionIdentifier versionToMigrateFrom, StoreVersionIdentifier versionToMigrateTo) {
    }

    private static interface LogsAction {
        public LogsMigrator.MigrationTransactionIds handleLogs(LogsMigrator.CheckResult var1);
    }

    private static class LazyTailVersionContext
    extends FixedVersionContext {
        private final Supplier<LogTailMetadata> logTailSupplier;

        public LazyTailVersionContext(Supplier<LogTailMetadata> logTailSupplier) {
            super(0L);
            this.logTailSupplier = logTailSupplier;
        }

        public long committingTransactionId() {
            return this.logTailSupplier.get().getLastCommittedTransaction().transactionId();
        }
    }
}

