/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Clock;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.PhysicalFlushableChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.recovery.ParallelRecoveryVisitor;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryVisitor;
import org.neo4j.kernel.recovery.TransactionIdTracker;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;

public class DefaultRecoveryService
implements RecoveryService {
    private final RecoveryStartInformationProvider recoveryStartInformationProvider;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final LogVersionRepository logVersionRepository;
    private final LogFiles logFiles;
    private final KernelVersionProvider versionProvider;
    private final InternalLog log;
    private final Clock clock;
    private final boolean doParallelRecovery;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;

    DefaultRecoveryService(StorageEngine storageEngine, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, LogFiles logFiles, KernelVersionProvider versionProvider, RecoveryStartInformationProvider.Monitor monitor, InternalLog log, Clock clock, boolean doParallelRecovery, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this.storageEngine = storageEngine;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.logVersionRepository = logVersionRepository;
        this.logFiles = logFiles;
        this.versionProvider = versionProvider;
        this.log = log;
        this.clock = clock;
        this.doParallelRecovery = doParallelRecovery;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
        this.recoveryStartInformationProvider = new RecoveryStartInformationProvider(logFiles, monitor);
    }

    @Override
    public RecoveryStartInformation getRecoveryStartInformation() {
        return this.recoveryStartInformationProvider.get();
    }

    @Override
    public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag) {
        if (this.doParallelRecovery) {
            return new ParallelRecoveryVisitor(this.storageEngine, mode, contextFactory, tracerTag);
        }
        return new RecoveryVisitor(this.storageEngine, mode, contextFactory, tracerTag);
    }

    @Override
    public LogPosition rollbackTransactions(LogPosition writePosition, TransactionIdTracker transactionTracker, CommittedCommandBatch.BatchInformation lastCommittedBatch) throws IOException {
        long[] notCompletedTransactions = transactionTracker.notCompletedTransactions();
        if (notCompletedTransactions.length == 0) {
            return writePosition;
        }
        KernelVersion kernelVersion = this.versionProvider.kernelVersion();
        LogFile logFile = this.logFiles.getLogFile();
        PhysicalLogVersionedStoreChannel channel = logFile.createLogChannelForVersion(writePosition.getLogVersion(), lastCommittedBatch::txId);
        channel.position(writePosition.getByteOffset());
        try (HeapScopedBuffer tempRollbackBuffer = new HeapScopedBuffer(PhysicalFlushableChannel.DEFAULT_BUFFER_SIZE, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            LogPosition logPosition;
            try (PhysicalFlushableLogPositionAwareChannel writerChannel = new PhysicalFlushableLogPositionAwareChannel(channel, (ScopedBuffer)tempRollbackBuffer);){
                LogEntryWriter<PhysicalFlushableLogPositionAwareChannel> entryWriter = new LogEntryWriter<PhysicalFlushableLogPositionAwareChannel>(writerChannel, this.binarySupportedKernelVersions);
                long time = this.clock.millis();
                for (long notCompletedTransaction : notCompletedTransactions) {
                    entryWriter.writeRollbackEntry(kernelVersion, notCompletedTransaction, time);
                }
                logPosition = writerChannel.getCurrentLogPosition();
            }
            return logPosition;
        }
    }

    @Override
    public CommandBatchCursor getCommandBatches(long transactionId) throws IOException {
        return this.logicalTransactionStore.getCommandBatches(transactionId);
    }

    @Override
    public CommandBatchCursor getCommandBatches(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getCommandBatches(position);
    }

    @Override
    public CommandBatchCursor getCommandBatchesInReverseOrder(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getCommandBatchesInReverseOrder(position);
    }

    @Override
    public void transactionsRecovered(CommittedCommandBatch.BatchInformation lastRecoveredBatch, LogPosition lastRecoveredTransactionPosition, LogPosition positionAfterLastRecoveredTransaction, LogPosition checkpointPosition, boolean missingLogs, CursorContext cursorContext) {
        if (missingLogs) {
            ClosedTransactionMetadata lastClosedTransactionData = this.transactionIdStore.getLastClosedTransaction();
            long logVersion = lastClosedTransactionData.logPosition().getLogVersion();
            this.log.warn("Recovery detected that transaction logs were missing. Resetting offset of last closed transaction to point to the head of %d transaction log file.", new Object[]{logVersion});
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionData.transactionId(), logVersion, (long)LogFormat.CURRENT_FORMAT_LOG_HEADER_SIZE, lastClosedTransactionData.checksum(), lastClosedTransactionData.commitTimestamp(), lastClosedTransactionData.consensusIndex());
            this.logVersionRepository.setCurrentLogVersion(logVersion);
            this.tryRemoveLegacyCheckpointFiles();
            this.logVersionRepository.setCheckpointLogVersion(Math.max(0L, this.logFiles.getCheckpointFile().getHighestLogVersion()));
            return;
        }
        if (lastRecoveredBatch != null) {
            this.transactionIdStore.setLastCommittedAndClosedTransactionId(lastRecoveredBatch.txId(), lastRecoveredBatch.checksum(), lastRecoveredBatch.timeWritten(), lastRecoveredBatch.consensusIndex(), lastRecoveredTransactionPosition.getByteOffset(), lastRecoveredTransactionPosition.getLogVersion());
        } else {
            long lastClosedTransactionId = this.transactionIdStore.getLastClosedTransactionId();
            this.log.warn("Recovery detected that transaction logs tail can't be trusted. Resetting offset of last closed transaction to point to the last recoverable log position: " + positionAfterLastRecoveredTransaction);
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionId, positionAfterLastRecoveredTransaction.getLogVersion(), positionAfterLastRecoveredTransaction.getByteOffset(), -559063315, 0L, -1L);
        }
        this.logVersionRepository.setCurrentLogVersion(positionAfterLastRecoveredTransaction.getLogVersion());
        this.logVersionRepository.setCheckpointLogVersion(checkpointPosition.getLogVersion());
    }

    private void tryRemoveLegacyCheckpointFiles() {
        try {
            Path[] detachedCheckpointFiles;
            CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
            for (Path obsoleteCheckpointFile : detachedCheckpointFiles = checkpointFile.getDetachedCheckpointFiles()) {
                FileUtils.deleteFile((Path)obsoleteCheckpointFile);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to delete legacy checkpoint files.", (Throwable)e);
        }
    }
}

