/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.commit;

import java.util.Collections;
import java.util.List;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.TransactionRollbackException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.chunk.ChunkMetadata;
import org.neo4j.kernel.impl.api.chunk.ChunkedTransaction;
import org.neo4j.kernel.impl.api.chunk.CommandChunk;
import org.neo4j.kernel.impl.api.commit.TransactionCommitter;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.RollbackBatchEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidationResource;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;

public final class ChunkCommitter
implements TransactionCommitter {
    private final KernelTransactionImplementation ktx;
    private int chunkNumber = 1;
    private LogPosition previousBatchLogPosition = LogPosition.UNSPECIFIED;
    private KernelVersion kernelVersion;
    private ChunkedTransaction transactionPayload;
    private final TransactionCommitmentFactory commitmentFactory;
    private final KernelVersionProvider kernelVersionProvider;
    private final StoreCursors transactionalCursors;
    private final TransactionIdGenerator transactionIdGenerator;
    private final TransactionCommitProcess commitProcess;
    private final DatabaseHealth databaseHealth;
    private final TransactionClockContext clocks;
    private final StorageEngine storageEngine;
    private final LogicalTransactionStore transactionStore;
    private final TransactionValidator transactionValidator;
    private long lastTransactionIdWhenStarted;
    private long startTimeMillis;
    private LeaseClient leaseClient;

    public ChunkCommitter(KernelTransactionImplementation ktx, TransactionCommitmentFactory commitmentFactory, KernelVersionProvider kernelVersionProvider, StoreCursors transactionalCursors, TransactionIdGenerator transactionIdGenerator, TransactionCommitProcess commitProcess, DatabaseHealth databaseHealth, TransactionClockContext clocks, StorageEngine storageEngine, LogicalTransactionStore transactionStore, TransactionValidator transactionValidator) {
        this.ktx = ktx;
        this.commitmentFactory = commitmentFactory;
        this.kernelVersionProvider = kernelVersionProvider;
        this.transactionalCursors = transactionalCursors;
        this.transactionIdGenerator = transactionIdGenerator;
        this.commitProcess = commitProcess;
        this.databaseHealth = databaseHealth;
        this.clocks = clocks;
        this.storageEngine = storageEngine;
        this.transactionStore = transactionStore;
        this.transactionValidator = transactionValidator;
    }

    @Override
    public long commit(TransactionWriteEvent transactionWriteEvent, LeaseClient leaseClient, CursorContext cursorContext, MemoryTracker memoryTracker, KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor, LockTracer lockTracer, long commitTime, long startTimeMillis, long lastTransactionIdWhenStarted, boolean commit) throws KernelException {
        List<StorageCommand> extractedCommands = this.ktx.extractCommands(memoryTracker);
        if (!extractedCommands.isEmpty() || commit) {
            if (this.kernelVersion == null) {
                this.kernelVersion = this.kernelVersionProvider.kernelVersion();
                this.lastTransactionIdWhenStarted = lastTransactionIdWhenStarted;
                this.startTimeMillis = lastTransactionIdWhenStarted;
                this.leaseClient = leaseClient;
            }
            if (commit) {
                this.validateCurrentKernelVersion();
            }
            try (TransactionValidationResource validationResource = this.transactionValidator.validate(extractedCommands, this.ktx.getTransactionSequenceNumber(), cursorContext, leaseClient, lockTracer);){
                ChunkMetadata chunkMetadata = new ChunkMetadata(this.chunkNumber == 1, commit, false, this.previousBatchLogPosition, this.chunkNumber, -1L, startTimeMillis, lastTransactionIdWhenStarted, commitTime, leaseClient.leaseId(), this.kernelVersion, this.ktx.securityContext().subject().userSubject());
                if (this.transactionPayload == null) {
                    this.transactionPayload = new ChunkedTransaction(cursorContext, this.ktx.getTransactionSequenceNumber(), this.transactionalCursors, this.commitmentFactory.newCommitment(), this.transactionIdGenerator);
                }
                CommandChunk chunk = new CommandChunk(extractedCommands, chunkMetadata);
                this.transactionPayload.init(chunk);
                this.commitProcess.commit(this.transactionPayload, transactionWriteEvent, TransactionApplicationMode.INTERNAL);
                validationResource.chunkAppended(this.chunkNumber, this.transactionPayload.transactionId());
                transactionWriteEvent.chunkAppended(this.chunkNumber, this.ktx.getTransactionSequenceNumber(), this.transactionPayload.transactionId());
            }
            this.previousBatchLogPosition = this.transactionPayload.lastBatchLogPosition();
            ++this.chunkNumber;
        }
        return this.transactionPayload != null ? this.transactionPayload.transactionId() : 0L;
    }

    @Override
    public void rollback(TransactionRollbackEvent rollbackEvent) {
        if (this.transactionPayload != null) {
            try {
                this.validateCurrentKernelVersion();
                this.rollbackBatches(rollbackEvent);
                this.writeRollbackEntry(rollbackEvent);
            }
            catch (Exception e) {
                this.databaseHealth.panic((Throwable)e);
                Exceptions.throwIfInstanceOf((Throwable)e, TransactionRollbackException.class);
                throw new TransactionRollbackException("Transaction rollback failed", (Throwable)e);
            }
        }
    }

    private void writeRollbackEntry(TransactionRollbackEvent transactionRollbackEvent) throws TransactionFailureException {
        ChunkMetadata chunkMetadata = new ChunkMetadata(false, true, true, LogPosition.UNSPECIFIED, this.chunkNumber, -1L, this.startTimeMillis, this.lastTransactionIdWhenStarted, this.clocks.systemClock().millis(), this.leaseClient.leaseId(), this.kernelVersion, this.ktx.securityContext().subject().userSubject());
        CommandChunk chunk = new CommandChunk(Collections.emptyList(), chunkMetadata);
        this.transactionPayload.init(chunk);
        try (TransactionWriteEvent writeEvent = transactionRollbackEvent.beginRollbackWriteEvent();){
            this.commitProcess.commit(this.transactionPayload, writeEvent, TransactionApplicationMode.INTERNAL);
        }
    }

    private void validateCurrentKernelVersion() {
        if (this.kernelVersion != this.kernelVersionProvider.kernelVersion()) {
            throw new UnsupportedOperationException("We do not support upgrade during chunked transaction.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rollbackBatches(TransactionRollbackEvent transactionRollbackEvent) throws Exception {
        long transactionIdToRollback = this.transactionPayload.transactionId();
        int rolledbackBatches = 0;
        int chunksToRollback = this.chunkNumber - 1;
        LogPosition logPosition = this.transactionPayload.lastBatchLogPosition();
        try (RollbackBatchEvent rollbackDataEvent = transactionRollbackEvent.beginRollbackDataEvent();){
            while (rolledbackBatches != chunksToRollback) {
                CommandBatchCursor commandBatches = this.transactionStore.getCommandBatches(logPosition);
                try {
                    if (!commandBatches.next()) {
                        throw new TransactionRollbackException(String.format("Transaction rollback failed. Expected to rollback %d batches, but was able to undo only %d for transaction with id %d.", chunksToRollback, rolledbackBatches, transactionIdToRollback));
                    }
                    CommittedCommandBatch commandBatch = (CommittedCommandBatch)commandBatches.get();
                    if (commandBatch.txId() != transactionIdToRollback) {
                        throw new TransactionRollbackException(String.format("Transaction rollback failed. Batch with transaction id %d encountered, while it was expected to belong to transaction id %d. Batch id: %s.", commandBatch.txId(), transactionIdToRollback, this.chunkId(commandBatch)));
                    }
                    this.transactionPayload.init((CommandChunk)commandBatch.commandBatch());
                    this.storageEngine.apply((CommandBatchToApply)this.transactionPayload, TransactionApplicationMode.MVCC_ROLLBACK);
                    ++rolledbackBatches;
                    logPosition = commandBatch.previousBatchLogPosition();
                }
                finally {
                    if (commandBatches == null) continue;
                    commandBatches.close();
                }
            }
            if (logPosition != LogPosition.UNSPECIFIED) {
                throw new TransactionRollbackException(String.format("Transaction rollback failed. All expected %d batches in transaction id %d were rolled back but chain claims to have more at: %s.", chunksToRollback, transactionIdToRollback, logPosition));
            }
            rollbackDataEvent.batchedRolledBack(chunksToRollback, transactionIdToRollback);
            return;
        }
    }

    private String chunkId(CommittedCommandBatch commandBatch) {
        String string;
        CommandBatch commandBatch2 = commandBatch.commandBatch();
        if (commandBatch2 instanceof CommandChunk) {
            CommandChunk cc = (CommandChunk)commandBatch2;
            string = String.valueOf(cc.chunkMetadata().chunkId());
        } else {
            string = "N/A";
        }
        return string;
    }

    @Override
    public void reset() {
        this.chunkNumber = 1;
        this.kernelVersion = null;
        this.transactionPayload = null;
        this.lastTransactionIdWhenStarted = 0L;
        this.startTimeMillis = 0L;
        this.leaseClient = null;
    }
}

