/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexProvider;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.TextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.impl.index.schema.TokenIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.TrigramIndexProviderFactory;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

public class StaticIndexProviderMapFactory {
    public static StaticIndexProviderMap create(LifeSupport life, Config databaseConfig, PageCache pageCache, FileSystemAbstraction fs, LogService logService, Monitors monitors, DatabaseReadOnlyChecker readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode mode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, TokenHolders tokenHolders, JobScheduler scheduler, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        return StaticIndexProviderMapFactory.create(life, databaseConfig, pageCache, fs, logService, monitors, readOnlyChecker, mode, recoveryCleanupWorkCollector, databaseLayout, tokenHolders, scheduler, contextFactory, pageCacheTracer, (DependencyResolver)new Dependencies());
    }

    public static StaticIndexProviderMap create(LifeSupport life, Config databaseConfig, PageCache pageCache, FileSystemAbstraction fs, LogService logService, Monitors monitors, DatabaseReadOnlyChecker readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode mode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, TokenHolders tokenHolders, JobScheduler scheduler, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, DependencyResolver dependencies) {
        TokenIndexProvider tokenIndexProvider = (TokenIndexProvider)life.add((Lifecycle)((TokenIndexProvider)((Object)new TokenIndexProviderFactory().create(pageCache, fs, logService, monitors, databaseConfig, readOnlyChecker, mode, recoveryCleanupWorkCollector, databaseLayout, tokenHolders, scheduler, contextFactory, pageCacheTracer))));
        TextIndexProvider textIndexProvider = (TextIndexProvider)life.add((Lifecycle)((TextIndexProvider)new TextIndexProviderFactory().create(pageCache, fs, logService, monitors, databaseConfig, readOnlyChecker, mode, recoveryCleanupWorkCollector, databaseLayout, tokenHolders, scheduler, contextFactory, pageCacheTracer)));
        FulltextIndexProvider fulltextIndexProvider = (FulltextIndexProvider)life.add((Lifecycle)((FulltextIndexProvider)new FulltextIndexProviderFactory().create(pageCache, fs, logService, monitors, databaseConfig, readOnlyChecker, mode, recoveryCleanupWorkCollector, databaseLayout, tokenHolders, scheduler, contextFactory, pageCacheTracer)));
        RangeIndexProvider rangeIndexProvider = (RangeIndexProvider)life.add((Lifecycle)((RangeIndexProvider)((Object)new RangeIndexProviderFactory().create(pageCache, fs, logService, monitors, databaseConfig, readOnlyChecker, mode, recoveryCleanupWorkCollector, databaseLayout, tokenHolders, scheduler, contextFactory, pageCacheTracer))));
        PointIndexProvider pointIndexProvider = (PointIndexProvider)life.add((Lifecycle)((PointIndexProvider)((Object)new PointIndexProviderFactory().create(pageCache, fs, logService, monitors, databaseConfig, readOnlyChecker, mode, recoveryCleanupWorkCollector, databaseLayout, tokenHolders, scheduler, contextFactory, pageCacheTracer))));
        TrigramIndexProvider trigramIndexProvider = (Boolean)databaseConfig.get(GraphDatabaseInternalSettings.trigram_index) != false ? (TrigramIndexProvider)life.add((Lifecycle)((TrigramIndexProvider)new TrigramIndexProviderFactory().create(pageCache, fs, logService, monitors, databaseConfig, readOnlyChecker, mode, recoveryCleanupWorkCollector, databaseLayout, tokenHolders, scheduler, contextFactory, pageCacheTracer))) : null;
        return new StaticIndexProviderMap(tokenIndexProvider, textIndexProvider, fulltextIndexProvider, rangeIndexProvider, pointIndexProvider, trigramIndexProvider, dependencies);
    }
}

