/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AdminAccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.BasicContext;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class ProcedureCaller {
    private final KernelTransaction ktx;
    private final GlobalProcedures globalProcedures;
    private final DependencyResolver databaseDependencies;

    public ProcedureCaller(KernelTransaction ktx, GlobalProcedures globalProcedures, DependencyResolver databaseDependencies) {
        this.ktx = ktx;
        this.globalProcedures = globalProcedures;
        this.databaseDependencies = databaseDependencies;
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(int id, AnyValue[] input, AccessMode.Static procedureMode, ProcedureCallContext procedureCallContext) throws ProcedureException {
        RawIterator<AnyValue[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        if (!mode.allowsExecuteProcedure(id).allowsAccess()) {
            String message = String.format("Executing procedure is not allowed for %s.", this.ktx.securityContext().description());
            throw this.ktx.securityAuthorizationHandler().logAndGetAuthorizationException(this.ktx.securityContext(), message);
        }
        SecurityContext procedureSecurityContext = mode.shouldBoostProcedure(id).allowsAccess() ? this.ktx.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, procedureMode)).withMode(AdminAccessMode.FULL) : this.ktx.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, procedureMode));
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             Statement statement = this.ktx.acquireStatement();){
            procedureCall = this.globalProcedures.callProcedure(this.prepareContext(procedureSecurityContext, procedureCallContext), id, input, (ResourceTracker)statement);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    public RawIterator<AnyValue[], ProcedureException> createIterator(final SecurityContext procedureSecurityContext, final RawIterator<AnyValue[], ProcedureException> procedureCall) {
        return new RawIterator<AnyValue[], ProcedureException>(){

            public boolean hasNext() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = ProcedureCaller.this.ktx.overrideWith(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            public AnyValue[] next() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = ProcedureCaller.this.ktx.overrideWith(procedureSecurityContext);){
                    AnyValue[] anyValueArray = (AnyValue[])procedureCall.next();
                    return anyValueArray;
                }
            }
        };
    }

    public AnyValue callFunction(int id, AnyValue[] input) throws ProcedureException {
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        if (!mode.allowsExecuteFunction(id).allowsAccess()) {
            String message = String.format("Executing a user defined function is not allowed for %s.", this.ktx.securityContext().description());
            throw this.ktx.securityAuthorizationHandler().logAndGetAuthorizationException(this.ktx.securityContext(), message);
        }
        SecurityContext securityContext = mode.shouldBoostFunction(id).allowsAccess() ? this.ktx.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, AccessMode.Static.READ)) : this.ktx.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, AccessMode.Static.READ));
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            AnyValue anyValue = this.globalProcedures.callFunction(this.prepareContext(securityContext, ProcedureCallContext.EMPTY), id, input);
            return anyValue;
        }
    }

    public AnyValue callBuiltInFunction(int id, AnyValue[] input) throws ProcedureException {
        this.ktx.assertOpen();
        return this.globalProcedures.callFunction(this.prepareContext(this.ktx.securityContext(), ProcedureCallContext.EMPTY), id, input);
    }

    public UserAggregator createAggregationFunction(int id) throws ProcedureException {
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        if (!mode.allowsExecuteAggregatingFunction(id).allowsAccess()) {
            String message = String.format("Executing a user defined aggregating function is not allowed for %s.", this.ktx.securityContext().description());
            throw this.ktx.securityAuthorizationHandler().logAndGetAuthorizationException(this.ktx.securityContext(), message);
        }
        final SecurityContext securityContext = mode.shouldBoostAggregatingFunction(id).allowsAccess() ? this.ktx.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, AccessMode.Static.READ)) : this.ktx.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, AccessMode.Static.READ));
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            final UserAggregator aggregator = this.globalProcedures.createAggregationFunction(this.prepareContext(securityContext, ProcedureCallContext.EMPTY), id);
            UserAggregator userAggregator = new UserAggregator(){

                public void update(AnyValue[] input) throws ProcedureException {
                    try (KernelTransaction.Revertable ignore = ProcedureCaller.this.ktx.overrideWith(securityContext);){
                        aggregator.update(input);
                    }
                }

                public AnyValue result() throws ProcedureException {
                    try (KernelTransaction.Revertable ignore = ProcedureCaller.this.ktx.overrideWith(securityContext);){
                        AnyValue anyValue = aggregator.result();
                        return anyValue;
                    }
                }
            };
            return userAggregator;
        }
    }

    public UserAggregator createBuiltInAggregationFunction(int id) throws ProcedureException {
        this.ktx.assertOpen();
        final UserAggregator aggregator = this.globalProcedures.createAggregationFunction(this.prepareContext(this.ktx.securityContext(), ProcedureCallContext.EMPTY), id);
        return new UserAggregator(){

            public void update(AnyValue[] input) throws ProcedureException {
                aggregator.update(input);
            }

            public AnyValue result() throws ProcedureException {
                return aggregator.result();
            }
        };
    }

    private Context prepareContext(SecurityContext securityContext, ProcedureCallContext procedureContext) {
        InternalTransaction internalTransaction = this.ktx.internalTransaction();
        return BasicContext.buildContext(this.databaseDependencies, (ValueMapper<Object>)new DefaultValueMapper(internalTransaction)).withTransaction(internalTransaction).withSecurityContext(securityContext).withProcedureCallContext(procedureContext).context();
    }
}

