/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageRelationshipCursor;

abstract class DefaultRelationshipCursor<SELF extends DefaultRelationshipCursor>
extends TraceableCursor<SELF>
implements RelationshipDataAccessor {
    protected boolean hasChanges;
    boolean checkHasChanges;
    AccessMode accessMode;
    Read read;
    final StorageRelationshipCursor storeCursor;
    RelationshipVisitor<RuntimeException> relationshipTxStateDataVisitor = new TxStateDataVisitor();
    long currentAddedInTx = -1L;
    private int txStateTypeId;
    long txStateSourceNodeReference;
    long txStateTargetNodeReference;

    DefaultRelationshipCursor(StorageRelationshipCursor storeCursor, CursorPool<SELF> pool) {
        super(pool);
        this.storeCursor = storeCursor;
    }

    protected void init(Read read) {
        this.currentAddedInTx = -1L;
        this.read = read;
        this.checkHasChanges = true;
        this.accessMode = read.ktx.securityContext().mode();
    }

    public long relationshipReference() {
        return this.currentAddedInTx != -1L ? this.currentAddedInTx : this.storeCursor.entityReference();
    }

    public int type() {
        return this.currentAddedInTx != -1L ? this.txStateTypeId : this.storeCursor.type();
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        ((DefaultPropertyCursor)cursor).initRelationship(this, selection, this.read, this.read);
    }

    public long sourceNodeReference() {
        return this.currentAddedInTx != -1L ? this.txStateSourceNodeReference : this.storeCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        return this.currentAddedInTx != -1L ? this.txStateTargetNodeReference : this.storeCursor.targetNodeReference();
    }

    public Reference propertiesReference() {
        return this.currentAddedInTx != -1L ? LongReference.NULL_REFERENCE : this.storeCursor.propertiesReference();
    }

    protected abstract void collectAddedTxStateSnapshot();

    protected boolean currentRelationshipIsAddedInTx() {
        return this.currentAddedInTx != -1L;
    }

    protected boolean hasChanges() {
        if (this.checkHasChanges) {
            this.hasChanges = this.read.hasTxStateWithChanges();
            if (this.hasChanges) {
                this.collectAddedTxStateSnapshot();
            }
            this.checkHasChanges = false;
        }
        return this.hasChanges;
    }

    private class TxStateDataVisitor
    implements RelationshipVisitor<RuntimeException> {
        private TxStateDataVisitor() {
        }

        public void visit(long relationshipId, int typeId, long sourceNodeReference, long targetNodeReference) {
            DefaultRelationshipCursor.this.currentAddedInTx = relationshipId;
            DefaultRelationshipCursor.this.txStateTypeId = typeId;
            DefaultRelationshipCursor.this.txStateSourceNodeReference = sourceNodeReference;
            DefaultRelationshipCursor.this.txStateTargetNodeReference = targetNodeReference;
        }
    }
}

