/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;

public class DefaultRelationshipBasedRelationshipTypeIndexCursor
extends DefaultRelationshipTypeIndexCursor {
    private final DefaultRelationshipScanCursor relationshipScanCursor;

    DefaultRelationshipBasedRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool, DefaultRelationshipScanCursor relationshipScanCursor) {
        super(pool);
        this.relationshipScanCursor = relationshipScanCursor;
    }

    @Override
    boolean allowedToSeeEntity(AccessMode accessMode, long entityReference) {
        if (accessMode.allowsTraverseAllRelTypes()) {
            return true;
        }
        this.readEntity(read -> read.singleRelationship(entityReference, this.relationshipScanCursor));
        return this.relationshipScanCursor.next();
    }

    public void source(NodeCursor cursor) {
        this.checkReadFromStore();
        this.read.singleNode(this.relationshipScanCursor.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.checkReadFromStore();
        this.read.singleNode(this.relationshipScanCursor.targetNodeReference(), cursor);
    }

    public long sourceNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.targetNodeReference();
    }

    @Override
    public long relationshipReference() {
        return this.entityReference();
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        this.checkReadFromStore();
        this.relationshipScanCursor.properties(cursor, selection);
    }

    public Reference propertiesReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.propertiesReference();
    }

    public boolean readFromStore() {
        if (this.relationshipScanCursor.relationshipReference() == this.entity) {
            return true;
        }
        this.relationshipScanCursor.single(this.entity, this.read);
        return this.relationshipScanCursor.next();
    }

    private void checkReadFromStore() {
        if (this.relationshipScanCursor.relationshipReference() != this.entity) {
            throw new IllegalStateException("Relationship hasn't been read from store");
        }
    }

    @Override
    public void release() {
        this.relationshipScanCursor.close();
        this.relationshipScanCursor.release();
    }
}

