/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;

public class DefaultNodeBasedRelationshipTypeIndexCursor
extends DefaultRelationshipTypeIndexCursor {
    private final DefaultNodeCursor nodeCursor;
    private final DefaultRelationshipTraversalCursor relationshipTraversalCursor;

    DefaultNodeBasedRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool, DefaultNodeCursor nodeCursor, DefaultRelationshipTraversalCursor relationshipTraversalCursor) {
        super(pool);
        this.nodeCursor = nodeCursor;
        this.relationshipTraversalCursor = relationshipTraversalCursor;
    }

    @Override
    boolean allowedToSeeEntity(AccessMode accessMode, long entityReference) {
        return true;
    }

    public boolean readFromStore() {
        return true;
    }

    @Override
    protected boolean innerNext() {
        while (true) {
            if (this.relationshipTraversalCursor.next()) {
                this.entity = this.relationshipTraversalCursor.relationshipReference();
                return true;
            }
            if (!super.innerNext()) {
                return false;
            }
            this.nodeCursor.single(this.entity, this.read);
            if (!this.nodeCursor.next()) continue;
            this.nodeCursor.relationships(this.relationshipTraversalCursor, RelationshipSelection.selection((int)this.tokenId, (Direction)Direction.OUTGOING));
        }
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.relationshipTraversalCursor.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.relationshipTraversalCursor.targetNodeReference(), cursor);
    }

    public long sourceNodeReference() {
        return this.relationshipTraversalCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        return this.relationshipTraversalCursor.targetNodeReference();
    }

    @Override
    public long relationshipReference() {
        return this.entityReference();
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        this.relationshipTraversalCursor.properties(cursor, selection);
    }

    public Reference propertiesReference() {
        return this.relationshipTraversalCursor.propertiesReference();
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.nodeCursor.close();
            this.relationshipTraversalCursor.close();
        }
        super.closeInternal();
    }

    @Override
    public void release() {
        this.nodeCursor.release();
        this.relationshipTraversalCursor.release();
    }
}

