/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeMinimalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TokenIndexPopulator;
import org.neo4j.kernel.impl.index.schema.TokenIndexes;
import org.neo4j.kernel.impl.index.schema.WorkSyncedIndexPopulator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.storageengine.migration.TokenIndexMigrator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

public class TokenIndexProvider
extends IndexProvider {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("token-lookup", "1.0");
    public static final IndexCapability CAPABILITY = new TokenIndexCapability();
    private final DatabaseIndexContext databaseIndexContext;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final IndexProvider.Monitor monitor;
    private final DatabaseLayout databaseLayout;

    protected TokenIndexProvider(DatabaseIndexContext databaseIndexContext, IndexDirectoryStructure.Factory directoryStructureFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout) {
        super(DESCRIPTOR, directoryStructureFactory);
        this.databaseIndexContext = databaseIndexContext;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.monitor = (IndexProvider.Monitor)databaseIndexContext.monitors.newMonitor(IndexProvider.Monitor.class, new String[]{databaseIndexContext.monitorTag});
        this.databaseLayout = databaseLayout;
    }

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor) {
        return new NativeMinimalIndexAccessor(descriptor, this.indexFiles((SchemaRule)descriptor), this.databaseIndexContext.readOnlyChecker);
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions) {
        if (this.databaseIndexContext.readOnlyChecker.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        return new WorkSyncedIndexPopulator(new TokenIndexPopulator(this.databaseIndexContext, this.indexFiles((SchemaRule)descriptor), descriptor, openOptions));
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions) {
        return new TokenIndexAccessor(this.databaseIndexContext, this.indexFiles((SchemaRule)descriptor), descriptor, this.recoveryCleanupWorkCollector, openOptions);
    }

    public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
        try {
            String failureMessage = TokenIndexes.readFailureMessage(this.databaseIndexContext.pageCache, this.storeFile((SchemaRule)descriptor), this.databaseIndexContext.databaseName, cursorContext, openOptions);
            return (String)StringUtils.defaultIfEmpty((CharSequence)failureMessage, (CharSequence)"");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
        try {
            return TokenIndexes.readState(this.databaseIndexContext.pageCache, this.storeFile((SchemaRule)descriptor), this.databaseIndexContext.databaseName, cursorContext, openOptions);
        }
        catch (IOException | MetadataMismatchException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, StorageEngineFactory storageEngineFactory, CursorContextFactory contextFactory) {
        return new TokenIndexMigrator("Token indexes", fs, pageCache, pageCacheTracer, storageEngineFactory, this.databaseLayout, this::storeFile, contextFactory);
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        if (index.getCapability().equals(IndexCapability.NO_CAPABILITY)) {
            index = index.withIndexCapability(CAPABILITY);
        }
        return index;
    }

    public void validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        if (indexType != IndexType.LOOKUP) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support " + indexType + " indexes: " + prototype);
        }
        if (!prototype.schema().isAnyTokenSchemaDescriptor()) {
            throw new IllegalArgumentException("The " + prototype.schema() + " index schema is not an any-token index schema, which it is required to be for the '" + this.getProviderDescriptor().name() + "' index provider to be able to create an index.");
        }
        if (!prototype.getIndexProvider().equals((Object)DESCRIPTOR)) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support " + prototype.getIndexProvider() + " indexes: " + prototype);
        }
        if (prototype.isUnique()) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support uniqueness indexes: " + prototype);
        }
    }

    public IndexType getIndexType() {
        return IndexType.LOOKUP;
    }

    private Path storeFile(SchemaRule schemaRule) {
        IndexFiles indexFiles = this.indexFiles(schemaRule);
        return indexFiles.getStoreFile();
    }

    private IndexFiles indexFiles(SchemaRule schemaRule) {
        return TokenIndexProvider.indexFiles(schemaRule, this.databaseIndexContext.fileSystem, this.directoryStructure());
    }

    public static IndexFiles indexFiles(SchemaRule schemaRule, FileSystemAbstraction fileSystem, IndexDirectoryStructure indexDirectoryStructure) {
        return new IndexFiles.Directory(fileSystem, indexDirectoryStructure, schemaRule.getId());
    }

    private static class TokenIndexCapability
    implements IndexCapability {
        private TokenIndexCapability() {
        }

        public boolean supportsOrdering() {
            return true;
        }

        public boolean supportsReturningValues() {
            return true;
        }

        public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
            Preconditions.requireNonEmpty((Object[])valueCategories);
            Preconditions.requireNoNullElements((Object[])valueCategories);
            return false;
        }

        public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
            return queryType == IndexQuery.IndexQueryType.TOKEN_LOOKUP && valueCategory == ValueCategory.NO_CATEGORY;
        }

        public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
            return 1.0;
        }

        public boolean supportPartitionedScan(IndexQuery ... queries) {
            Preconditions.requireNonEmpty((Object[])queries);
            Preconditions.requireNoNullElements((Object[])queries);
            return queries.length == 1 && queries[0].type() == IndexQuery.IndexQueryType.TOKEN_LOOKUP;
        }
    }
}

