/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.monitoring.Monitors;

public class DatabaseIndexContext {
    final PageCache pageCache;
    final CursorContextFactory contextFactory;
    final PageCacheTracer pageCacheTracer;
    final FileSystemAbstraction fileSystem;
    final Monitors monitors;
    final String monitorTag;
    final DatabaseReadOnlyChecker readOnlyChecker;
    final String databaseName;

    private DatabaseIndexContext(PageCache pageCache, FileSystemAbstraction fileSystem, Monitors monitors, String monitorTag, DatabaseReadOnlyChecker readOnlyChecker, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, String databaseName) {
        this.pageCache = pageCache;
        this.fileSystem = fileSystem;
        this.monitors = monitors;
        this.monitorTag = monitorTag;
        this.readOnlyChecker = readOnlyChecker;
        this.contextFactory = contextFactory;
        this.pageCacheTracer = pageCacheTracer;
        this.databaseName = databaseName;
    }

    public static Builder builder(PageCache pageCache, FileSystemAbstraction fileSystem, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, String databaseName) {
        return new Builder(pageCache, fileSystem, contextFactory, pageCacheTracer, databaseName);
    }

    public static Builder builder(DatabaseIndexContext copy) {
        return new Builder(copy.pageCache, copy.fileSystem, copy.contextFactory, copy.pageCacheTracer, copy.databaseName).withReadOnlyChecker(copy.readOnlyChecker).withMonitors(copy.monitors).withTag(copy.monitorTag);
    }

    public static class Builder {
        private final PageCache pageCache;
        private final CursorContextFactory contextFactory;
        private final PageCacheTracer pageCacheTracer;
        private final FileSystemAbstraction fileSystem;
        private final String databaseName;
        private Monitors monitors;
        private String monitorTag;
        private DatabaseReadOnlyChecker readOnlyChecker;

        private Builder(PageCache pageCache, FileSystemAbstraction fileSystem, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, String databaseName) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.contextFactory = contextFactory;
            this.pageCacheTracer = pageCacheTracer;
            this.databaseName = databaseName;
            this.monitors = new Monitors();
            this.monitorTag = "";
            this.readOnlyChecker = DatabaseReadOnlyChecker.writable();
        }

        public Builder withReadOnlyChecker(DatabaseReadOnlyChecker readOnlyChecker) {
            this.readOnlyChecker = readOnlyChecker;
            return this;
        }

        public Builder withMonitors(Monitors monitors) {
            this.monitors = monitors;
            return this;
        }

        public Builder withTag(String monitorTag) {
            this.monitorTag = monitorTag;
            return this;
        }

        public DatabaseIndexContext build() {
            return new DatabaseIndexContext(this.pageCache, this.fileSystem, this.monitors, this.monitorTag, this.readOnlyChecker, this.contextFactory, this.pageCacheTracer, this.databaseName);
        }
    }
}

