/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexPopulationProgress;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedSchemaComponentException;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.BaseRelationshipConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.TokenIndexCreator;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.time.Stopwatch;

public class SchemaImpl
implements Schema {
    private final InternalSchemaActions actions;
    private final KernelTransaction transaction;

    public SchemaImpl(KernelTransaction transaction) {
        this.transaction = transaction;
        this.actions = new GDBSchemaActions(transaction);
    }

    public IndexCreator indexFor(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    public IndexCreator indexFor(Label ... labels) {
        return new IndexCreatorImpl(this.actions, labels);
    }

    public IndexCreator indexFor(RelationshipType type) {
        return new IndexCreatorImpl(this.actions, type);
    }

    public IndexCreator indexFor(RelationshipType ... types) {
        return new IndexCreatorImpl(this.actions, types);
    }

    public IndexCreator indexFor(AnyTokens tokens) {
        return new TokenIndexCreator(this.actions, tokens);
    }

    public Iterable<IndexDefinition> getIndexes(Label label) {
        this.transaction.assertOpen();
        TokenRead tokenRead = this.transaction.tokenRead();
        SchemaRead schemaRead = this.transaction.schemaRead();
        ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
        int labelId = tokenRead.nodeLabel(label.name());
        if (labelId == -1) {
            return Collections.emptyList();
        }
        Iterator indexes = schemaRead.indexesGetForLabel(labelId);
        this.addDefinitions(definitions, tokenRead, IndexDescriptor.sortByType((Iterator)indexes));
        return definitions;
    }

    public Iterable<IndexDefinition> getIndexes(RelationshipType relationshipType) {
        this.transaction.assertOpen();
        TokenRead tokenRead = this.transaction.tokenRead();
        SchemaRead schemaRead = this.transaction.schemaRead();
        ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
        int relationshipTypeId = tokenRead.relationshipType(relationshipType.name());
        if (relationshipTypeId == -1) {
            return Collections.emptyList();
        }
        Iterator indexes = schemaRead.indexesGetForRelationshipType(relationshipTypeId);
        this.addDefinitions(definitions, tokenRead, IndexDescriptor.sortByType((Iterator)indexes));
        return definitions;
    }

    public Iterable<IndexDefinition> getIndexes() {
        this.transaction.assertOpen();
        SchemaRead schemaRead = this.transaction.schemaRead();
        ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
        Iterator indexes = schemaRead.indexesGetAll();
        this.addDefinitions(definitions, this.transaction.tokenRead(), IndexDescriptor.sortByType((Iterator)indexes));
        return definitions;
    }

    private IndexDefinition descriptorToDefinition(TokenRead tokenRead, IndexDescriptor index) {
        try {
            SchemaDescriptor schema = index.schema();
            int[] entityTokenIds = schema.getEntityTokenIds();
            boolean constraintIndex = index.isUnique();
            String[] propertyNames = PropertyNameUtils.getPropertyKeysOrThrow(tokenRead, index.schema().getPropertyIds());
            switch (schema.entityType()) {
                case NODE: {
                    Label[] labels = new Label[entityTokenIds.length];
                    for (int i = 0; i < labels.length; ++i) {
                        labels[i] = Label.label((String)tokenRead.nodeLabelName(entityTokenIds[i]));
                    }
                    return new IndexDefinitionImpl(this.actions, index, labels, propertyNames, constraintIndex);
                }
                case RELATIONSHIP: {
                    RelationshipType[] relTypes = new RelationshipType[entityTokenIds.length];
                    for (int i = 0; i < relTypes.length; ++i) {
                        relTypes[i] = RelationshipType.withName((String)tokenRead.relationshipTypeName(entityTokenIds[i]));
                    }
                    return new IndexDefinitionImpl(this.actions, index, relTypes, propertyNames, constraintIndex);
                }
            }
            throw new IllegalArgumentException("Cannot create IndexDefinition for " + schema.entityType() + " entity-typed schema.");
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, TokenRead tokenRead, Iterator<IndexDescriptor> indexes) {
        Iterators.addToCollection((Iterator)Iterators.map(index -> this.descriptorToDefinition(tokenRead, (IndexDescriptor)index), indexes), definitions);
    }

    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        IndexDescriptor reference = ((IndexDefinitionImpl)index).getIndexReference();
        Iterable<IndexDescriptor> iterable = () -> Iterators.iterator((Object)reference);
        if (this.awaitIndexesOnline(iterable, descriptor -> index.toString(), duration, unit, true)) {
            throw new IllegalStateException("Expected index to come online within a reasonable time.");
        }
    }

    public void awaitIndexOnline(String indexName, long duration, TimeUnit unit) {
        Objects.requireNonNull(indexName);
        this.transaction.assertOpen();
        SchemaRead schemaRead = this.transaction.schemaRead();
        Iterable<IndexDescriptor> iterable = () -> Iterators.iterator((Object)schemaRead.indexGetForName(indexName));
        if (this.awaitIndexesOnline(iterable, index -> "`" + indexName + "`", duration, unit, false)) {
            throw new IllegalStateException("Expected index to come online within a reasonable time.");
        }
    }

    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.transaction.assertOpen();
        Iterable<IndexDescriptor> iterable = () -> Iterators.map(def -> ((IndexDefinitionImpl)def).getIndexReference(), this.getIndexes().iterator());
        if (this.awaitIndexesOnline(iterable, index -> this.descriptorToDefinition(this.transaction.tokenRead(), (IndexDescriptor)index).toString(), duration, unit, false)) {
            ArrayList<IndexDefinition> online = new ArrayList<IndexDefinition>();
            ArrayList<IndexDefinition> notOnline = new ArrayList<IndexDefinition>();
            for (IndexDefinition index2 : this.getIndexes()) {
                try {
                    if (this.getIndexState(index2) == Schema.IndexState.ONLINE) {
                        online.add(index2);
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                notOnline.add(index2);
            }
            throw new IllegalStateException("Expected all indexes to come online within a reasonable time. Indexes brought online: " + online + ". Indexes not guaranteed to be online: " + notOnline);
        }
    }

    private boolean awaitIndexesOnline(Iterable<IndexDescriptor> indexes, Function<IndexDescriptor, String> describe, long duration, TimeUnit unit, boolean bubbleNotFound) {
        Stopwatch startTime = Stopwatch.start();
        do {
            boolean allOnline = true;
            SchemaRead schemaRead = this.transaction.schemaRead();
            for (IndexDescriptor index : indexes) {
                if (index == IndexDescriptor.NO_INDEX) {
                    allOnline = false;
                    break;
                }
                try {
                    InternalIndexState indexState = schemaRead.indexGetState(index);
                    if (indexState != InternalIndexState.POPULATING) {
                        if (indexState != InternalIndexState.FAILED) continue;
                        String cause = schemaRead.indexGetFailure(index);
                        Object message = "Index " + describe.apply(index) + " entered a " + indexState + " state. Please see database logs.";
                        message = IndexPopulationFailure.appendCauseOfFailure((String)message, cause);
                        throw new IllegalStateException((String)message);
                    }
                    allOnline = false;
                }
                catch (IndexNotFoundKernelException e) {
                    if (bubbleNotFound) {
                        throw SchemaImpl.newIndexNotFoundException(this.descriptorToDefinition(this.transaction.tokenRead(), index), (KernelException)((Object)e));
                    }
                    allOnline = false;
                }
                break;
            }
            if (allOnline) {
                return false;
            }
            SchemaImpl.sleepIgnoreInterrupt();
        } while (!startTime.hasTimedOut(duration, unit));
        return true;
    }

    private static void sleepIgnoreInterrupt() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ConstraintDefinition getConstraintByName(String constraintName) {
        this.transaction.assertOpen();
        Objects.requireNonNull(constraintName);
        ConstraintDescriptor constraint = this.transaction.schemaRead().constraintGetForName(constraintName);
        if (constraint == null) {
            throw new IllegalArgumentException("No constraint found with the name '" + constraintName + "'.");
        }
        return this.asConstraintDefinition(constraint, this.transaction.tokenRead());
    }

    public IndexDefinition getIndexByName(String indexName) {
        Objects.requireNonNull(indexName);
        this.transaction.assertOpen();
        Iterator<IndexDefinition> indexes = this.getIndexes().iterator();
        IndexDefinition index = null;
        while (indexes.hasNext()) {
            IndexDefinition candidate = indexes.next();
            if (!candidate.getName().equals(indexName)) continue;
            if (index != null) {
                throw new IllegalStateException("Multiple indexes found by the name '" + indexName + "'. Try iterating Schema#getIndexes() and filter by name instead.");
            }
            index = candidate;
        }
        if (index == null) {
            throw new IllegalArgumentException("No index found with the name '" + indexName + "'.");
        }
        return index;
    }

    public Schema.IndexState getIndexState(IndexDefinition index) {
        try {
            this.transaction.assertOpen();
            SchemaRead schemaRead = this.transaction.schemaRead();
            IndexDescriptor reference = SchemaImpl.getIndexReference(schemaRead, this.transaction.tokenRead(), (IndexDefinitionImpl)index);
            InternalIndexState indexState = schemaRead.indexGetState(reference);
            switch (indexState) {
                case POPULATING: {
                    return Schema.IndexState.POPULATING;
                }
                case ONLINE: {
                    return Schema.IndexState.ONLINE;
                }
                case FAILED: {
                    return Schema.IndexState.FAILED;
                }
            }
            throw new IllegalArgumentException(String.format("Illegal index state %s", indexState));
        }
        catch (KernelException e) {
            throw SchemaImpl.newIndexNotFoundException(index, e);
        }
    }

    private static NotFoundException newIndexNotFoundException(IndexDefinition index, KernelException e) {
        return new NotFoundException("No index was found corresponding to " + index + ".", (Throwable)e);
    }

    public IndexPopulationProgress getIndexPopulationProgress(IndexDefinition index) {
        try {
            this.transaction.assertOpen();
            SchemaRead schemaRead = this.transaction.schemaRead();
            IndexDescriptor descriptor = SchemaImpl.getIndexReference(schemaRead, this.transaction.tokenRead(), (IndexDefinitionImpl)index);
            PopulationProgress progress = schemaRead.indexGetPopulationProgress(descriptor);
            return progress.toIndexPopulationProgress();
        }
        catch (KernelException e) {
            throw SchemaImpl.newIndexNotFoundException(index, e);
        }
    }

    public String getIndexFailure(IndexDefinition index) {
        try {
            this.transaction.assertOpen();
            SchemaRead schemaRead = this.transaction.schemaRead();
            IndexDescriptor descriptor = SchemaImpl.getIndexReference(schemaRead, this.transaction.tokenRead(), (IndexDefinitionImpl)index);
            return schemaRead.indexGetFailure(descriptor);
        }
        catch (KernelException e) {
            throw SchemaImpl.newIndexNotFoundException(index, e);
        }
    }

    public ConstraintCreator constraintFor(Label label) {
        this.transaction.assertOpen();
        return new BaseNodeConstraintCreator(this.actions, null, label, null, null);
    }

    public ConstraintCreator constraintFor(RelationshipType type) {
        this.transaction.assertOpen();
        return new BaseRelationshipConstraintCreator(this.actions, null, type, null, null);
    }

    public Iterable<ConstraintDefinition> getConstraints() {
        this.transaction.assertOpen();
        return this.asConstraintDefinitions(this.transaction.schemaRead().constraintsGetAll(), this.transaction.tokenRead());
    }

    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        this.transaction.assertOpen();
        TokenRead tokenRead = this.transaction.tokenRead();
        SchemaRead schemaRead = this.transaction.schemaRead();
        int labelId = tokenRead.nodeLabel(label.name());
        if (labelId == -1) {
            return Collections.emptyList();
        }
        return this.asConstraintDefinitions(schemaRead.constraintsGetForLabel(labelId), tokenRead);
    }

    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        this.transaction.assertOpen();
        TokenRead tokenRead = this.transaction.tokenRead();
        SchemaRead schemaRead = this.transaction.schemaRead();
        int typeId = tokenRead.relationshipType(type.name());
        if (typeId == -1) {
            return Collections.emptyList();
        }
        return this.asConstraintDefinitions(schemaRead.constraintsGetForRelationshipType(typeId), tokenRead);
    }

    private static IndexDescriptor getIndexReference(SchemaRead schemaRead, TokenRead tokenRead, IndexDefinitionImpl index) throws SchemaRuleException {
        Object schema;
        IndexDescriptor reference = index.getIndexReference();
        if (reference != null) {
            return reference;
        }
        int[] propertyKeyIds = SchemaImpl.resolveAndValidatePropertyKeys(tokenRead, index.getPropertyKeysArrayShared());
        if (index.isNodeIndex()) {
            int[] labelIds = SchemaImpl.resolveAndValidateTokens("Label", index.getLabelArrayShared(), Label::name, arg_0 -> ((TokenRead)tokenRead).nodeLabel(arg_0));
            schema = index.isMultiTokenIndex() ? SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])labelIds, (int[])propertyKeyIds) : (index.getIndexType() == org.neo4j.graphdb.schema.IndexType.LOOKUP ? SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE) : SchemaDescriptors.forLabel((int)labelIds[0], (int[])propertyKeyIds));
        } else if (index.isRelationshipIndex()) {
            int[] relTypes = SchemaImpl.resolveAndValidateTokens("Relationship type", index.getRelationshipTypesArrayShared(), RelationshipType::name, arg_0 -> ((TokenRead)tokenRead).relationshipType(arg_0));
            schema = index.isMultiTokenIndex() ? SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])relTypes, (int[])propertyKeyIds) : (index.getIndexType() == org.neo4j.graphdb.schema.IndexType.LOOKUP ? SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP) : SchemaDescriptors.forRelType((int)relTypes[0], (int[])propertyKeyIds));
        } else {
            throw new IllegalArgumentException("The given index is neither a node index, nor a relationship index: " + index + ".");
        }
        IndexDescriptor foundReference = schemaRead.index((SchemaDescriptor)schema, IndexType.fromPublicApi((org.neo4j.graphdb.schema.IndexType)index.getIndexType()));
        if (foundReference == IndexDescriptor.NO_INDEX) {
            throw new SchemaRuleNotFoundException((SchemaDescriptor)schema, (TokenNameLookup)tokenRead);
        }
        return foundReference;
    }

    private static int[] resolveAndValidatePropertyKeys(TokenRead tokenRead, String[] propertyKeys) {
        return SchemaImpl.resolveAndValidateTokens("Property key", propertyKeys, s -> s, arg_0 -> ((TokenRead)tokenRead).propertyKey(arg_0));
    }

    private static <T> int[] resolveAndValidateTokens(String tokenTypeName, T[] tokens, Function<T, String> getTokenName, ToIntFunction<String> getTokenId) {
        int[] tokenIds = new int[tokens.length];
        for (int i = 0; i < tokenIds.length; ++i) {
            String tokenName = getTokenName.apply(tokens[i]);
            int tokenId = getTokenId.applyAsInt(tokenName);
            if (tokenId == -1) {
                throw new NotFoundException(tokenTypeName + " " + tokenName + " not found.");
            }
            tokenIds[i] = tokenId;
        }
        return tokenIds;
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(Iterator<? extends ConstraintDescriptor> constraints, TokenRead tokenRead) {
        ArrayList<ConstraintDefinition> definitions = new ArrayList<ConstraintDefinition>();
        while (constraints.hasNext()) {
            ConstraintDescriptor constraint = constraints.next();
            definitions.add(this.asConstraintDefinition(constraint, tokenRead));
        }
        return definitions;
    }

    private ConstraintDefinition asConstraintDefinition(ConstraintDescriptor constraint, TokenRead tokenRead) {
        if (constraint.isNodePropertyExistenceConstraint() || constraint.isNodeKeyConstraint() || constraint.isUniquenessConstraint()) {
            SchemaDescriptor schemaDescriptor = constraint.schema();
            int[] entityTokenIds = schemaDescriptor.getEntityTokenIds();
            Label[] labels = new Label[entityTokenIds.length];
            for (int i = 0; i < entityTokenIds.length; ++i) {
                labels[i] = Label.label((String)tokenRead.labelGetName(entityTokenIds[i]));
            }
            String[] propertyKeys = (String[])Arrays.stream(schemaDescriptor.getPropertyIds()).mapToObj(arg_0 -> ((TokenRead)tokenRead).propertyKeyGetName(arg_0)).toArray(String[]::new);
            if (constraint.isNodePropertyExistenceConstraint()) {
                return new NodePropertyExistenceConstraintDefinition(this.actions, constraint, labels[0], propertyKeys);
            }
            if (constraint.isUniquenessConstraint()) {
                return new UniquenessConstraintDefinition(this.actions, constraint, new IndexDefinitionImpl(this.actions, null, labels, propertyKeys, true));
            }
            return new NodeKeyConstraintDefinition(this.actions, constraint, new IndexDefinitionImpl(this.actions, null, labels, propertyKeys, true));
        }
        if (constraint.isRelationshipPropertyExistenceConstraint()) {
            RelationTypeSchemaDescriptor descriptor = constraint.schema().asRelationshipTypeSchemaDescriptor();
            return new RelationshipPropertyExistenceConstraintDefinition(this.actions, constraint, RelationshipType.withName((String)tokenRead.relationshipTypeGetName(descriptor.getRelTypeId())), tokenRead.propertyKeyGetName(descriptor.getPropertyId()));
        }
        throw new IllegalArgumentException("Unknown constraint " + constraint);
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final KernelTransaction transaction;

        GDBSchemaActions(KernelTransaction transaction) {
            this.transaction = transaction;
        }

        @Override
        public IndexDefinition createIndexDefinition(Label[] labels, String indexName, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig, String ... propertyKeys) {
            try {
                FulltextSchemaDescriptor schema;
                TokenWrite tokenWrite = this.transaction.tokenWrite();
                String[] labelNames = (String[])Arrays.stream(labels).map(Label::name).toArray(String[]::new);
                int[] labelIds = new int[labels.length];
                tokenWrite.labelGetOrCreateForNames(labelNames, labelIds);
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKeys);
                if (indexType == org.neo4j.graphdb.schema.IndexType.FULLTEXT) {
                    schema = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])labelIds, (int[])propertyKeyIds);
                } else if (labelIds.length == 1) {
                    schema = SchemaDescriptors.forLabel((int)labelIds[0], (int[])propertyKeyIds);
                } else {
                    throw new IllegalArgumentException(indexType + " indexes can only be created with exactly one label, but got " + (labelIds.length == 0 ? "no" : String.valueOf(labelIds.length)) + " labels.");
                }
                IndexDescriptor indexReference = this.createIndex(indexName, (SchemaDescriptor)schema, indexType, indexConfig);
                return new IndexDefinitionImpl((InternalSchemaActions)this, indexReference, labels, propertyKeys, false);
            }
            catch (IllegalTokenNameException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), e);
            }
            catch (KernelException e) {
                throw new TransactionFailureException("Unknown error trying to create token ids", (Throwable)e);
            }
        }

        @Override
        public IndexDefinition createIndexDefinition(RelationshipType[] types, String indexName, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig, String ... propertyKeys) {
            try {
                FulltextSchemaDescriptor schema;
                TokenWrite tokenWrite = this.transaction.tokenWrite();
                String[] typeNames = (String[])Arrays.stream(types).map(RelationshipType::name).toArray(String[]::new);
                int[] typeIds = new int[types.length];
                tokenWrite.relationshipTypeGetOrCreateForNames(typeNames, typeIds);
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKeys);
                if (indexType == org.neo4j.graphdb.schema.IndexType.FULLTEXT) {
                    schema = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])typeIds, (int[])propertyKeyIds);
                } else if (typeIds.length == 1) {
                    schema = SchemaDescriptors.forRelType((int)typeIds[0], (int[])propertyKeyIds);
                } else {
                    throw new IllegalArgumentException(indexType + " indexes can only be created with exactly one relationship type, but got " + (types.length == 0 ? "no" : String.valueOf(types.length)) + " relationship types.");
                }
                IndexDescriptor indexReference = this.createIndex(indexName, (SchemaDescriptor)schema, indexType, indexConfig);
                return new IndexDefinitionImpl((InternalSchemaActions)this, indexReference, types, propertyKeys, false);
            }
            catch (IllegalTokenNameException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), e);
            }
            catch (KernelException e) {
                throw new TransactionFailureException("Unknown error trying to create token ids", (Throwable)e);
            }
        }

        @Override
        public IndexDefinition createIndexDefinition(AnyTokens tokens, String indexName, IndexConfig indexConfig) {
            try {
                AnyTokenSchemaDescriptor schema = SchemaDescriptors.forAnyEntityTokens((EntityType)(tokens == AnyTokens.ANY_LABELS ? EntityType.NODE : EntityType.RELATIONSHIP));
                IndexDescriptor indexDescriptor = this.createIndex(indexName, (SchemaDescriptor)schema, org.neo4j.graphdb.schema.IndexType.LOOKUP, indexConfig);
                if (tokens == AnyTokens.ANY_LABELS) {
                    return new IndexDefinitionImpl((InternalSchemaActions)this, indexDescriptor, new Label[0], new String[0], false);
                }
                return new IndexDefinitionImpl((InternalSchemaActions)this, indexDescriptor, new RelationshipType[0], new String[0], false);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), e);
            }
            catch (KernelException e) {
                throw new TransactionFailureException("Unknown error trying to create index", (Throwable)e);
            }
        }

        public IndexDescriptor createIndex(String indexName, SchemaDescriptor schema, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig) throws KernelException {
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withName(indexName).withIndexType(IndexType.fromPublicApi((org.neo4j.graphdb.schema.IndexType)indexType)).withIndexConfig(indexConfig);
            return this.transaction.schemaWrite().indexCreate(prototype);
        }

        @Override
        public void dropIndexDefinitions(IndexDefinition indexDefinition) {
            try {
                IndexDescriptor reference = SchemaImpl.getIndexReference(this.transaction.schemaRead(), this.transaction.tokenRead(), (IndexDefinitionImpl)indexDefinition);
                this.transaction.schemaWrite().indexDrop(reference);
            }
            catch (NotFoundException reference) {
            }
            catch (SchemaRuleNotFoundException | DropIndexFailureException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), (Throwable)e);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
        }

        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(IndexDefinition indexDefinition, String name, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig) {
            if (indexDefinition.isMultiTokenIndex()) {
                throw new ConstraintViolationException("A property uniqueness constraint does not support multi-token index definitions. That is, only a single label is supported, but the following labels were provided: " + IndexDefinitionImpl.labelNameList(indexDefinition.getLabels(), "", "."));
            }
            GDBSchemaActions.assertConstraintableIndexType("Property uniqueness", indexType);
            try {
                TokenWrite tokenWrite = this.transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(((Label)Iterables.single((Iterable)indexDefinition.getLabels())).name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, indexDefinition);
                LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])propertyKeyIds);
                IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName(name).withIndexType(IndexType.fromPublicApi((org.neo4j.graphdb.schema.IndexType)indexType)).withIndexConfig(indexConfig);
                ConstraintDescriptor constraint = this.transaction.schemaWrite().uniquePropertyConstraintCreate(prototype);
                return new UniquenessConstraintDefinition((InternalSchemaActions)this, constraint, indexDefinition);
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | AlreadyIndexedException | RepeatedSchemaComponentException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), (Throwable)e);
            }
            catch (IllegalTokenNameException e) {
                throw new IllegalArgumentException(e);
            }
            catch (TokenCapacityExceededKernelException e) {
                throw new IllegalStateException(e);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
            catch (KernelException e) {
                throw new TransactionFailureException("Unknown error trying to create token ids", (Throwable)e);
            }
        }

        private static void assertConstraintableIndexType(String constraintType, org.neo4j.graphdb.schema.IndexType indexType) {
            if (indexType != null && indexType != org.neo4j.graphdb.schema.IndexType.RANGE) {
                throw new IllegalArgumentException(constraintType + " constraints cannot be created with index type " + indexType + ".");
            }
        }

        @Override
        public ConstraintDefinition createNodeKeyConstraint(IndexDefinition indexDefinition, String name, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig) {
            if (indexDefinition.isMultiTokenIndex()) {
                throw new ConstraintViolationException("A node key constraint does not support multi-token index definitions. That is, only a single label is supported, but the following labels were provided: " + IndexDefinitionImpl.labelNameList(indexDefinition.getLabels(), "", "."));
            }
            GDBSchemaActions.assertConstraintableIndexType("Node key", indexType);
            try {
                TokenWrite tokenWrite = this.transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(((Label)Iterables.single((Iterable)indexDefinition.getLabels())).name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, indexDefinition);
                LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])propertyKeyIds);
                IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName(name).withIndexType(IndexType.fromPublicApi((org.neo4j.graphdb.schema.IndexType)indexType)).withIndexConfig(indexConfig);
                ConstraintDescriptor constraint = this.transaction.schemaWrite().nodeKeyConstraintCreate(prototype);
                return new NodeKeyConstraintDefinition((InternalSchemaActions)this, constraint, indexDefinition);
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | AlreadyIndexedException | RepeatedSchemaComponentException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), (Throwable)e);
            }
            catch (IllegalTokenNameException e) {
                throw new IllegalArgumentException(e);
            }
            catch (TokenCapacityExceededKernelException e) {
                throw new IllegalStateException(e);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
            catch (KernelException e) {
                throw new TransactionFailureException("Unknown error trying to create token ids", (Throwable)e);
            }
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(String name, Label label, String ... propertyKeys) {
            try {
                TokenWrite tokenWrite = this.transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(label.name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKeys);
                LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])propertyKeyIds);
                ConstraintDescriptor constraint = this.transaction.schemaWrite().nodePropertyExistenceConstraintCreate(schema, name);
                return new NodePropertyExistenceConstraintDefinition(this, constraint, label, propertyKeys);
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | RepeatedSchemaComponentException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), (Throwable)e);
            }
            catch (IllegalTokenNameException e) {
                throw new IllegalArgumentException(e);
            }
            catch (TokenCapacityExceededKernelException e) {
                throw new IllegalStateException(e);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
            catch (KernelException e) {
                throw new TransactionFailureException("Unknown error trying to create token ids", (Throwable)e);
            }
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(String name, RelationshipType type, String propertyKey) {
            try {
                TokenWrite tokenWrite = this.transaction.tokenWrite();
                int typeId = tokenWrite.relationshipTypeGetOrCreateForName(type.name());
                int[] propertyKeyId = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKey);
                RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType((int)typeId, (int[])propertyKeyId);
                ConstraintDescriptor constraint = this.transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(schema, name);
                return new RelationshipPropertyExistenceConstraintDefinition(this, constraint, type, propertyKey);
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | RepeatedSchemaComponentException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), (Throwable)e);
            }
            catch (IllegalTokenNameException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
            catch (KernelException e) {
                throw new TransactionFailureException("Unknown error trying to create token ids", (Throwable)e);
            }
        }

        @Override
        public void dropConstraint(ConstraintDescriptor constraint) {
            try {
                this.transaction.schemaWrite().constraintDrop(constraint);
            }
            catch (DropConstraintFailureException e) {
                throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)this.transaction.tokenRead()), (Throwable)((Object)e));
            }
            catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
        }

        @Override
        public String getUserMessage(KernelException e) {
            return e.getUserMessage((TokenNameLookup)this.transaction.tokenRead());
        }

        @Override
        public String getUserDescription(IndexDescriptor index) {
            return index == null ? null : index.userDescription((TokenNameLookup)this.transaction.tokenRead());
        }

        @Override
        public void assertInOpenTransaction() {
            this.transaction.assertOpen();
        }
    }
}

