/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.io.Closeable;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.parallel.ThreadExecutionContext;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.ReadSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageEngineIndexingBehaviour;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.Value;

public class ThreadExecutionContextRead
implements Read,
Closeable,
QueryContext {
    private final ThreadExecutionContext context;
    private final Read read;
    private final StorageReader reader;
    private final ReadSupport readSupport;
    private final DefaultPooledCursors pooledCursors;

    ThreadExecutionContextRead(ThreadExecutionContext context, Read read, StorageReader reader, StoreCursors storeCursors, Config config, StorageEngineIndexingBehaviour indexingBehaviour) {
        this.context = context;
        this.read = read;
        this.reader = reader;
        this.pooledCursors = new DefaultPooledCursors(reader, storeCursors, config, indexingBehaviour);
        this.readSupport = new ReadSupport(reader, this.pooledCursors, this);
    }

    public IndexReadSession indexReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.read.indexReadSession(index);
    }

    public TokenReadSession tokenReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.read.tokenReadSession(index);
    }

    public void nodeIndexSeek(QueryContext queryContext, IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws KernelException {
        this.read.nodeIndexSeek(queryContext, index, cursor, constraints, query);
    }

    public void relationshipIndexSeek(QueryContext queryContext, IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws KernelException {
        this.read.relationshipIndexSeek(queryContext, index, cursor, constraints, query);
    }

    public void nodeIndexScan(IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.read.nodeIndexScan(index, cursor, constraints);
    }

    public void relationshipIndexScan(IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.read.relationshipIndexScan(index, cursor, constraints);
    }

    public Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        return this.read.nodeLabelScan(label);
    }

    public PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws KernelException {
        return this.read.nodeLabelScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, PartitionedScan<NodeLabelIndexCursor> leadingPartitionScan, TokenPredicate query) throws KernelException {
        return this.read.nodeLabelScan(session, leadingPartitionScan, query);
    }

    public List<PartitionedScan<NodeLabelIndexCursor>> nodeLabelScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws KernelException {
        return this.read.nodeLabelScans(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public void nodeLabelScan(TokenReadSession session, NodeLabelIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.read.nodeLabelScan(session, cursor, constraints, query, cursorContext);
    }

    public void allNodesScan(NodeCursor cursor) {
        this.read.allNodesScan(cursor);
    }

    public Scan<NodeCursor> allNodesScan() {
        return this.read.allNodesScan();
    }

    public void singleNode(long reference, NodeCursor cursor) {
        this.read.singleNode(reference, cursor);
    }

    public PartitionedScan<NodeCursor> allNodesScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        return this.read.allNodesScan(desiredNumberOfPartitions, cursorContext);
    }

    public PartitionedScan<RelationshipScanCursor> allRelationshipsScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        return this.read.allRelationshipsScan(desiredNumberOfPartitions, cursorContext);
    }

    public boolean nodeExists(long reference) {
        return this.readSupport.nodeExistsWithoutTxState(reference, this.context.accessMode(), this.context.storeCursors(), this.context.cursorContext());
    }

    public long countsForNode(int labelId) {
        return this.read.countsForNodeWithoutTxState(labelId);
    }

    public long countsForNodeWithoutTxState(int labelId) {
        return this.read.countsForNodeWithoutTxState(labelId);
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.read.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId);
    }

    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        return this.read.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId);
    }

    public long nodesGetCount() {
        return this.read.nodesGetCount();
    }

    public long relationshipsGetCount() {
        return this.read.relationshipsGetCount();
    }

    public void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.read.singleRelationship(reference, cursor);
    }

    public void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.read.allRelationshipsScan(cursor);
    }

    public Scan<RelationshipScanCursor> allRelationshipsScan() {
        return this.read.allRelationshipsScan();
    }

    public PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws KernelException {
        return this.read.relationshipTypeScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, PartitionedScan<RelationshipTypeIndexCursor> leadingPartitionScan, TokenPredicate query) throws KernelException {
        return this.read.relationshipTypeScan(session, leadingPartitionScan, query);
    }

    public List<PartitionedScan<RelationshipTypeIndexCursor>> relationshipTypeScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws KernelException {
        return this.read.relationshipTypeScans(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public void relationshipTypeScan(TokenReadSession session, RelationshipTypeIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.read.relationshipTypeScan(session, cursor, constraints, query, cursorContext);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws KernelException {
        return this.read.nodeIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws KernelException {
        return this.read.relationshipIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    public long lockingNodeUniqueIndexSeek(IndexDescriptor index, NodeValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws KernelException {
        return this.read.lockingNodeUniqueIndexSeek(index, cursor, predicates);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws KernelException {
        return this.read.nodeIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws KernelException {
        return this.read.relationshipIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    public void singleRelationship(long reference, long sourceNodeReference, int type, long targetNodeReference, RelationshipScanCursor cursor) {
        this.read.singleRelationship(reference, sourceNodeReference, type, targetNodeReference, cursor);
    }

    public boolean relationshipExists(long reference) {
        return this.readSupport.relationshipExistsWithoutTx(reference, this.context.accessMode(), this.context.storeCursors(), this.context.cursorContext());
    }

    public void relationships(long nodeReference, long reference, RelationshipSelection selection, RelationshipTraversalCursor cursor) {
        this.read.relationships(nodeReference, reference, selection, cursor);
    }

    public void nodeProperties(long nodeReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        this.read.nodeProperties(nodeReference, reference, selection, cursor);
    }

    public void relationshipProperties(long relationshipReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        this.read.relationshipProperties(relationshipReference, reference, selection, cursor);
    }

    public boolean nodeDeletedInTransaction(long node) {
        return false;
    }

    public boolean relationshipDeletedInTransaction(long relationship) {
        return false;
    }

    public Value nodePropertyChangeInTransactionOrNull(long node, int propertyKeyId) {
        return null;
    }

    public Value relationshipPropertyChangeInTransactionOrNull(long relationship, int propertyKeyId) {
        return null;
    }

    public boolean transactionStateHasChanges() {
        return false;
    }

    @Override
    public void close() {
        this.pooledCursors.assertClosed();
        this.pooledCursors.release();
        this.reader.close();
    }

    public Read getRead() {
        return this.read;
    }

    public CursorFactory cursors() {
        return this.pooledCursors;
    }

    public ReadableTransactionState getTransactionStateOrNull() {
        return null;
    }

    public CursorContext cursorContext() {
        return this.context.cursorContext();
    }

    public MemoryTracker memoryTracker() {
        return EmptyMemoryTracker.INSTANCE;
    }

    public IndexMonitor monitor() {
        return this.context.monitor();
    }
}

