/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.lang.invoke.VarHandle;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.TransactionMemoryPool;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextCursorTracer;
import org.neo4j.kernel.impl.api.parallel.ThreadExecutionContextRead;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ThreadExecutionContext
implements ExecutionContext,
AutoCloseable {
    private static final String TRANSACTION_EXECUTION_TAG = "transactionExecution";
    private final CursorContext context;
    private final AccessMode accessMode;
    private final ExecutionContextCursorTracer cursorTracer = new ExecutionContextCursorTracer(PageCacheTracer.NULL, "transactionExecution");
    private final CursorContext ktxContext;
    private final ThreadExecutionContextRead contextRead;
    private final StoreCursors storageCursors;
    private final IndexMonitor monitor;
    private final MemoryTracker contextTracker;

    public ThreadExecutionContext(KernelTransactionImplementation ktx, CursorContextFactory contextFactory, StorageEngine storageEngine, Config config, IndexMonitor monitor, TransactionMemoryPool transactionMemoryPool) {
        this.ktxContext = ktx.cursorContext();
        this.context = contextFactory.create((PageCursorTracer)this.cursorTracer);
        this.accessMode = ktx.securityContext().mode();
        this.storageCursors = storageEngine.createStorageCursors(this.context);
        this.contextTracker = transactionMemoryPool.getPoolMemoryTracker();
        this.contextRead = new ThreadExecutionContextRead(this, ktx.dataRead(), ktx.newStorageReader(), this.storageCursors, config, storageEngine.indexingBehaviour());
        this.monitor = monitor;
    }

    public CursorContext cursorContext() {
        return this.context;
    }

    public AccessMode accessMode() {
        return this.accessMode;
    }

    public Read dataRead() {
        return this.contextRead;
    }

    public void complete() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.contextRead, this.storageCursors});
        this.cursorTracer.complete();
    }

    public void report() {
        this.mergeBlocked(this.cursorTracer);
    }

    public StoreCursors storeCursors() {
        return this.storageCursors;
    }

    public QueryContext queryContext() {
        return this.contextRead;
    }

    public MemoryTracker memoryTracker() {
        return this.contextTracker;
    }

    IndexMonitor monitor() {
        return this.monitor;
    }

    @Override
    public void close() {
        while (!this.cursorTracer.isCompleted()) {
            Thread.onSpinWait();
        }
        this.mergeUnblocked(this.cursorTracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeBlocked(ExecutionContextCursorTracer cursorTracer) {
        CursorContext cursorContext = this.ktxContext;
        synchronized (cursorContext) {
            this.mergeUnblocked(cursorTracer);
        }
        VarHandle.fullFence();
    }

    private void mergeUnblocked(ExecutionContextCursorTracer cursorTracer) {
        this.ktxContext.merge(cursorTracer.snapshot());
    }
}

