/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;

public class TransactionRangeDiagnostics
extends NamedDiagnosticsProvider {
    private final Database database;

    TransactionRangeDiagnostics(Database database) {
        super("Transaction log");
        this.database = database;
    }

    public void dump(DiagnosticsLogger logger) {
        DependencyResolver dependencyResolver = this.database.getDependencyResolver();
        FileSystemAbstraction fileSystem = (FileSystemAbstraction)dependencyResolver.resolveDependency(FileSystemAbstraction.class);
        LogFiles logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        try {
            logger.log("Transaction log files stored on file store: " + FileUtils.getFileStoreType((Path)logFiles.logFilesDirectory()));
            this.dumpTransactionLogInformation(logger, logFiles.getLogFile(), fileSystem);
            this.dumpCheckpointLogInformation(logger, logFiles.getCheckpointFile());
        }
        catch (Exception e) {
            logger.log("Error trying to dump transaction log files info.");
            logger.log(Exceptions.stringify((Throwable)e));
        }
    }

    private void dumpTransactionLogInformation(DiagnosticsLogger logger, LogFile logFile, FileSystemAbstraction fileSystem) throws IOException {
        logger.log("Transaction log files:");
        logger.log(" - existing transaction log versions " + logFile.getLowestLogVersion() + "-" + logFile.getHighestLogVersion());
        boolean foundTransactions = false;
        long logVersion = logFile.getLowestLogVersion();
        while (logFile.versionExists(logVersion) && !foundTransactions) {
            if (logFile.hasAnyEntries(logVersion)) {
                LogHeader header = logFile.extractHeader(logVersion);
                long firstTransactionIdInThisLog = header.getLastCommittedTxId() + 1L;
                logger.log(" - oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                foundTransactions = true;
            }
            ++logVersion;
        }
        if (!foundTransactions) {
            logger.log(" - no transactions found");
        } else {
            logger.log(" - files: (filename : creation date - size)");
            long totalSize = 0L;
            for (Path txLogFile : logFile.getMatchedFiles()) {
                long size = fileSystem.getFileSize(txLogFile);
                totalSize += size;
                logger.log(String.format("     %s: %s - %s", txLogFile.getFileName(), TransactionRangeDiagnostics.getFileCreationDate(txLogFile), ByteUnit.bytesToString((long)size)));
            }
            logger.log(" - total size of files: " + ByteUnit.bytesToString((long)totalSize));
        }
    }

    private void dumpCheckpointLogInformation(DiagnosticsLogger logger, CheckpointFile checkpointFile) throws IOException {
        logger.log("Checkpoint log files:");
        logger.log(" - existing checkpoint log versions " + checkpointFile.getLowestLogVersion() + "-" + checkpointFile.getHighestLogVersion());
        checkpointFile.findLatestCheckpoint((InternalLog)NullLog.getInstance()).ifPresentOrElse(checkpoint -> logger.log(" - last checkpoint: " + checkpoint), () -> logger.log(" - no checkpoints found"));
    }

    private static String getFileCreationDate(Path file) {
        try {
            Instant instant = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant();
            return Format.date((Instant)instant);
        }
        catch (IOException e) {
            return "<UNKNOWN>";
        }
    }
}

