/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public abstract class DatabaseReference
implements Comparable<DatabaseReference> {
    private static final Comparator<DatabaseReference> referenceComparator = Comparator.comparing(a -> a.alias().name(), String::compareToIgnoreCase);
    private static final Comparator<DatabaseReference> nullSafeReferenceComparator = Comparator.nullsLast(referenceComparator);

    public abstract NormalizedDatabaseName alias();

    public abstract boolean isPrimary();

    public abstract UUID id();

    @Override
    public int compareTo(DatabaseReference that) {
        return nullSafeReferenceComparator.compare(this, that);
    }

    public static final class Composite
    extends DatabaseReference {
        private final NormalizedDatabaseName alias;
        private final NamedDatabaseId namedDatabaseId;
        private final List<DatabaseReference> constituents;

        public Composite(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, Set<DatabaseReference> constituents) {
            this.alias = alias;
            this.namedDatabaseId = namedDatabaseId;
            this.constituents = constituents.stream().sorted().toList();
        }

        public NamedDatabaseId databaseId() {
            return this.namedDatabaseId;
        }

        @Override
        public NormalizedDatabaseName alias() {
            return this.alias;
        }

        @Override
        public boolean isPrimary() {
            return Objects.equals(this.alias.name(), this.namedDatabaseId.name());
        }

        @Override
        public UUID id() {
            return this.namedDatabaseId.databaseId().uuid();
        }

        public List<DatabaseReference> constituents() {
            return this.constituents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Composite composite = (Composite)o;
            return Objects.equals(this.alias, composite.alias) && Objects.equals(this.namedDatabaseId, composite.namedDatabaseId) && Objects.equals(this.constituents, composite.constituents);
        }

        public int hashCode() {
            return Objects.hash(this.alias, this.namedDatabaseId, this.constituents);
        }

        public String toString() {
            return "DatabaseReference.Composite{alias=" + this.alias + ", namedDatabaseId=" + this.namedDatabaseId + ", components=" + this.constituents + "}";
        }
    }

    public static final class Internal
    extends DatabaseReference {
        private final NormalizedDatabaseName alias;
        private final NamedDatabaseId namedDatabaseId;
        private final boolean primary;

        public Internal(NormalizedDatabaseName alias, NamedDatabaseId namedDatabaseId, boolean primary) {
            this.alias = alias;
            this.namedDatabaseId = namedDatabaseId;
            this.primary = primary;
        }

        public NamedDatabaseId databaseId() {
            return this.namedDatabaseId;
        }

        @Override
        public NormalizedDatabaseName alias() {
            return this.alias;
        }

        @Override
        public boolean isPrimary() {
            return this.primary;
        }

        @Override
        public UUID id() {
            return this.namedDatabaseId.databaseId().uuid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Internal internal = (Internal)o;
            return this.primary == internal.primary && Objects.equals(this.alias, internal.alias) && Objects.equals(this.namedDatabaseId, internal.namedDatabaseId);
        }

        public int hashCode() {
            return Objects.hash(this.alias, this.namedDatabaseId, this.primary);
        }

        public String toString() {
            return "DatabaseReference.Internal{alias=" + this.alias + ", namedDatabaseId=" + this.namedDatabaseId + ", primary=" + this.primary + "}";
        }
    }

    public static final class External
    extends DatabaseReference {
        private final NormalizedDatabaseName targetAlias;
        private final NormalizedDatabaseName alias;
        private final RemoteUri externalUri;
        private final UUID uuid;

        public External(NormalizedDatabaseName targetAlias, NormalizedDatabaseName alias, RemoteUri externalUri, UUID uuid) {
            this.targetAlias = targetAlias;
            this.alias = alias;
            this.externalUri = externalUri;
            this.uuid = uuid;
        }

        @Override
        public NormalizedDatabaseName alias() {
            return this.alias;
        }

        @Override
        public boolean isPrimary() {
            return false;
        }

        public RemoteUri externalUri() {
            return this.externalUri;
        }

        public NormalizedDatabaseName targetAlias() {
            return this.targetAlias;
        }

        @Override
        public UUID id() {
            return this.uuid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            External remote = (External)o;
            return Objects.equals(this.targetAlias, remote.targetAlias) && Objects.equals(this.alias, remote.alias) && Objects.equals(this.externalUri, remote.externalUri) && Objects.equals(this.uuid, remote.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.targetAlias, this.alias, this.externalUri, this.uuid);
        }

        public String toString() {
            return "DatabaseReference.External{remoteName=" + this.targetAlias + ", name=" + this.alias + ", remoteUri=" + this.externalUri + ", uuid=" + this.uuid + "}";
        }
    }
}

