/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.logging.Level;
import org.neo4j.values.storable.DurationValue;

public class CommunityTopologyGraphDbmsModel
implements TopologyGraphDbmsModel {
    protected final Transaction tx;

    public CommunityTopologyGraphDbmsModel(Transaction tx) {
        this.tx = tx;
    }

    public Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> getAllDatabaseAccess() {
        return this.tx.findNodes(DATABASE_LABEL).stream().collect(Collectors.toMap(CommunityTopologyGraphDbmsModel::getDatabaseId, CommunityTopologyGraphDbmsModel::getDatabaseAccess));
    }

    private static TopologyGraphDbmsModel.DatabaseAccess getDatabaseAccess(Node databaseNode) {
        String accessString = (String)databaseNode.getProperty("access", (Object)TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
        return Enum.valueOf(TopologyGraphDbmsModel.DatabaseAccess.class, accessString);
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String databaseName) {
        return this.getDatabaseIdByAlias0(databaseName).or(() -> this.getDatabaseIdBy("name", databaseName));
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID uuid) {
        return this.getDatabaseIdBy("uuid", uuid.toString());
    }

    @Override
    public Set<NamedDatabaseId> getAllDatabaseIds() {
        return this.tx.findNodes(DATABASE_LABEL).stream().map(CommunityTopologyGraphDbmsModel::getDatabaseId).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        Stream<DatabaseReference.Internal> primaryRefs = this.getAllDatabaseIds().stream().map(this::primaryRefFromDatabaseId);
        Stream<DatabaseReference.Internal> internalAliasRefs = this.getAllInternalDatabaseReferences0();
        Stream<DatabaseReference.Internal> internalRefs = Stream.concat(primaryRefs, internalAliasRefs);
        Stream<DatabaseReference.External> externalRefs = this.getAllExternalDatabaseReferences0();
        return Stream.concat(internalRefs, externalRefs).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReference.Internal> getAllInternalDatabaseReferences() {
        Stream<DatabaseReference.Internal> primaryRefs = this.getAllDatabaseIds().stream().map(this::primaryRefFromDatabaseId);
        Stream<DatabaseReference.Internal> localAliasRefs = this.getAllInternalDatabaseReferences0();
        return Stream.concat(primaryRefs, localAliasRefs).collect(Collectors.toUnmodifiableSet());
    }

    private DatabaseReference.Internal primaryRefFromDatabaseId(NamedDatabaseId databaseId) {
        NormalizedDatabaseName alias = new NormalizedDatabaseName(databaseId.name());
        return new DatabaseReference.Internal(alias, databaseId);
    }

    private Stream<DatabaseReference.Internal> getAllInternalDatabaseReferences0() {
        return this.tx.findNodes(DATABASE_NAME_LABEL).stream().flatMap(alias -> CommunityTopologyGraphDbmsModel.getTargetedDatabase(alias).flatMap(db -> this.createInternalReference((Node)alias, (NamedDatabaseId)db)).stream());
    }

    private Optional<DatabaseReference.Internal> createInternalReference(Node alias, NamedDatabaseId targetedDatabase) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_NAME, alias, "name", String.class));
            return Optional.of(new DatabaseReference.Internal(aliasName, targetedDatabase));
        });
    }

    @Override
    public Set<DatabaseReference.External> getAllExternalDatabaseReferences() {
        return this.getAllExternalDatabaseReferences0().collect(Collectors.toUnmodifiableSet());
    }

    private Stream<DatabaseReference.External> getAllExternalDatabaseReferences0() {
        return this.tx.findNodes(REMOTE_DATABASE_LABEL).stream().flatMap(alias -> this.createExternalReference((Node)alias).stream());
    }

    private Optional<DatabaseReference.External> createExternalReference(Node ref) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            String uriString = CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "url", String.class);
            NormalizedDatabaseName targetName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "target_name", String.class));
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "name", String.class));
            URI uri = URI.create(uriString);
            SocketAddress host = SocketAddressParser.socketAddress((URI)uri, (int)7687, SocketAddress::new);
            RemoteUri remoteUri = new RemoteUri(uri.getScheme(), List.of(host), uri.getQuery());
            String uuid = CommunityTopologyGraphDbmsModel.getPropertyOnNode("Remote Database alias", ref, "version", String.class);
            return Optional.of(new DatabaseReference.External(targetName, aliasName, remoteUri, UUID.fromString(uuid)));
        });
    }

    @Override
    public Optional<DatabaseReference> getDatabaseRefByAlias(String databaseName) {
        return this.getInternalDatabaseReference(databaseName).or(() -> this.getExternalDatabaseReference(databaseName));
    }

    @Override
    public Optional<DriverSettings> getDriverSettings(String databaseName) {
        return Optional.ofNullable(this.tx.findNode(REMOTE_DATABASE_LABEL, "name", (Object)databaseName)).flatMap(CommunityTopologyGraphDbmsModel::getDriverSettings);
    }

    @Override
    public Optional<ExternalDatabaseCredentials> getExternalDatabaseCredentials(String databaseName) {
        return Optional.ofNullable(this.tx.findNode(REMOTE_DATABASE_LABEL, "name", (Object)databaseName)).flatMap(CommunityTopologyGraphDbmsModel::getDatabaseCredentials);
    }

    private Optional<DatabaseReference> getInternalDatabaseReference(String databaseName) {
        Optional<Node> aliasNode = Optional.ofNullable(this.tx.findNode(DATABASE_NAME_LABEL, "name", (Object)databaseName));
        return aliasNode.flatMap(alias -> CommunityTopologyGraphDbmsModel.getTargetedDatabase(alias).flatMap(db -> this.createInternalReference((Node)alias, (NamedDatabaseId)db)));
    }

    private Optional<DatabaseReference> getExternalDatabaseReference(String databaseName) {
        return Optional.ofNullable(this.tx.findNode(REMOTE_DATABASE_LABEL, "name", (Object)databaseName)).flatMap(this::createExternalReference);
    }

    private Optional<NamedDatabaseId> getDatabaseIdByAlias0(String databaseName) {
        Optional<Node> node = Optional.ofNullable(this.tx.findNode(DATABASE_NAME_LABEL, "name", (Object)databaseName));
        return node.flatMap(CommunityTopologyGraphDbmsModel::getTargetedDatabase);
    }

    private Optional<NamedDatabaseId> getDatabaseIdBy(String propertyKey, String propertyValue) {
        try {
            Node node = this.tx.findNode(DATABASE_LABEL, propertyKey, (Object)propertyValue);
            if (node == null) {
                return Optional.empty();
            }
            String databaseName = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_LABEL.name(), node, "name", String.class);
            String databaseUuid = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_LABEL.name(), node, "uuid", String.class);
            return Optional.of(DatabaseIdFactory.from((String)databaseName, (UUID)UUID.fromString(databaseUuid)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<NamedDatabaseId> getTargetedDatabase(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            List targetDatabases = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TARGETS_RELATIONSHIP}).spliterator(), false).collect(Collectors.toList());
            return targetDatabases.stream().findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModel::getDatabaseId);
        });
    }

    private static Optional<DriverSettings> getDriverSettings(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            List connectsWith = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{CONNECTS_WITH_RELATIONSHIP}).spliterator(), false).collect(Collectors.toList());
            return connectsWith.stream().findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModel::createDriverSettings);
        });
    }

    private static Optional<ExternalDatabaseCredentials> getDatabaseCredentials(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            String username = CommunityTopologyGraphDbmsModel.getPropertyOnNode(REMOTE_DATABASE, aliasNode, "username", String.class);
            byte[] password = CommunityTopologyGraphDbmsModel.getPropertyOnNode(REMOTE_DATABASE, aliasNode, "password", byte[].class);
            byte[] iv = CommunityTopologyGraphDbmsModel.getPropertyOnNode(REMOTE_DATABASE, aliasNode, "iv", byte[].class);
            return Optional.of(new ExternalDatabaseCredentials(username, password, iv));
        });
    }

    private static DriverSettings createDriverSettings(Node driverSettingsNode) {
        DriverSettings.Builder builder = DriverSettings.builder();
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "ssl_enforced".toString(), Boolean.class).map(builder::withSSlEnforced);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_timeout".toString(), DurationValue.class).map(builder::withConnectionTimeout);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_max_lifetime".toString(), DurationValue.class).map(builder::withConnectionMaxLifeTime);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, DriverSettings.Keys.CONNECTION_POOL_ACQUISITION_TIMEOUT.toString(), DurationValue.class).map(builder::withConnectionPoolAcquisitionTimeout);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_pool_idle_test".toString(), DurationValue.class).map(builder::withConnectionPoolIdleTest);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "connection_pool_max_size".toString(), Integer.class).map(builder::withConnectionPoolMaxSize);
        CommunityTopologyGraphDbmsModel.getOptionalPropertyOnNode(DRIVER_SETTINGS, driverSettingsNode, "logging_level".toString(), String.class).map(Level::valueOf).map(builder::withLoggingLevel);
        return builder.build();
    }

    private static NamedDatabaseId getDatabaseId(Node databaseNode) {
        String name = (String)databaseNode.getProperty("name");
        UUID uuid = UUID.fromString((String)databaseNode.getProperty("uuid"));
        return DatabaseIdFactory.from((String)name, (UUID)uuid);
    }

    private static <T> Optional<T> getOptionalPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value;
        try {
            value = node.getProperty(key);
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        if (value == null) {
            return Optional.empty();
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return Optional.of(type.cast(value));
    }

    private static <T> T getPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value = node.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(String.format("%s has no property %s.", labelName, key));
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return type.cast(value);
    }

    private static <T> Optional<T> ignoreConcurrentDeletes(Supplier<Optional<T>> operation) {
        try {
            return operation.get();
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }
}

