/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.util.Map;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.impl.security.FileURLAccessRule;
import org.neo4j.kernel.impl.security.WebURLAccessRule;

public class URLAccessRules {
    private static final URLAccessRule ALWAYS_PERMITTED = (config, url) -> url;
    private static final URLAccessRule FILE_ACCESS = new FileURLAccessRule();
    private static final URLAccessRule WEB_ACCESS = new WebURLAccessRule();

    private URLAccessRules() {
    }

    public static URLAccessRule alwaysPermitted() {
        return ALWAYS_PERMITTED;
    }

    public static URLAccessRule fileAccess() {
        return FILE_ACCESS;
    }

    public static URLAccessRule webAccess() {
        return WEB_ACCESS;
    }

    public static URLAccessRule combined(Map<String, URLAccessRule> urlAccessRules) {
        return (config, url) -> {
            String protocol = url.getProtocol();
            URLAccessRule protocolRule = (URLAccessRule)urlAccessRules.get(protocol);
            if (protocolRule == null) {
                throw new URLAccessValidationError("loading resources via protocol '" + protocol + "' is not permitted");
            }
            return protocolRule.validate(config, url);
        };
    }
}

